/*
 * Decompiled with CFR 0.152.
 */
package kamicup.publication.webmanager.rss10;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import kamicup.publication.webmanager.rss10.Creator;
import kamicup.publication.webmanager.rss10.Date2;
import kamicup.relaxer.utils.v1_1b.IRNSContainer;
import kamicup.relaxer.utils.v1_1b.IRNode;
import kamicup.relaxer.utils.v1_1b.RNSContext;
import kamicup.relaxer.utils.v1_1b.RStack;
import kamicup.relaxer.utils.v1_1b.UJAXP;
import kamicup.relaxer.utils.v1_1b.URelaxer;
import kamicup.relaxer.utils.v1_1b.URelaxer2;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Item
implements Serializable,
Cloneable,
IRNSContainer,
IRNode {
    private RNSContext rNSContext_ = new RNSContext(this, "http://purl.org/rss/1.0/");
    private String about_;
    private String title_;
    private String link_;
    private Date2 date_;
    private Creator creator_;
    private String description_;
    private IRNode parentRNode_;

    public Item() {
        this.rNSContext_.declareNamespace("p1", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.about_ = "";
        this.title_ = "";
        this.link_ = "";
        this.description_ = "";
    }

    public Item(Item source) {
        this.setup(source);
    }

    public Item(RStack stack) {
        this.setup(stack);
    }

    public Item(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Item(Element element) {
        this.setup(element);
    }

    public Item(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Item(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Item(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Item(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Item(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Item(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Item source) {
        this.setAbout(source.getAbout());
        this.setTitle(source.getTitle());
        this.setLink(source.getLink());
        if (source.date_ != null) {
            this.setDate((Date2)source.getDate().clone());
        }
        if (source.creator_ != null) {
            this.setCreator((Creator)source.getCreator().clone());
        }
        this.setDescription(source.getDescription());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.rNSContext_.declareNamespace(element);
        this.about_ = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about");
        this.title_ = URelaxer.getElementPropertyAsString(stack.popElement());
        this.link_ = URelaxer.getElementPropertyAsString(stack.popElement());
        this.setDate(new Date2(stack));
        this.setCreator(new Creator(stack));
        this.description_ = URelaxer.getElementPropertyAsString(stack.popElement());
    }

    public Object clone() {
        return new Item(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElementNS("http://purl.org/rss/1.0/", "item");
        this.rNSContext_.setupNamespace(element);
        if (this.about_ != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", this.about_, this.rNSContext_);
        }
        URelaxer2.setElementPropertyByString(element, "http://purl.org/rss/1.0/", "title", this.title_, this.rNSContext_);
        URelaxer2.setElementPropertyByString(element, "http://purl.org/rss/1.0/", "link", this.link_, this.rNSContext_);
        this.date_.makeElement(element);
        this.creator_.makeElement(element);
        URelaxer2.setElementPropertyByString(element, "http://purl.org/rss/1.0/", "description", this.description_, this.rNSContext_);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 2));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 2));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 2));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 2));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 2));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final RNSContext rGetRNSContext() {
        return this.rNSContext_;
    }

    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    public final String getAbout() {
        return this.about_;
    }

    public final void setAbout(String about) {
        this.about_ = about;
    }

    public final String getTitle() {
        return this.title_;
    }

    public final void setTitle(String title) {
        this.title_ = title;
    }

    public final String getLink() {
        return this.link_;
    }

    public final void setLink(String link) {
        this.link_ = link;
    }

    public final Date2 getDate() {
        return this.date_;
    }

    public final void setDate(Date2 date) {
        this.date_ = date;
        if (date != null) {
            date.rSetParentRNode(this);
        }
    }

    public final Creator getCreator() {
        return this.creator_;
    }

    public final void setCreator(Creator creator) {
        this.creator_ = creator;
        if (creator != null) {
            creator.rSetParentRNode(this);
        }
    }

    public final String getDescription() {
        return this.description_;
    }

    public final void setDescription(String description) {
        this.description_ = description;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        String prefix = this.rNSContext_.getPrefixByUri("http://purl.org/rss/1.0/");
        buffer.append("<");
        URelaxer.makeQName(prefix, "item", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.about_ != null) {
            buffer.append(" ");
            this.rNSContext_.makeQName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", buffer);
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getAbout())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("<");
        URelaxer.makeQName(prefix, "title", buffer);
        buffer.append(">");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getTitle())));
        buffer.append("</");
        URelaxer.makeQName(prefix, "title", buffer);
        buffer.append(">");
        buffer.append("<");
        URelaxer.makeQName(prefix, "link", buffer);
        buffer.append(">");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getLink())));
        buffer.append("</");
        URelaxer.makeQName(prefix, "link", buffer);
        buffer.append(">");
        this.date_.makeTextElement(buffer);
        this.creator_.makeTextElement(buffer);
        buffer.append("<");
        URelaxer.makeQName(prefix, "description", buffer);
        buffer.append(">");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getDescription())));
        buffer.append("</");
        URelaxer.makeQName(prefix, "description", buffer);
        buffer.append(">");
        buffer.append("</");
        URelaxer.makeQName(prefix, "item", buffer);
        buffer.append(">");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        String prefix = this.rNSContext_.getPrefixByUri("http://purl.org/rss/1.0/");
        buffer.write("<");
        URelaxer.makeQName(prefix, "item", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.about_ != null) {
            buffer.write(" ");
            this.rNSContext_.makeQName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", buffer);
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getAbout())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write("<");
        URelaxer.makeQName(prefix, "title", buffer);
        buffer.write(">");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getTitle())));
        buffer.write("</");
        URelaxer.makeQName(prefix, "title", buffer);
        buffer.write(">");
        buffer.write("<");
        URelaxer.makeQName(prefix, "link", buffer);
        buffer.write(">");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getLink())));
        buffer.write("</");
        URelaxer.makeQName(prefix, "link", buffer);
        buffer.write(">");
        this.date_.makeTextElement(buffer);
        this.creator_.makeTextElement(buffer);
        buffer.write("<");
        URelaxer.makeQName(prefix, "description", buffer);
        buffer.write(">");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getDescription())));
        buffer.write("</");
        URelaxer.makeQName(prefix, "description", buffer);
        buffer.write(">");
        buffer.write("</");
        URelaxer.makeQName(prefix, "item", buffer);
        buffer.write(">");
    }

    public void makeTextElement(PrintWriter buffer) {
        String prefix = this.rNSContext_.getPrefixByUri("http://purl.org/rss/1.0/");
        buffer.print("<");
        URelaxer.makeQName(prefix, "item", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.about_ != null) {
            buffer.print(" ");
            this.rNSContext_.makeQName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", buffer);
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getAbout())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("<");
        URelaxer.makeQName(prefix, "title", buffer);
        buffer.print(">");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getTitle())));
        buffer.print("</");
        URelaxer.makeQName(prefix, "title", buffer);
        buffer.print(">");
        buffer.print("<");
        URelaxer.makeQName(prefix, "link", buffer);
        buffer.print(">");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getLink())));
        buffer.print("</");
        URelaxer.makeQName(prefix, "link", buffer);
        buffer.print(">");
        this.date_.makeTextElement(buffer);
        this.creator_.makeTextElement(buffer);
        buffer.print("<");
        URelaxer.makeQName(prefix, "description", buffer);
        buffer.print(">");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getDescription())));
        buffer.print("</");
        URelaxer.makeQName(prefix, "description", buffer);
        buffer.print(">");
        buffer.print("</");
        URelaxer.makeQName(prefix, "item", buffer);
        buffer.print(">");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getAboutAsString() {
        return URelaxer.getString(this.getAbout());
    }

    public String getTitleAsString() {
        return URelaxer.getString(this.getTitle());
    }

    public String getLinkAsString() {
        return URelaxer.getString(this.getLink());
    }

    public String getDescriptionAsString() {
        return URelaxer.getString(this.getDescription());
    }

    public void setAboutByString(String string) {
        this.setAbout(string);
    }

    public void setTitleByString(String string) {
        this.setTitle(string);
    }

    public void setLinkByString(String string) {
        this.setLink(string);
    }

    public void setDescriptionByString(String string) {
        this.setDescription(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList<Cloneable> classNodes = new ArrayList<Cloneable>();
        if (this.date_ != null) {
            classNodes.add(this.date_);
        }
        if (this.creator_ != null) {
            classNodes.add(this.creator_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://purl.org/rss/1.0/", "item")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer2.hasAttributeHungry(target, "http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about")) {
            return false;
        }
        $match$ = true;
        Element child = target.popElement();
        if (child == null) {
            return false;
        }
        if (!URelaxer2.isTargetElement(child, "http://purl.org/rss/1.0/", "title")) {
            return false;
        }
        $match$ = true;
        child = target.popElement();
        if (child == null) {
            return false;
        }
        if (!URelaxer2.isTargetElement(child, "http://purl.org/rss/1.0/", "link")) {
            return false;
        }
        $match$ = true;
        if (!Date2.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        if (!Creator.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        child = target.popElement();
        if (child == null) {
            return false;
        }
        if (!URelaxer2.isTargetElement(child, "http://purl.org/rss/1.0/", "description")) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Item.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Item.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

