/*
 * Decompiled with CFR 0.152.
 */
package kamicup.publication.webmanager.projects;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import kamicup.publication.webmanager.projects.Rss;
import kamicup.relaxer.utils.v1_1b.IRNSContainer;
import kamicup.relaxer.utils.v1_1b.IRNode;
import kamicup.relaxer.utils.v1_1b.RNSContext;
import kamicup.relaxer.utils.v1_1b.RStack;
import kamicup.relaxer.utils.v1_1b.UJAXP;
import kamicup.relaxer.utils.v1_1b.URelaxer;
import kamicup.relaxer.utils.v1_1b.URelaxer2;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Project
implements Serializable,
Cloneable,
IRNSContainer,
IRNode {
    private RNSContext rNSContext_ = new RNSContext(this, "http://kamicup.sourceforge.jp/xmlns/pubman");
    private String name_;
    private String url_;
    private String local_;
    private String author_;
    private String description_;
    private Rss rss_;
    private IRNode parentRNode_;

    public Project() {
        this.name_ = "";
        this.url_ = "";
        this.local_ = "";
        this.author_ = "";
        this.description_ = "";
    }

    public Project(Project source) {
        this.setup(source);
    }

    public Project(RStack stack) {
        this.setup(stack);
    }

    public Project(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Project(Element element) {
        this.setup(element);
    }

    public Project(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Project(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Project(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Project(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Project(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Project(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Project source) {
        this.setName(source.getName());
        this.setUrl(source.getUrl());
        this.setLocal(source.getLocal());
        this.setAuthor(source.getAuthor());
        this.setDescription(source.getDescription());
        if (source.rss_ != null) {
            this.setRss((Rss)source.getRss().clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.rNSContext_.declareNamespace(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.url_ = URelaxer.getAttributePropertyAsString(element, "url");
        this.local_ = URelaxer.getAttributePropertyAsString(element, "local");
        this.author_ = URelaxer.getAttributePropertyAsString(element, "author");
        this.description_ = URelaxer.getAttributePropertyAsString(element, "description");
        this.setRss(new Rss(stack));
    }

    public Object clone() {
        return new Project(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElementNS("http://kamicup.sourceforge.jp/xmlns/pubman", "project");
        this.rNSContext_.setupNamespace(element);
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.url_ != null) {
            URelaxer.setAttributePropertyByString(element, "url", this.url_);
        }
        if (this.local_ != null) {
            URelaxer.setAttributePropertyByString(element, "local", this.local_);
        }
        if (this.author_ != null) {
            URelaxer.setAttributePropertyByString(element, "author", this.author_);
        }
        if (this.description_ != null) {
            URelaxer.setAttributePropertyByString(element, "description", this.description_);
        }
        this.rss_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 2));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 2));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 2));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 2));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 2));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final RNSContext rGetRNSContext() {
        return this.rNSContext_;
    }

    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final String getUrl() {
        return this.url_;
    }

    public final void setUrl(String url) {
        this.url_ = url;
    }

    public final String getLocal() {
        return this.local_;
    }

    public final void setLocal(String local) {
        this.local_ = local;
    }

    public final String getAuthor() {
        return this.author_;
    }

    public final void setAuthor(String author) {
        this.author_ = author;
    }

    public final String getDescription() {
        return this.description_;
    }

    public final void setDescription(String description) {
        this.description_ = description;
    }

    public final Rss getRss() {
        return this.rss_;
    }

    public final void setRss(Rss rss) {
        this.rss_ = rss;
        if (rss != null) {
            rss.rSetParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        String prefix = this.rNSContext_.getPrefixByUri("http://kamicup.sourceforge.jp/xmlns/pubman");
        buffer.append("<");
        URelaxer.makeQName(prefix, "project", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.name_ != null) {
            buffer.append(" ");
            buffer.append("name");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        if (this.url_ != null) {
            buffer.append(" ");
            buffer.append("url");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getUrl())));
            buffer.append("\"");
        }
        if (this.local_ != null) {
            buffer.append(" ");
            buffer.append("local");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getLocal())));
            buffer.append("\"");
        }
        if (this.author_ != null) {
            buffer.append(" ");
            buffer.append("author");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getAuthor())));
            buffer.append("\"");
        }
        if (this.description_ != null) {
            buffer.append(" ");
            buffer.append("description");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDescription())));
            buffer.append("\"");
        }
        buffer.append(">");
        this.rss_.makeTextElement(buffer);
        buffer.append("</");
        URelaxer.makeQName(prefix, "project", buffer);
        buffer.append(">");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        String prefix = this.rNSContext_.getPrefixByUri("http://kamicup.sourceforge.jp/xmlns/pubman");
        buffer.write("<");
        URelaxer.makeQName(prefix, "project", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.name_ != null) {
            buffer.write(" ");
            buffer.write("name");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        if (this.url_ != null) {
            buffer.write(" ");
            buffer.write("url");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getUrl())));
            buffer.write("\"");
        }
        if (this.local_ != null) {
            buffer.write(" ");
            buffer.write("local");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getLocal())));
            buffer.write("\"");
        }
        if (this.author_ != null) {
            buffer.write(" ");
            buffer.write("author");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getAuthor())));
            buffer.write("\"");
        }
        if (this.description_ != null) {
            buffer.write(" ");
            buffer.write("description");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDescription())));
            buffer.write("\"");
        }
        buffer.write(">");
        this.rss_.makeTextElement(buffer);
        buffer.write("</");
        URelaxer.makeQName(prefix, "project", buffer);
        buffer.write(">");
    }

    public void makeTextElement(PrintWriter buffer) {
        String prefix = this.rNSContext_.getPrefixByUri("http://kamicup.sourceforge.jp/xmlns/pubman");
        buffer.print("<");
        URelaxer.makeQName(prefix, "project", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.name_ != null) {
            buffer.print(" ");
            buffer.print("name");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        if (this.url_ != null) {
            buffer.print(" ");
            buffer.print("url");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getUrl())));
            buffer.print("\"");
        }
        if (this.local_ != null) {
            buffer.print(" ");
            buffer.print("local");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getLocal())));
            buffer.print("\"");
        }
        if (this.author_ != null) {
            buffer.print(" ");
            buffer.print("author");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getAuthor())));
            buffer.print("\"");
        }
        if (this.description_ != null) {
            buffer.print(" ");
            buffer.print("description");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDescription())));
            buffer.print("\"");
        }
        buffer.print(">");
        this.rss_.makeTextElement(buffer);
        buffer.print("</");
        URelaxer.makeQName(prefix, "project", buffer);
        buffer.print(">");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getUrlAsString() {
        return URelaxer.getString(this.getUrl());
    }

    public String getLocalAsString() {
        return URelaxer.getString(this.getLocal());
    }

    public String getAuthorAsString() {
        return URelaxer.getString(this.getAuthor());
    }

    public String getDescriptionAsString() {
        return URelaxer.getString(this.getDescription());
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setUrlByString(String string) {
        this.setUrl(string);
    }

    public void setLocalByString(String string) {
        this.setLocal(string);
    }

    public void setAuthorByString(String string) {
        this.setAuthor(string);
    }

    public void setDescriptionByString(String string) {
        this.setDescription(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList<Rss> classNodes = new ArrayList<Rss>();
        if (this.rss_ != null) {
            classNodes.add(this.rss_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://kamicup.sourceforge.jp/xmlns/pubman", "project")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "name")) {
            return false;
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "url")) {
            return false;
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "local")) {
            return false;
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "author")) {
            return false;
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "description")) {
            return false;
        }
        $match$ = true;
        if (!Rss.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Project.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Project.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

