#!/usr/bin/env ruby 

$: << "./src"

require 'cgi'
require 'KakiRequestHandler.rb'
require 'config.rb'

unless $page_data_source then
	$page_data_source = Wiki::FilePageDataSource.new($data_dir)
	#$page_data_source = Wiki::PStorePageDataSource.new($data_dir)
	$page_data_source.use_cache = $use_cache 
	$page_data_source.use_memory_cache = $use_memory_cache 
end

$log_file = './access.log' unless $log_file 

class WikiCGI < CGI
	def main
		request_header = {}
		request_header["accept"] = [self.accept] if self.accept
		request_header["accept-charset"] = [self.accept_charset] if self.accept_charset
		request_header["accept-encoding"] = [self.accept_encoding] if self.accept_encoding
		request_header["accept-language"] = [self.accept_language] if self.accept_language
		request_header["cache-control"] = [self.cache_control] if self.cache_control
		request_header["from"] = [self.from] if self.from
		request_header["host"] = [self.host] if self.host
		request_header["negotiate"] = [self.negotiate] if self.negotiate
		request_header["pragma"] = [self.pragma] if self.pragma
		request_header["referer"] = [self.referer]  if self.referer
		request_header["user-agent"] = [self.user_agent] if self.user_agent

=begin 
		env = {}
		env["auth_type"] = [self.auth_type] if self.auth_type
		env["content_length"] = [self.content_length] if self.content_length
		env["content_type"] = [self.content_type] if self.content_type
		env["gateway_interface"] = [self.gateway_interface] if self.gateway_interface
		env["path_info"] = [self.path_info] if self.path_info
		env["path_translated"] = [self.path_translated] if self.path_translated
		env["query_string"] = [self.query_string] if self.query_string
		env["remote_addr"] = [self.remote_addr] if self.remote_addr
		env["remote_host"] = [self.remote_host] if self.remote_host
		env["remote_ident"] = [self.remote_ident] if self.remote_ident
		env["remote_user"] = [self.remote_user] if self.remote_user
		env["request_method"] = [self.request_method] if self.request_method
		env["script_name"] = [self.script_name] if self.script_name
		env["server_name"] = [self.server_name] if self.server_name
		env["server_port"] = [self.server_port] if self.server_port
		env["server_protocol"] = [self.server_protocol] if self.server_protocol
		env["server_softwar"] = [self.server_software] if self.server_software
=end

		write_log()

		app = KakiRequestHandler.new($page_data_source, File.basename(__FILE__));
		app.theme_dir = $theme_dir
		app.theme_base_url = $theme_base_url
		header, body = app.main(request_header, self.params)

		self.out(header) {
			body
		}
	end

	def write_log()
		if $log_file then
			log = self.remote_addr
			log += %Q! [#{Time.now.strftime("%d/%b/%Y:%H:%M:%S %Z")}]!
			log += %Q! "#{self.request_method}!
			log += %Q! #{self.script_name}#{ ('?' + self.query_string) if self.query_string.to_s.length > 0}!
			log += %Q! #{self.server_protocol}"!
			log += %Q! "#{self.referer.to_s.length > 0 ? self.referer : '-'}"!
			log += %Q! "#{self.user_agent}"!

			log += "\n"
			File.open($log_file, "a"){ |log_file|
				log_file.flock(File::LOCK_EX) 
				log_file << log 
				log_file.flock(File::LOCK_UN) 
			}
		end
	end
end

WikiCGI.new().main
