#!/usr/bin/env ruby

$: << "./src"

require 'webrick'
require 'KakiRequestHandler.rb'
require 'config.rb'
require 'KakiServ_config.rb'

$port_number = 8888 unless $port_number
server = WEBrick::HTTPServer.new( :Port => $port_number )

unless $page_data_source then
	$page_data_source = Wiki::FilePageDataSource.new($data_dir)
	#$page_data_source = Wiki::PStorePageDataSource.new($data_dir)
	$page_data_source.use_cache = $use_cache 
	$page_data_source.use_memory_cache = $use_memory_cache 
end

class WikiServlet < WEBrick::HTTPServlet::AbstractServlet
	def initialize(*argv)
		super(*argv)
	end

	def do_GET(req, res)
		app = KakiRequestHandler.new($page_data_source, 'kaki');
		app.theme_dir = $theme_dir
		app.theme_base_url = $theme_base_url
		header, body = app.main(req.header, req.query)
		header.each(){ |key, value|
			res[key] = value
		}
		res.body =  body
	end
	def do_POST(req, res)
		do_GET(req, res)
	end
end
server.mount("/", WikiServlet)
server.mount("/theme", WEBrick::HTTPServlet::FileHandler, "./theme")
server.mount("/files", WEBrick::HTTPServlet::FileHandler, "./files")

trap("INT"){ server.shutdown }
server.start

