#!/usr/bin/env ruby
#
# ==========================================================
# kagiPDF
# ==========================================================
# :Author: SAKIMA Kimihisa
# :Contact: sakima at hooktail.org
# :Date: $Date: 2007/03/10 20:37:33 $
# :Revision: $Revision: 1.10 $
#
# 書式
# ====
#
#   通常モード
#     kagipdf.rb [OPTION] infile
#
#   フィルタモード
#     kagipdf.rb [OPTION] < stream
#     stream | kagipdf.rb [OPTION]
#
# オプション
# ==========
#
#   -o <string>     # ファイル名指定
#   -k <type>       # 出力latexソース文字コード指定
#   -q              # コンソールにエラーメッセージを出さない
#   -c              # pdfファイルのみ残してtexソースやdviファイルは削除
#   -l              # 中間ファイルをすべて残す
#   --notex         # latexコンパイルをしない
#   --nopdf         # pdfを生成しない
#   --noeps         # epsを生成しない
#   --strict        # 拡張処理を行わない
#   --style <type>  # スタイル指定
#   --help          # ヘルプを表示
#   --version       # バージョンを表示

require 'nkf'
require 'optparse'

# ===============
# オプション処理
# ===============
opt = OptionParser.new
Version = "0.5.0 (2007-03-xx)"
OPTS = {}
# 入力ファイル名指定
opt.on('-o VAL', 'Place output in file VAL.'){|v|
  OPTS[:o] = v
}
# 出力latexソース文字コード指定
opt.on('-k VAL', 'Specify the text encoding for output.'){|v|
  OPTS[:k] = v
}
# コンソールにエラーメッセージを出さない
opt.on('-q', 'Do not report any system messages.'){|v|
  OPTS[:q] = v
}
# pdfファイルのみ残してtexソースやdviファイルは削除
opt.on('-c', 'Make PDF file only.'){|v|
  OPTS[:c] = v
}
# 中間ファイルをすべて残す
opt.on('-l', 'Leese All.'){|v|
  OPTS[:l] = v
}
# latexコンパイルをしない
opt.on('--notex', 'Do not platex compileing.'){|v|
  OPTS[:notex] = v
}
# pdfを生成しない
opt.on('--nopdf', 'Do not generate PDF file.'){|v|
  OPTS[:nopdf] = v
}
# epsを生成しない
opt.on('--noeps', 'Do not generate EPS file from JPEG, PNG, GIF images.'){|v|
  OPTS[:noeps] = v
}
# 拡張処理を行わない
opt.on('--strict', 'Strict reStructuredText mode.'){|v|
  OPTS[:strict] = v
}
# スタイル指定
OPTS[:style] = "hooktail"  # デフォルト
opt.on('--style VAL'){|v|
  OPTS[:style] = v
}
opt.parse!(ARGV)

# =======
# 初期化
# =======
begin
  if FileTest::symlink?(__FILE__) then
    org_path = File::dirname(File::readlink(__FILE__))
  else
    org_path = File::dirname(__FILE__)
  end
  $:.unshift(org_path.untaint)
  require 'extmath'
  require 'arrangetex'
  if $stdin.tty?
    # 標準入力が端末の場合
    in_file  = ARGV.shift
    contents = open(in_file){ |io| io.read }
  else
    # パイプ・リダイレクトからの実行
    in_file  = "kagipdf_default.txt"  # 出力用ファイル名をセット
    contents = $stdin.read            # 標準入力から読み取り
    OPTS[:q] = true                   # Quiet operation
    #OPTS[:c] = true                   # Clean operation
  end
  in_file  = OPTS[:o] if OPTS[:o]  # ファイル名指定オプションがあれば
  out_file = File.basename(in_file, ".*")  # 拡張子を取り除く
  out_file_tmp  = out_file + ".tmp"
  out_file_reST = out_file + ".reST"
  out_file_tex  = out_file + ".tex"
  out_file_pdf  = out_file + ".pdf"
rescue Exception
  print "[error] File not found, exit.\n"
  exit 1
end

# 入力ファイルの文字コードをUTF-8にする
contents = NKF.nkf("-wdm0", contents)

# -q オプションがあればコマンドの標準出力・標準エラーを捨てる
cmd_stream = " > /dev/null 2>&1" if OPTS[:q]

# ===========
# メイン処理
# ===========

# TeX数式拡張等の処理
unless OPTS[:strict]
  e = ExtMath.new
  contents = e.inline_math(contents)
  contents = e.display_math(contents)

  contents = figure(contents) unless OPTS[:noeps]
  contents = atat(contents)
  contents = etc(contents, OPTS[:style])
end
File.open(out_file_reST, "w"){ |file|
  file.write contents
}

# rst2latex.pyを実行
# ===================
rstopt1 = "-o utf-8 --use-latex-docinfo --use-latex-footnotes"
rstopt2 = "--use-latex-toc" unless OPTS[:style] == "hooktail"
rstopt3 = "--hyperlink-color black" if OPTS[:style] == "thesis"
system("rst2latex.py #{rstopt1} #{rstopt2} #{rstopt3} #{out_file_reST} #{out_file_tex} #{cmd_stream};")

# latexソース整形
texsource = open(out_file_tex){ |io| io.read }
texsource = documentclass(texsource, OPTS[:style])  # クラス
texsource = preamble(texsource, OPTS[:style])       # プリアンブル
texsource = textitle(texsource, OPTS[:style])       # タイトル
texsource = texbody(texsource, OPTS[:style])        # 本文

# latexソース文字コードの指定
if OPTS[:k] == "s"
  texsource = NKF.nkf("-scm0", texsource)
elsif OPTS[:k] == "e"
  texsource = NKF.nkf("-edm0", texsource)
elsif OPTS[:k] == "u"
  texsource = NKF.nkf("-wdm0", texsource)
elsif RUBY_PLATFORM =~ /cygwin/  # cygwin環境ならShift_JIS
  texsource = NKF.nkf("-scm0", texsource)
else  # デフォルトはEUC-JP
  texsource = NKF.nkf("-edm0", texsource)
end

# 整形したlatexソースをファイル出力
File.open(out_file_tex, "w"){ |file|
  file.write texsource
}

# platexを実行 # -> 【要検討】メソッド化
# =============
unless OPTS[:notex]
  # コンパイルは2回連続
  2.times{
    # 10秒超過もしくはファイルサイズ2048バイト超過で処理打ち切り
    # platexコンパイルはエラーが出ても途中で止めない
    system("ulimit -t 10 -f 2048 #{cmd_stream};
            platex -interaction=nonstopmode #{out_file_tex} #{cmd_stream}" )
  }
end

# dvipdfmxを実行 # -> 【要検討】メソッド化
# ===============
unless OPTS[:nopdf] || OPTS[:notex]
  system("dvipdfmx #{out_file} #{cmd_stream}")
end
=begin
def do_platex
end

def do_dvipdfmx
end

case usr_option
when "norex"
when 
=end

# 要らないファイルがあれば消す
unwanted = [".tmp", ".aux", ".log", ".out", ".reST", ".toc"]
if OPTS[:c]
  unwanted.push(".tex").push(".dvi")
elsif OPTS[:l]
  unwanted.clear
end
unwanted.each {|ext|
  rmfile = out_file + ext
  File.delete(rmfile) if FileTest.exist?(rmfile)
}
