# :Author: SAKIMA Kimihisa
# :Contact: sakima at hooktail.org
# :Date: $Date: 2007/03/10 20:37:33 $
# :Revision: $Revision: 1.3 $

$KCODE = 'UTF8'
require 'digest/md5'

class ExtMath
  # インライン数式（$...$）、その他を置換
  def inline_math(buf)
    buf.gsub!(/\\\$/, " <dollar> ")  # \$ を <dollar> に置換
    
    re_inlinemath = /\$(.*?)\$/  # インライン数式
    re_toalign = /\\\\/  # align環境へ移行する
    re_tag = /\\tag\{(.*?)\}/  # \tag{*}
    re_reference = /(\\ref\{.*?\})/  # \ref{*}
    re_cite = /(\\cite\{.*?\})/ # \cite{*}
    
    inlineEquations = Array.new  # 数式格納用配列
    
    # 数式を配列に格納
    inlineEquations << buf.scan(re_inlinemath)
    inlineEquations << buf.scan(re_reference)
    inlineEquations << buf.scan(re_cite)
    
    inlineEquations.flatten!.uniq!
    
    # |md5値| に置換
    buf.gsub!(re_inlinemath){ "|#{Digest::MD5.hexdigest($1)}|" }
    buf.gsub!(re_reference){ " |#{Digest::MD5.hexdigest($1)}| " }
    buf.gsub!(re_cite){ " |#{Digest::MD5.hexdigest($1)}| " }
    
    # 対応するreStructuredTextを最後尾に出力
    while inlineEquations.first
      equation = inlineEquations.shift
      case equation
      when re_tag
        # \tag{*} は $...$ 環境で使えないので数字にする
        buf << "\n.. |#{Digest::MD5.hexdigest(equation)}| raw:: latex\n\n"
        buf << "   $" + equation.gsub(re_tag) { "(" + $1 + ")" } + "$\n\n\n"
      when re_toalign
        # 数式中に \\ を含むものは align 環境にし & は取り除く 
        buf << "\n.. |" + Digest::MD5.hexdigest(equation) + "| raw:: latex\n\n"
        buf << "   \\begin{align*}" + equation.gsub(/&/,"") + "\\end{align*}\n\n\n"
      when re_reference
        buf << "\n.. |#{Digest::MD5.hexdigest(equation)}| raw:: latex\n\n   #{equation}\n\n\n"
      else
        buf << "\n.. |#{Digest::MD5.hexdigest(equation)}| raw:: latex\n\n   $#{equation}$\n\n\n"
      end
    end
    
    buf = buf.gsub(/ <dollar> /, "\$")  # <dollar> を $ に置換
  end

  # ディスプレイ数式（<tex>...</tex>）を置換
  def display_math(buf)
    regexp_dispmath = /\s*?<(\w+?)(\[\w+?\])?>(.*?)<\/(\w+?)>/m  # ディスプレイ数式
    buf = buf.gsub(regexp_dispmath){ DisplayMathDirective.new($1, $2, $3, $4).trans }
  end
end

# ディスプレイ数式ディレクティブ
class DisplayMathDirective
  def initialize(begin_tag, tag_opt, matter, end_tag)
    @matter = matter
    unless begin_tag == end_tag
      error_msg = "\n[kagiPDF Error] Tags mismatched (<#{begin_tag}> and </#{end_tag}>)."
      return error_msg
    end
    if /\\label\{.*?\}/ =~ @matter
      @tag = "align"
    elsif begin_tag == "tex"
      @tag = "align*"
    else
      @tag = begin_tag
    end
  end

  # rawディレクティブに変換
  def trans
    "\n\n.. raw:: latex\n\n   \\begin\{#{@tag}\}#{@tag_opt}\n" +
    @matter.gsub(/^/m, "   ").gsub(/^\s*\n/m, "") +
    "   \\end\{#{@tag}\}\n"
  end
end
