# :Author: SAKIMA Kimihisa
# :Contact: sakima@hooktail.org
# :Date: $Date: 2005/10/24 11:06:37 $
#--
$KCODE = "EUC"


# ==========================================================
# ɥȥ饹
# ==========================================================
def documentclass(buf, style)
  
  if style == "report"
    pkg_name = "kagipdf_report"
    class_name = "jsarticle"
    class_opt = "11pt,a4paper"
  elsif style == "thesis"
    pkg_name = "kagipdf_thesis"
    class_name = "jsbook"
    class_opt = "11pt,a4paper,oneside,openany"
  else
    pkg_name = "kagipdf_hooktail"
    class_name = "jsarticle"
    class_opt = "11pt,a4paper"
  end
  
  # ɥȥ饹ִ\usepakage{pkg_name} ɲ
  buf.sub!(/^\\documentclass.*$/,
  "\\documentclass\[#{class_opt}\]\{#{class_name}\}\n\\usepackage\{#{pkg_name}\}")
  
  return buf
  
end


# ==========================================================
# ץꥢ֥
# ==========================================================
def preamble(buf, style)
  
  # color, graphicx ѥåФ dvipdfm ץɲ
  buf.sub!(/\\usepackage\{color\}/, "\\usepackage\[dvipdfm\]\{color\}")
  buf.sub!(/\\usepackage\{graphicx\}/, "\\usepackage\[dvipdfm\]\{graphicx\}")

  # Ⱥѥå̿
  buf.sub!(/\\usepackage\[DIV12\]\{typearea\}\n/, "")
  buf.sub!(/\\usepackage\{ae\}\n/, "")
  buf.sub!(/\\usepackage\[.*\]\{inputenc\}\n/, "")
  buf.sub!(/\\usepackage\{babel\}\n/, "")
  buf.sub!(/\\usepackage\{aeguill\}\n/, "")

  # amssymb, bm ѥåɲ
  buf.sub!(/\\usepackage\{amsmath\}/, "\\usepackage\{amsmath,amssymb,bm\}")

  # hyperref ѥåΥץѹ
  buf.sub!(/\\usepackage\[(colorlinks=true,linkcolor=blue,urlcolor=blue)\]\{hyperref\}/){
    "\\usepackage\[dvipdfm,bookmarks=true,bookmarksnumbered=true,pdfstartview=\{FitH -32768\}," +
    $1 +
    "\]\{hyperref\}" +
    "\\ifnum 42146=\\euc\"A4A2 \\AtBeginDvi\{\\special\{pdf:tounicode EUC-UCS2\}\}\\else" +
    "\\AtBeginDvi\{\\special\{pdf:tounicode 90ms-RKSJ-UCS2\}\}\\fi  %\""
  }
  
  return buf
  
end


# ==========================================================
# latexȥ
# ==========================================================
def textitle(buf, style)
  
  if style == "hooktail"
    # authorˡ֡ʪΤץȡפä
    buf.gsub!(/\\author\{(.*?)\}/){"\\author\{" + $1 + "ʪΤץ\}"}
    buf.gsub!(/pdfauthor=\{(.*?)\}/){"pdfauthor=\{" + $1 + "ʪΤץ\}"}
  end
  
  # :Date: today  \date{\today}
  buf.gsub!(/\\date\{today\}/, "\\date\{\\today\}")
  
  return buf
  
end


# ==========================================================
# latexʸ
# ==========================================================
def texbody(buf, style)
 
  # ̾ĤǤ
  buf.gsub!(/\\includegraphics/, "\\includegraphics\[scale=0\.55\]")
#  buf.gsub!(/\\includegraphics/, "\\includegraphics\[width=10cm\]")
  buf.gsub!(/\\includegraphics(.*\}$)/){
    "\\begin\{center\}\\includegraphics" + $1 + "\\end\{center\}"
  }

  # \end{quote} \end{itemize} θβԤ
  buf.gsub!(/(^\\end\{quote\}).*?\n/){ $1 }
  buf.gsub!(/(^\\end\{itemize\}).*?\n/){ $1 }
  buf.gsub!(/(^\\end\{list\}).*?\n/){ $1 }

  # \href{...} % 򥨥
  buf = buf.gsub(/\\href\{(.*?)\}/){
    "\\href\{" + $1.gsub(/%/, "\\%") + "\}"
  }

  unless style == "hooktail"
    buf.gsub!(/\\section\*\{/, "\\section\{")
    buf.gsub!(/\\subsection\*\{/, "\\subsection\{")
  end
  
  if style == "thesis"
    buf.sub!(/\\begin\{center\}.*?\\begin\{tabularx\}\{\\docinfowidth\}\{lX\}.*?\\end\{tabularx\}.*?\\end\{center\}.*?\\setlength\{\\locallinewidth\}\{\\linewidth\}.*?\\tableofcontents.*?\\bigskip/m, "\\frontmatter\n\\tableofcontents\n\\mainmatter")
    buf.gsub!(/\\section/, "\\chapter")
    buf.gsub!(/\\subsection/, "\\section")
    buf.gsub!(/\\subsubsection/, "\\subsection")
  end
  
  return buf
  
end
