%{
/* $Id */
/*---------------------------------------------------------------------------*/
/**
 *  @file    secs2y.y
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2001 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*---------------------------------------------------------------------------*/

#include "beelib.h"
#include "BS2SecsFuncs.h"
#include "tcl.h"

#define SFCODE(s,f)         (((s) << 8) | (f))
#ifndef WIN32
#define _tcscpy strcpy
#endif

char * myinputptr = NULL;
char * myinputlim = NULL;
Tcl_Interp * myinterp = NULL;
int SuffixCode = 0;

MessageFormatInfo msginfo;
static TCHAR _streamFunction[32];

extern char * yytext;
extern void * my_alpg;

extern int  yyparse();
void yyerror(char * s);
void warning(char * s, char * t);

%}

%union {
    char *    string;         /* have to free memory */
    int       ival;
    unsigned  int uival;
#ifdef _MSC_VER
    __int64   llval;
    unsigned __int64 ullval;
#else
    long long          llval;
    unsigned long long ullval;
#endif
    double    dval;
    float     fval;
    void *    atomdata;        /* */
    void *    itemdata;        /* */
    void *    secs2msg;        /* */
    void *    secs2item;       /* */
    void *    secs2buf;        /* */
    void *    secs2header;     /* */
}

%token MESSAGE SXXFXX LBRACE RBRACE SEMICOLON LPAREN RPAREN NAME WAIT NOWAIT
%token HEX INTEGER UINTEGER STRING JSTRING BIN REAL FLOAT
%token LONGLONG ULONGLONG BOOLEAN
%token INT1 INT2 UINT1 UINT2
%token S1F0  S1F1  S1F2  S1F3  S1F4  S1F5  S1F6  S1F7  S1F8  S1F9
%token S1F10 S1F11 S1F12 S1F13 S1F14 S1F15 S1F16 S1F17 S1F18 S1F19 S1F20
%token S2F0  S2F1  S2F2  S2F3  S2F4  S2F5  S2F6  S2F7  S2F8  S2F9
%token S2F10 S2F11 S2F12 S2F13 S2F14 S2F15 S2F16 S2F17 S2F18 S2F19
%token S2F20 S2F21 S2F22 S2F23 S2F24 S2F25 S2F26 S2F27 S2F28 S2F29
%token S2F30 S2F31 S2F32 S2F33 S2F34 S2F35 S2F36 S2F37 S2F38 S2F39
%token S2F40 S2F41 S2F42 S2F43 S2F44 S2F45 S2F46 S2F47 S2F48
%token S2F49 S2F50 S2F65 S2F66
%token S3F0  S3F1  S3F2  S3F3  S3F4  S3F5  S3F6  S3F7  S3F8  S3F9
%token S3F10 S3F11 S3F12 S3F13 S3F14 S3F15 S3F16 S3F17 S3F18 S3F19
%token S3F20 S3F21 S3F22 S3F23 S3F24 S3F25 S3F26 S3F27 S3F28 S3F29
%token S3F30 S3F31 S3F32
%token S4F0  S4F1  S4F2  S4F3  S4F5  S4F7  S4F9  S4F11 S4F13 S4F15
%token S4F17 S4F18 S4F19 S4F20 S4F21 S4F22 S4F23 S4F24 S4F25 S4F26
%token S4F27 S4F29 S4F31 S4F33 S4F35 S4F37 S4F39 S4F41
%token S5F0  S5F1  S5F2  S5F3  S5F4  S5F5  S5F6  S5F7  S5F8 S5F9
%token S5F10 S5F11 S5F12 S5F13 S5F14 S5F15 S5F16 S5F17 S5F18
%token S6F0  S6F1  S6F2  S6F3  S6F4  S6F5  S6F6  S6F7  S6F8  S6F9
%token S6F10 S6F11 S6F12 S6F13 S6F14 S6F15 S6F16 S6F17 S6F18 S6F19
%token S6F20 S6F21 S6F22 S6F23 S6F24 S6F25 S6F26 S6F27 S6F28 S6F29
%token S6F30
%token S7F0  S7F1  S7F2  S7F3  S7F4  S7F5  S7F6  S7F7  S7F8  S7F9
%token S7F10 S7F11 S7F12 S7F13 S7F14 S7F15 S7F16 S7F17 S7F18 S7F19
%token S7F20 S7F21 S7F22 S7F23 S7F24 S7F25 S7F26 S7F27 S7F28 S7F29
%token S7F30 S7F31 S7F32 S7F33 S7F34 S7F35 S7F36
%token S8F0  S8F1  S8F2  S8F3  S8F4
%token S9F0  S9F1 S9F3  S9F5  S9F7  S9F9 S9F11 S9F13
%token S10F0 S10F1 S10F2 S10F3 S10F4 S10F5 S10F6 S10F7 S10F9 S10F10
%token S11F0
%token S12F0  S12F1  S12F2  S12F3  S12F4  S12F5  S12F6  S12F7  S12F8  S12F9
%token S12F10 S12F11 S12F12 S12F13 S12F14 S12F15 S12F16 S12F17 S12F18 S12F19
%token S13F0  S13F1  S13F2  S13F3  S13F4  S13F5  S13F6  S13F7  S13F8  S13F9
%token S13F10 S13F11 S13F12 S13F13 S13F14 S13F15 S13F16
%token S14F0  S14F1  S14F2  S14F3  S14F4  S14F5  S14F6  S14F7  S14F8  S14F9
%token S14F10 S14F11 S14F12 S14F13 S14F14 S14F15 S14F16 S14F17 S14F18 S14F19
%token S14F20 S14F21 S14F22 S14F23 S14F24 S14F25 S14F26 S14F27 S14F28
%token S15F0 S15F1 S15F2 S15F3 S15F4 S15F5 S15F6 S15F7 S15F8 S15F9 S15F10
%token S15F11 S15F12 S15F13 S15F14 S15F15 S15F16 S15F17 S15F18 S15F19 S15F20
%token S15F21 S15F22 S15F23 S15F24 S15F25 S15F26 S15F27 S15F28 S15F29 S15F30
%token S15F31 S15F32 S15F33 S15F34 S15F35 S15F36 S15F37 S15F38 S15F39 S15F40
%token S15F41 S15F42 S15F43 S15F44 S15F45 S15F46 S15F47 S15F48
%token S16F0 S16F1 S16F2 S16F3 S16F4 S16F5 S16F6 S16F7  S16F8  S16F9 S16F10
%token S16F11 S16F12 S16F13 S16F14 S16F15 S16F16 S16F17 S16F18 S16F19 S16F20
%token S16F21 S16F22 S16F23 S16F24 S16F25 S16F26 S16F27 S16F28 S16F29 S16F30
%token S17F0 S17F1 S17F2 S17F3 S17F4 S17F5 S17F6 S17F7 S17F8 S17F9 S17F10
%token S17F11 S17F12 S17F13 S17F14
%token S18F0 S18F1 S18F2 S18F3 S18F4 S18F5 S18F6 S18F7 S18F8 S18F9 S18F10
%token S18F11 S18F12 S18F13 S18F14
%token CARRIERS

%type <ival>   BOOLEAN HEX INTEGER INT1 INT2 int_ex
%type <uival>  UINTEGER UINT1 UINT2
%type <llval>  LONGLONG
%type <ullval> ULONGLONG
%type <dval>   REAL
%type <fval>   FLOAT
%type <string> STRING NAME SXXFXX JSTRING
%type <secs2buf> secs2_message
%type <secs2header> transaction
%type <itemdata> user_atoms user_atom user_top_atom atom_list
%type <itemdata> acka_list
%type <itemdata> alarm_data alarm_data_list alarm_datum alid_list alids
%type <itemdata> annotated_data annotated_data_list annotated_datum
%type <itemdata> annotated_report annotated_report_list annotated_reports
%type <itemdata> attrdata_list attrdata_lists attrdatum attrinfo_list
%type <itemdata> attr_decl attribute attributes attrid_list attrids
%type <itemdata> car_slot car_slots carrier_mf carslot_list cattr
%type <itemdata> cattr_list cattrs ceid_list ceids cmd_parm
%type <itemdata> cmd_parameters cmdparm_list comp_time comp_time_list
%type <itemdata> comp_times colhdr_list colhdr_s cpval_list cpvals
%type <itemdata> create_prjob create_prjob_list create_prjobs ctag_ack
%type <itemdata> dvdata dvdata_list dvdatum dvval_list dvval_set
%type <itemdata> ecid_list ecids ecv_data ecv_data_list ecv_datum ecv_list
%type <itemdata> ecvs ecv_decl ecv_decl_list ecv_decl_set
%type <itemdata> ercmd_result_list ercmd_results ercmd_result
%type <itemdata> error_decl error_list errors event_data event_data_list
%type <itemdata> event_datum event_report event_report_list event_reports
%type <itemdata> exrecvra_list exrecvra_s
%type <itemdata> fcnid_list fcnids fildat_list fildat_list_decl formatted_var
%type <itemdata> formatted_var_list formatted_variables ho_result
%type <itemdata> limit_list limit_attr_list limit_attr limit_ack_list
%type <itemdata> limit_ack limit_ack_set limit_decl limit_decl_list
%type <itemdata> limit_decl_s limit_def limit_defs limit_def_list
%type <itemdata> mapdata mapdata_list mapdatum map_rowcol map_rowcol_list
%type <itemdata> material_process material_process_list material_processes
%type <itemdata> material_status material_status_list material_status_set
%type <itemdata> member_attr_list mid_list mids modify_record_info
%type <itemdata> modify_record_list modify_records
%type <itemdata> objattrid_list objattrid_decl objerror_decl objid_list
%type <itemdata> objid_list objids objsvc objsvc_list objsvcs
%type <itemdata> objtype_list objtypes
%type <itemdata> parameter parameter_data parameter_list parameters
%type <itemdata> paramval_list paramval_pair paramvals pp_verification
%type <itemdata> pp_verification_list pp_verifications pparm_list
%type <itemdata> pparameters ppid_list ppids pracka_list prjob prjob_list
%type <itemdata> prjobid_list prjobids prjobs prjobstate prjobstate_list
%type <itemdata> prjobstates proc_cmd proc_cmd_list proc_commands
%type <itemdata> proc_recipe properties property property_list
%type <itemdata> process_prog_list process_prog process_programs ptn_list
%type <itemdata> ptnerror ptnerror_list ptnerrors ptns
%type <itemdata> rcpattr_decl rcpattr_list rcpattr_s rcpdesc rcpdesc_list
%type <itemdata> rcpdesc_s rcpid_list rcpid_s rcpparm rcpparm_list rcpparm_s
%type <itemdata> rcp_parmdata_list rcp_parmdata_s rcp_parmval
%type <itemdata> recipe_descript_list rcp_parmval_list rcp_parmval_s
%type <itemdata> recipe_section recipe_descript_s recipe_info
%type <itemdata> recipe_section_list recipe_section_s refp_list refpoints
%type <itemdata> report report_list reports result result_list results
%type <itemdata> rmack_list rmsegspec_list rmsegspec_s rowcol rpt_error
%type <itemdata> rpt_error_list rpt_error_s rcp_parmdata rptid_list rptids
%type <itemdata> senddata senddata_list senddatum slotid_list slotids
%type <itemdata> sp_list spid_list spids sparm spname_list spnames state_name
%type <itemdata> state_name_list state_names stemp_list stemps status_list
%type <itemdata> stream stream_ack
%type <itemdata> stream_ack_list stream_ack_set stream_list sv_list svcname_list
%type <itemdata> svcnames svcparm svcparm_list svcparms svid_list svids svs
%type <itemdata> table_elements table_element_list tblelt_list tblelt_s
%type <itemdata> tblack_list text_list texts tsip_list tsip_list_decl
%type <itemdata> tsips tsop_list trid_list trid_s trace_decl trace_error
%type <itemdata> trace_error_list trace_error_s tsop_list_decl tsops
%type <itemdata> trjob_decl trjob_list tr_result tratomicid_list tratomicids
%type <itemdata> var_limit var_limit_list var_limits val_list value_set
%type <itemdata> vid_list vids
%type <itemdata> xypos_data xypos_data_list xypos_datum
%type <secs2msg> secs2_format_decl
%type <secs2msg> sxxfxx_decl s1f0_decl s1f1_decl s1f2_decl s1f3_decl s1f4_decl
%type <secs2msg> s1f5_decl s1f6_decl s1f7_decl s1f8_decl s1f9_decl s1f10_decl
%type <secs2msg> s1f11_decl s1f12_decl s1f13_decl s1f14_decl s1f15_decl
%type <secs2msg> s1f16_decl s1f17_decl s1f18_decl s1f19_decl s1f20_decl
%type <secs2msg> s2f0_decl s2f1_decl s2f2_decl s2f3_decl s2f4_decl s2f5_decl
%type <secs2msg> s2f6_decl s2f7_decl s2f8_decl s2f9_decl s2f10_decl s2f11_decl
%type <secs2msg> s2f12_decl s2f13_decl s2f14_decl s2f15_decl s2f16_decl
%type <secs2msg> s2f17_decl s2f18_decl s2f19_decl s2f20_decl s2f21_decl
%type <secs2msg> s2f22_decl s2f23_decl s2f24_decl s2f25_decl s2f26_decl
%type <secs2msg> s2f27_decl s2f28_decl s2f29_decl s2f30_decl s2f31_decl
%type <secs2msg> s2f32_decl s2f33_decl s2f34_decl s2f35_decl s2f36_decl
%type <secs2msg> s2f37_decl s2f38_decl s2f39_decl s2f40_decl s2f41_decl
%type <secs2msg> s2f42_decl s2f43_decl s2f44_decl s2f45_decl s2f46_decl
%type <secs2msg> s2f47_decl s2f48_decl s2f49_decl s2f50_decl
%type <secs2msg> s3f0_decl s3f1_decl s3f2_decl s3f3_decl s3f4_decl s3f5_decl
%type <secs2msg> s3f6_decl s3f7_decl s3f8_decl s3f9_decl s3f10_decl s3f11_decl
%type <secs2msg> s3f12_decl s3f13_decl s3f14_decl s3f15_decl s3f16_decl
%type <secs2msg> s3f17_decl s3f18_decl s3f19_decl s3f20_decl s3f21_decl
%type <secs2msg> s3f22_decl s3f23_decl s3f24_decl s3f25_decl s3f26_decl
%type <secs2msg> s3f27_decl s3f28_decl s3f29_decl s3f30_decl s3f31_decl
%type <secs2msg> s3f32_decl
%type <secs2msg> s4f0_decl s4f1_decl s4f2_decl s4f3_decl s4f5_decl s4f7_decl
%type <secs2msg> s4f9_decl s4f11_decl s4f13_decl s4f15_decl s4f17_decl
%type <secs2msg> s4f18_decl s4f19_decl s4f20_decl s4f21_decl s4f22_decl
%type <secs2msg> s4f23_decl s4f24_decl s4f25_decl s4f26_decl s4f27_decl
%type <secs2msg> s4f29_decl s4f31_decl s4f33_decl s4f35_decl s4f37_decl
%type <secs2msg> s4f39_decl s4f41_decl
%type <secs2msg> s5f0_decl s5f1_decl s5f2_decl s5f3_decl s5f4_decl s5f5_decl
%type <secs2msg> s5f6_decl s5f7_decl s5f8_decl s5f9_decl s5f10_decl
%type <secs2msg> s5f11_decl s5f12_decl s5f13_decl s5f14_decl s5f15_decl
%type <secs2msg> s5f16_decl s5f17_decl s5f18_decl
%type <secs2msg> s6f0_decl s6f1_decl s6f2_decl s6f3_decl s6f4_decl s6f5_decl
%type <secs2msg> s6f6_decl s6f7_decl s6f8_decl s6f9_decl s6f10_decl s6f11_decl
%type <secs2msg> s6f12_decl s6f13_decl s6f14_decl s6f15_decl s6f16_decl
%type <secs2msg> s6f17_decl s6f18_decl s6f19_decl s6f20_decl s6f21_decl
%type <secs2msg> s6f22_decl s6f23_decl s6f24_decl s6f25_decl s6f26_decl
%type <secs2msg> s6f27_decl s6f28_decl s6f29_decl s6f30_decl
%type <secs2msg> s7f0_decl s7f1_decl s7f2_decl s7f3_decl s7f4_decl s7f5_decl
%type <secs2msg> s7f6_decl s7f7_decl s7f8_decl s7f9_decl s7f10_decl s7f11_decl
%type <secs2msg> s7f12_decl s7f13_decl s7f14_decl s7f15_decl s7f16_decl
%type <secs2msg> s7f17_decl s7f18_decl s7f19_decl s7f20_decl s7f21_decl
%type <secs2msg> s7f22_decl s7f23_decl s7f24_decl s7f25_decl s7f26_decl
%type <secs2msg> s7f27_decl s7f28_decl s7f29_decl s7f30_decl s7f31_decl
%type <secs2msg> s7f32_decl s7f33_decl s7f34_decl s7f35_decl s7f36_decl
%type <secs2msg> s8f0_decl s8f1_decl s8f2_decl s8f3_decl s8f4_decl
%type <secs2msg> s9f0_decl s9f1_decl s9f3_decl s9f5_decl s9f7_decl s9f9_decl
%type <secs2msg> s9f11_decl s9f13_decl
%type <secs2msg> s10f0_decl s10f1_decl s10f2_decl s10f3_decl s10f4_decl
%type <secs2msg> s10f5_decl s10f6_decl s10f7_decl s10f9_decl s10f10_decl
%type <secs2msg> s11f0_decl
%type <secs2msg> s12f0_decl s12f1_decl s12f2_decl s12f3_decl s12f4_decl
%type <secs2msg> s12f5_decl s12f6_decl s12f7_decl s12f8_decl s12f9_decl
%type <secs2msg> s12f10_decl s12f11_decl s12f12_decl s12f13_decl s12f14_decl
%type <secs2msg> s12f15_decl s12f16_decl s12f17_decl s12f18_decl s12f19_decl
%type <secs2msg> s13f0_decl s13f1_decl s13f2_decl s13f3_decl s13f4_decl
%type <secs2msg> s13f5_decl s13f6_decl s13f7_decl s13f8_decl s13f9_decl
%type <secs2msg> s13f10_decl s13f11_decl s13f12_decl s13f13_decl s13f14_decl
%type <secs2msg> s13f15_decl s13f16_decl
%type <secs2msg> s14f0_decl s14f1_decl s14f2_decl s14f3_decl s14f4_decl
%type <secs2msg> s14f5_decl s14f6_decl s14f7_decl s14f8_decl
%type <secs2msg> s14f9_decl s14f10_decl s14f11_decl s14f12_decl s14f13_decl
%type <secs2msg> s14f14_decl s14f15_decl s14f16_decl s14f17_decl s14f18_decl
%type <secs2msg> s14f19_decl s14f20_decl s14f21_decl s14f22_decl s14f23_decl
%type <secs2msg> s14f24_decl s14f25_decl s14f26_decl s14f27_decl s14f28_decl
%type <secs2msg> s15f0_decl s15f1_decl s15f2_decl s15f3_decl s15f4_decl
%type <secs2msg> s15f5_decl s15f6_decl s15f7_decl s15f8_decl s15f9_decl
%type <secs2msg> s15f10_decl s15f11_decl s15f12_decl s15f13_decl s15f14_decl
%type <secs2msg> s15f15_decl s15f16_decl s15f17_decl s15f18_decl s15f19_decl
%type <secs2msg> s15f20_decl s15f21_decl s15f22_decl s15f23_decl s15f24_decl
%type <secs2msg> s15f25_decl s15f26_decl s15f27_decl s15f28_decl s15f29_decl
%type <secs2msg> s15f30_decl s15f31_decl s15f32_decl s15f33_decl s15f34_decl
%type <secs2msg> s15f35_decl s15f36_decl s15f37_decl s15f38_decl s15f39_decl
%type <secs2msg> s15f40_decl s15f41_decl s15f42_decl s15f43_decl s15f44_decl
%type <secs2msg> s15f45_decl s15f46_decl s15f47_decl s15f48_decl
%type <secs2msg> s16f0_decl s16f1_decl s16f2_decl s16f3_decl s16f4_decl
%type <secs2msg> s16f5_decl s16f6_decl s16f7_decl s16f8_decl s16f9_decl
%type <secs2msg> s16f10_decl s16f11_decl s16f12_decl s16f13_decl s16f14_decl
%type <secs2msg> s16f15_decl s16f16_decl s16f17_decl s16f18_decl s16f19_decl
%type <secs2msg> s16f20_decl s16f21_decl s16f22_decl s16f23_decl s16f24_decl
%type <secs2msg> s16f25_decl s16f26_decl s16f27_decl s16f28_decl s16f29_decl
%type <secs2msg> s16f30_decl
%type <secs2msg> s17f0_decl s17f1_decl s17f2_decl s17f3_decl s17f4_decl
%type <secs2msg> s17f5_decl s17f6_decl s17f7_decl s17f8_decl s17f9_decl
%type <secs2msg> s17f10_decl s17f11_decl s17f12_decl s17f13_decl s17f14_decl
%type <secs2msg> s18f0_decl s18f1_decl s18f2_decl s18f3_decl s18f4_decl
%type <secs2msg> s18f5_decl s18f6_decl s18f7_decl s18f8_decl s18f9_decl
%type <secs2msg> s18f10_decl s18f11_decl s18f12_decl s18f13_decl s18f14_decl
%type <secs2item> abs accessmode acds acka ackc3 ackc5 ackc6 ackc7 ackc7a ackc10
%type <secs2item> ackc13 agent alcd aled alid altx attrdata attrid attrreln
%type <secs2item> bcds bcequ binlt blkdef bpd bytmax caack carrieraction
%type <secs2item> carrierid carrierspec cattrdata cattrid ccode ceed ceid
%type <secs2item> cepack cepval ckpnt cmda cmdmax cname colct colhdr commack
%type <secs2item> cpack cpname cpval csaack ctljobcmd ctljobid
%type <secs2item> data dataack dataid datalength dataseg datasrc datlc
%type <secs2item> drack dsid dsname dsper dutms dvname dvval
%type <secs2item> eac ecdef ecid ecmax ecmin ecname ecv edid emid epd eqname
%type <secs2item> erack errcode errtext errw7 evntsrc exid exmessage exrecvra
%type <secs2item> extype
%type <secs2item> fcnid ffrot fildat fnloc frmlen grant grant6 grnt1
%type <secs2item> handle hcack hoack hocancelack hocmdname hohaltack iacds
%type <secs2item> ibcds idtyp
%type <secs2item> length limitack limitid limitmax limitmin linkid llim loc
%type <secs2item> locid lowerdb lrack lvack
%type <secs2item> maper mapft mcindex mdack mdln mexp mf mhead mid midac midra
%type <secs2item> mlcl mmode
%type <secs2item> nacds nbcds nulbc
%type <secs2item> objack objcmd objid objspec objtoken objtype oflack onlack
%type <secs2item> opid orloc
%type <secs2item> paramname paramval pdflt pfcd pgrpaction pmax pname
%type <secs2item> portaction portgrpname pparm ppbody ppgnt ppid praxi
%type <secs2item> prcmdname prdct preventid prjobid prjobmilestone
%type <secs2item> prjobspace prmtrlorder prpauseevent prprocessstart
%type <secs2item> prrecipemethod prstate ptn qua
%type <secs2item> rac rcmd rcpattrdata rcpattrid rcpbody rcpclass rcpcmd
%type <secs2item> rcpdel rcpdesclth rcpdescnm rcpdesctime rcpid rcpname
%type <secs2item> rcpnewid rcpowcode rcpparnm rcpparrule rcpparval rcprename
%type <secs2item> rcpseccode rcpsecnm rcpspec rcpstat rcpupdt rcpvers readln
%type <secs2item> reclen refp_xy repgsz resc respec resv ric rmack rmchgstat
%type <secs2item> rmchgtype rmdatasize rmgrnt rmnewns rmnscmd rmnsspec
%type <secs2item> rmrecspec rmrequestor rmsegspec rmspace rowct rpsel rptid
%type <secs2item> rptoc rqcmd rqpar rrack rsack rsda rsdc rsinf rsinf_xyd
%type <secs2item> rspack rtype
%type <secs2item> sdack sdbin seqnum sfcd shead slotid smpln softrev spaack
%type <secs2item> spd spid spname spr spval ssack sscmd status statuslist
%type <secs2item> stemp stime strack strid sv svcack svcname svid svname
%type <secs2item> strp_xy
%type <secs2item> targetid targetspec tblack tblcmd tblelt tblid tbltyp text
%type <secs2item> tiaack tiack tid time timeformat timestamp totsmp track
%type <secs2item> tratomicid trautod trautostart trcmdname trdir trid trjobid
%type <secs2item> trjobms trjobname trlink trlocation trobjname trobjtype
%type <secs2item> trport trptnr trptport trrcp trrole trsper trtype tsip
%type <secs2item> tsop ttc
%type <secs2item> ulim unflen units upperdb
%type <secs2item> val vid vlaack xdies xypos ydies
%type <atomdata> ack_decl attr attr_list attr_s 
%type <atomdata> bin bin_decl bins binary binary_ex bool_decl
%type <atomdata> int_array_decl int_array int_decl intx_ex_decl
%type <atomdata> int_ex_decl int1_decl int1_ex_decl int2_decl int2_ex_decl
%type <atomdata> int8_decl uint_array_decl  uint_array uint_decl uint_ex_decl
%type <atomdata> uint1_decl uint1_ex_decl uint2_decl uint2_ex_decl
%type <atomdata> uint8_decl float_decl real_decl str_decl str_ex_decl
%type <atomdata> jstr_decl value values value_list intx_decl uintx_decl
%type <atomdata> uintx_ex_decl realx_decl

%left AND
%left OR
%left NOT
%left '+' '-'
%left '*' '/'

%start secs2_message

%{

%}

/*---------------------------------------------------------------------------*/
/* BEGIN                                                                     */
/*---------------------------------------------------------------------------*/
%%

secs2_message
    : MESSAGE transaction secs2_format_decl SEMICOLON
        { make_secs2_buffer($2, $3); }
    | MESSAGE secs2_format_decl SEMICOLON
        { make_secs2_buffer(NULL, $2); }
    | error ';'                         { yyclearin; }
    ;

transaction
    : LBRACE UINTEGER WAIT RBRACE       { $$ = make_header($2, 1); }
    | LBRACE UINTEGER NOWAIT RBRACE     { $$ = make_header($2, 0); }
    | LBRACE HEX      WAIT RBRACE       { $$ = make_header($2, 1); }
    | LBRACE HEX      NOWAIT RBRACE     { $$ = make_header($2, 0); }
    | LBRACE UINTEGER RBRACE            { $$ = make_header($2, 0); }
    | LBRACE HEX     RBRACE             { $$ = make_header($2, 0); }
    | LBRACE WAIT    RBRACE             { $$ = make_header(0, 1); }
    | LBRACE NOWAIT  RBRACE             { $$ = make_header(0, 0); }
    | LBRACE RBRACE                     { $$ = make_header(0, 0); }
    ;


secs2_format_decl
    : S1F0   s1f0_decl                  { $$ = $2; }
    | S1F1   s1f1_decl                  { $$ = $2; }
    | S1F2   s1f2_decl                  { $$ = $2; }
    | S1F3   s1f3_decl                  { $$ = $2; }
    | S1F4   s1f4_decl                  { $$ = $2; }
    | S1F5   s1f5_decl                  { $$ = $2; }
    | S1F6   s1f6_decl                  { $$ = $2; }
    | S1F7   s1f7_decl                  { $$ = $2; }
    | S1F8   s1f8_decl                  { $$ = $2; }
    | S1F9   s1f9_decl                  { $$ = $2; }
    | S1F10  s1f10_decl                 { $$ = $2; }
    | S1F11  s1f11_decl                 { $$ = $2; }
    | S1F12  s1f12_decl                 { $$ = $2; }
    | S1F13  s1f13_decl                 { $$ = $2; }
    | S1F14  s1f14_decl                 { $$ = $2; }
    | S1F15  s1f15_decl                 { $$ = $2; }
    | S1F16  s1f16_decl                 { $$ = $2; }
    | S1F17  s1f17_decl                 { $$ = $2; }
    | S1F18  s1f18_decl                 { $$ = $2; }
    | S1F19  s1f19_decl                 { $$ = $2; }
    | S1F20  s1f20_decl                 { $$ = $2; }
    | S2F0   s2f0_decl                  { $$ = $2; }
    | S2F1   s2f1_decl                  { $$ = $2; }
    | S2F2   s2f2_decl                  { $$ = $2; }
    | S2F3   s2f3_decl                  { $$ = $2; }
    | S2F4   s2f4_decl                  { $$ = $2; }
    | S2F5   s2f5_decl                  { $$ = $2; }
    | S2F6   s2f6_decl                  { $$ = $2; }
    | S2F7   s2f7_decl                  { $$ = $2; }
    | S2F8   s2f8_decl                  { $$ = $2; }
    | S2F9   s2f9_decl                  { $$ = $2; }
    | S2F10  s2f10_decl                 { $$ = $2; }
    | S2F11  s2f11_decl                 { $$ = $2; }
    | S2F12  s2f12_decl                 { $$ = $2; }
    | S2F13  s2f13_decl                 { $$ = $2; }
    | S2F14  s2f14_decl                 { $$ = $2; }
    | S2F15  s2f15_decl                 { $$ = $2; }
    | S2F16  s2f16_decl                 { $$ = $2; }
    | S2F17  s2f17_decl                 { $$ = $2; }
    | S2F18  s2f18_decl                 { $$ = $2; }
    | S2F19  s2f19_decl                 { $$ = $2; }
    | S2F20  s2f20_decl                 { $$ = $2; }
    | S2F21  s2f21_decl                 { $$ = $2; }
    | S2F22  s2f22_decl                 { $$ = $2; }
    | S2F23  s2f23_decl                 { $$ = $2; }
    | S2F24  s2f24_decl                 { $$ = $2; }
    | S2F25  s2f25_decl                 { $$ = $2; }
    | S2F26  s2f26_decl                 { $$ = $2; }
    | S2F27  s2f27_decl                 { $$ = $2; }
    | S2F28  s2f28_decl                 { $$ = $2; }
    | S2F29  s2f29_decl                 { $$ = $2; }
    | S2F30  s2f30_decl                 { $$ = $2; }
    | S2F31  s2f31_decl                 { $$ = $2; }
    | S2F32  s2f32_decl                 { $$ = $2; }
    | S2F33  s2f33_decl                 { $$ = $2; }
    | S2F34  s2f34_decl                 { $$ = $2; }
    | S2F35  s2f35_decl                 { $$ = $2; }
    | S2F36  s2f36_decl                 { $$ = $2; }
    | S2F37  s2f37_decl                 { $$ = $2; }
    | S2F38  s2f38_decl                 { $$ = $2; }
    | S2F39  s2f39_decl                 { $$ = $2; }
    | S2F40  s2f40_decl                 { $$ = $2; }
    | S2F41  s2f41_decl                 { $$ = $2; }
    | S2F42  s2f42_decl                 { $$ = $2; }
    | S2F43  s2f43_decl                 { $$ = $2; }
    | S2F44  s2f44_decl                 { $$ = $2; }
    | S2F45  s2f45_decl                 { $$ = $2; }
    | S2F46  s2f46_decl                 { $$ = $2; }
    | S2F47  s2f47_decl                 { $$ = $2; }
    | S2F48  s2f48_decl                 { $$ = $2; }
    | S2F49  s2f49_decl                 { $$ = $2; }
    | S2F50  s2f50_decl                 { $$ = $2; }
    | S3F0   s3f0_decl                  { $$ = $2; }
    | S3F1   s3f1_decl                  { $$ = $2; }
    | S3F2   s3f2_decl                  { $$ = $2; }
    | S3F3   s3f3_decl                  { $$ = $2; }
    | S3F4   s3f4_decl                  { $$ = $2; }
    | S3F5   s3f5_decl                  { $$ = $2; }
    | S3F6   s3f6_decl                  { $$ = $2; }
    | S3F7   s3f7_decl                  { $$ = $2; }
    | S3F8   s3f8_decl                  { $$ = $2; }
    | S3F9   s3f9_decl                  { $$ = $2; }
    | S3F10  s3f10_decl                 { $$ = $2; }
    | S3F11  s3f11_decl                 { $$ = $2; }
    | S3F12  s3f12_decl                 { $$ = $2; }
    | S3F13  s3f13_decl                 { $$ = $2; }
    | S3F14  s3f14_decl                 { $$ = $2; }
    | S3F15  s3f15_decl                 { $$ = $2; }
    | S3F16  s3f16_decl                 { $$ = $2; }
    | S3F17  s3f17_decl                 { $$ = $2; }
    | S3F18  s3f18_decl                 { $$ = $2; }
    | S3F19  s3f19_decl                 { $$ = $2; }
    | S3F20  s3f20_decl                 { $$ = $2; }
    | S3F21  s3f21_decl                 { $$ = $2; }
    | S3F22  s3f22_decl                 { $$ = $2; }
    | S3F23  s3f23_decl                 { $$ = $2; }
    | S3F24  s3f24_decl                 { $$ = $2; }
    | S3F25  s3f25_decl                 { $$ = $2; }
    | S3F26  s3f26_decl                 { $$ = $2; }
    | S3F27  s3f27_decl                 { $$ = $2; }
    | S3F28  s3f28_decl                 { $$ = $2; }
    | S3F29  s3f29_decl                 { $$ = $2; }
    | S3F30  s3f30_decl                 { $$ = $2; }
    | S3F31  s3f31_decl                 { $$ = $2; }
    | S3F32  s3f32_decl                 { $$ = $2; }
    | S4F0   s4f0_decl                  { $$ = $2; }
    | S4F1   s4f1_decl                  { $$ = $2; }
    | S4F2   s4f2_decl                  { $$ = $2; }
    | S4F3   s4f3_decl                  { $$ = $2; }
    | S4F5   s4f5_decl                  { $$ = $2; }
    | S4F7   s4f7_decl                  { $$ = $2; }
    | S4F9   s4f9_decl                  { $$ = $2; }
    | S4F11  s4f11_decl                 { $$ = $2; }
    | S4F13  s4f13_decl                 { $$ = $2; }
    | S4F15  s4f15_decl                 { $$ = $2; }
    | S4F17  s4f17_decl                 { $$ = $2; }
    | S4F18  s4f18_decl                 { $$ = $2; }
    | S4F19  s4f19_decl                 { $$ = $2; }
    | S4F20  s4f20_decl                 { $$ = $2; }
    | S4F21  s4f21_decl                 { $$ = $2; }
    | S4F22  s4f22_decl                 { $$ = $2; }
    | S4F23  s4f23_decl                 { $$ = $2; }
    | S4F24  s4f24_decl                 { $$ = $2; }
    | S4F25  s4f25_decl                 { $$ = $2; }
    | S4F26  s4f26_decl                 { $$ = $2; }
    | S4F27  s4f27_decl                 { $$ = $2; }
    | S4F29  s4f29_decl                 { $$ = $2; }
    | S4F31  s4f31_decl                 { $$ = $2; }
    | S4F33  s4f33_decl                 { $$ = $2; }
    | S4F35  s4f35_decl                 { $$ = $2; }
    | S4F37  s4f37_decl                 { $$ = $2; }
    | S4F39  s4f39_decl                 { $$ = $2; }
    | S4F41  s4f41_decl                 { $$ = $2; }
    | S5F0   s5f0_decl                  { $$ = $2; }
    | S5F1   s5f1_decl                  { $$ = $2; }
    | S5F2   s5f2_decl                  { $$ = $2; }
    | S5F3   s5f3_decl                  { $$ = $2; }
    | S5F4   s5f4_decl                  { $$ = $2; }
    | S5F5   s5f5_decl                  { $$ = $2; }
    | S5F6   s5f6_decl                  { $$ = $2; }
    | S5F7   s5f7_decl                  { $$ = $2; }
    | S5F8   s5f8_decl                  { $$ = $2; }
    | S5F9   s5f9_decl                  { $$ = $2; }
    | S5F10  s5f10_decl                 { $$ = $2; }
    | S5F11  s5f11_decl                 { $$ = $2; }
    | S5F12  s5f12_decl                 { $$ = $2; }
    | S5F13  s5f13_decl                 { $$ = $2; }
    | S5F14  s5f14_decl                 { $$ = $2; }
    | S5F15  s5f15_decl                 { $$ = $2; }
    | S5F16  s5f16_decl                 { $$ = $2; }
    | S5F17  s5f17_decl                 { $$ = $2; }
    | S5F18  s5f18_decl                 { $$ = $2; }
    | S6F0   s6f0_decl                  { $$ = $2; }
    | S6F1   s6f1_decl                  { $$ = $2; }
    | S6F2   s6f2_decl                  { $$ = $2; }
    | S6F3   s6f3_decl                  { $$ = $2; }
    | S6F4   s6f4_decl                  { $$ = $2; }
    | S6F5   s6f5_decl                  { $$ = $2; }
    | S6F6   s6f6_decl                  { $$ = $2; }
    | S6F7   s6f7_decl                  { $$ = $2; }
    | S6F8   s6f8_decl                  { $$ = $2; }
    | S6F9   s6f9_decl                  { $$ = $2; }
    | S6F10  s6f10_decl                 { $$ = $2; }
    | S6F11  s6f11_decl                 { $$ = $2; }
    | S6F12  s6f12_decl                 { $$ = $2; }
    | S6F13  s6f13_decl                 { $$ = $2; }
    | S6F14  s6f14_decl                 { $$ = $2; }
    | S6F15  s6f15_decl                 { $$ = $2; }
    | S6F16  s6f16_decl                 { $$ = $2; }
    | S6F17  s6f17_decl                 { $$ = $2; }
    | S6F18  s6f18_decl                 { $$ = $2; }
    | S6F19  s6f19_decl                 { $$ = $2; }
    | S6F20  s6f20_decl                 { $$ = $2; }
    | S6F21  s6f21_decl                 { $$ = $2; }
    | S6F22  s6f22_decl                 { $$ = $2; }
    | S6F23  s6f23_decl                 { $$ = $2; }
    | S6F24  s6f24_decl                 { $$ = $2; }
    | S6F25  s6f25_decl                 { $$ = $2; }
    | S6F26  s6f26_decl                 { $$ = $2; }
    | S6F27  s6f27_decl                 { $$ = $2; }
    | S6F28  s6f28_decl                 { $$ = $2; }
    | S6F29  s6f29_decl                 { $$ = $2; }
    | S6F30  s6f30_decl                 { $$ = $2; }
    | S7F0   s7f0_decl                  { $$ = $2; }
    | S7F1   s7f1_decl                  { $$ = $2; }
    | S7F2   s7f2_decl                  { $$ = $2; }
    | S7F3   s7f3_decl                  { $$ = $2; }
    | S7F4   s7f4_decl                  { $$ = $2; }
    | S7F5   s7f5_decl                  { $$ = $2; }
    | S7F6   s7f6_decl                  { $$ = $2; }
    | S7F7   s7f7_decl                  { $$ = $2; }
    | S7F8   s7f8_decl                  { $$ = $2; }
    | S7F9   s7f9_decl                  { $$ = $2; }
    | S7F10  s7f10_decl                 { $$ = $2; }
    | S7F11  s7f11_decl                 { $$ = $2; }
    | S7F12  s7f12_decl                 { $$ = $2; }
    | S7F13  s7f13_decl                 { $$ = $2; }
    | S7F14  s7f14_decl                 { $$ = $2; }
    | S7F15  s7f15_decl                 { $$ = $2; }
    | S7F16  s7f16_decl                 { $$ = $2; }
    | S7F17  s7f17_decl                 { $$ = $2; }
    | S7F18  s7f18_decl                 { $$ = $2; }
    | S7F19  s7f19_decl                 { $$ = $2; }
    | S7F20  s7f20_decl                 { $$ = $2; }
    | S7F21  s7f21_decl                 { $$ = $2; }
    | S7F22  s7f22_decl                 { $$ = $2; }
    | S7F23  s7f23_decl                 { $$ = $2; }
    | S7F24  s7f24_decl                 { $$ = $2; }
    | S7F25  s7f25_decl                 { $$ = $2; }
    | S7F26  s7f26_decl                 { $$ = $2; }
    | S7F27  s7f27_decl                 { $$ = $2; }
    | S7F28  s7f28_decl                 { $$ = $2; }
    | S7F29  s7f29_decl                 { $$ = $2; }
    | S7F30  s7f30_decl                 { $$ = $2; }
    | S7F31  s7f31_decl                 { $$ = $2; }
    | S7F32  s7f32_decl                 { $$ = $2; }
    | S7F33  s7f33_decl                 { $$ = $2; }
    | S7F34  s7f34_decl                 { $$ = $2; }
    | S7F35  s7f35_decl                 { $$ = $2; }
    | S7F36  s7f36_decl                 { $$ = $2; }
    | S8F0   s8f0_decl                  { $$ = $2; }
    | S8F1   s8f1_decl                  { $$ = $2; }
    | S8F2   s8f2_decl                  { $$ = $2; }
    | S8F3   s8f3_decl                  { $$ = $2; }
    | S8F4   s8f4_decl                  { $$ = $2; }
    | S9F0   s9f0_decl                  { $$ = $2; }
    | S9F1   s9f1_decl                  { $$ = $2; }
    | S9F3   s9f3_decl                  { $$ = $2; }
    | S9F5   s9f5_decl                  { $$ = $2; }
    | S9F7   s9f7_decl                  { $$ = $2; }
    | S9F9   s9f9_decl                  { $$ = $2; }
    | S9F11  s9f11_decl                 { $$ = $2; }
    | S9F13  s9f13_decl                 { $$ = $2; }
    | S10F0  s10f0_decl                 { $$ = $2; }
    | S10F1  s10f1_decl                 { $$ = $2; }
    | S10F2  s10f2_decl                 { $$ = $2; }
    | S10F3  s10f3_decl                 { $$ = $2; }
    | S10F4  s10f4_decl                 { $$ = $2; }
    | S10F5  s10f5_decl                 { $$ = $2; }
    | S10F6  s10f6_decl                 { $$ = $2; }
    | S10F7  s10f7_decl                 { $$ = $2; }
    | S10F9  s10f9_decl                 { $$ = $2; }
    | S10F10 s10f10_decl                { $$ = $2; }
    | S11F0  s11f0_decl                 { $$ = $2; }
    | S12F0  s12f0_decl                 { $$ = $2; }
    | S12F1  s12f1_decl                 { $$ = $2; }
    | S12F2  s12f2_decl                 { $$ = $2; }
    | S12F3  s12f3_decl                 { $$ = $2; }
    | S12F4  s12f4_decl                 { $$ = $2; }
    | S12F5  s12f5_decl                 { $$ = $2; }
    | S12F6  s12f6_decl                 { $$ = $2; }
    | S12F7  s12f7_decl                 { $$ = $2; }
    | S12F8  s12f8_decl                 { $$ = $2; }
    | S12F9  s12f9_decl                 { $$ = $2; }
    | S12F10 s12f10_decl                { $$ = $2; }
    | S12F11 s12f11_decl                { $$ = $2; }
    | S12F12 s12f12_decl                { $$ = $2; }
    | S12F13 s12f13_decl                { $$ = $2; }
    | S12F14 s12f14_decl                { $$ = $2; }
    | S12F15 s12f15_decl                { $$ = $2; }
    | S12F16 s12f16_decl                { $$ = $2; }
    | S12F17 s12f17_decl                { $$ = $2; }
    | S12F18 s12f18_decl                { $$ = $2; }
    | S12F19 s12f19_decl                { $$ = $2; }
    | S13F0  s13f0_decl                 { $$ = $2; }
    | S13F1  s13f1_decl                 { $$ = $2; }
    | S13F2  s13f2_decl                 { $$ = $2; }
    | S13F3  s13f3_decl                 { $$ = $2; }
    | S13F4  s13f4_decl                 { $$ = $2; }
    | S13F5  s13f5_decl                 { $$ = $2; }
    | S13F6  s13f6_decl                 { $$ = $2; }
    | S13F7  s13f7_decl                 { $$ = $2; }
    | S13F8  s13f8_decl                 { $$ = $2; }
    | S13F9  s13f9_decl                 { $$ = $2; }
    | S13F10 s13f10_decl                { $$ = $2; }
    | S13F11 s13f11_decl                { $$ = $2; }
    | S13F12 s13f12_decl                { $$ = $2; }
    | S13F13 s13f13_decl                { $$ = $2; }
    | S13F14 s13f14_decl                { $$ = $2; }
    | S13F15 s13f15_decl                { $$ = $2; }
    | S13F16 s13f16_decl                { $$ = $2; }
    | S14F0  s14f0_decl                 { $$ = $2; }
    | S14F1  s14f1_decl                 { $$ = $2; }
    | S14F2  s14f2_decl                 { $$ = $2; }
    | S14F3  s14f3_decl                 { $$ = $2; }
    | S14F4  s14f4_decl                 { $$ = $2; }
    | S14F5  s14f5_decl                 { $$ = $2; }
    | S14F6  s14f6_decl                 { $$ = $2; }
    | S14F7  s14f7_decl                 { $$ = $2; }
    | S14F8  s14f8_decl                 { $$ = $2; }
    | S14F9  s14f9_decl                 { $$ = $2; }
    | S14F10 s14f10_decl                { $$ = $2; }
    | S14F11 s14f11_decl                { $$ = $2; }
    | S14F12 s14f12_decl                { $$ = $2; }
    | S14F13 s14f13_decl                { $$ = $2; }
    | S14F14 s14f14_decl                { $$ = $2; }
    | S14F15 s14f15_decl                { $$ = $2; }
    | S14F16 s14f16_decl                { $$ = $2; }
    | S14F17 s14f17_decl                { $$ = $2; }
    | S14F18 s14f18_decl                { $$ = $2; }
    | S14F19 s14f19_decl                { $$ = $2; }
    | S14F20 s14f20_decl                { $$ = $2; }
    | S14F21 s14f21_decl                { $$ = $2; }
    | S14F22 s14f22_decl                { $$ = $2; }
    | S14F23 s14f23_decl                { $$ = $2; }
    | S14F24 s14f24_decl                { $$ = $2; }
    | S14F25 s14f25_decl                { $$ = $2; }
    | S14F26 s14f26_decl                { $$ = $2; }
    | S14F27 s14f27_decl                { $$ = $2; }
    | S14F28 s14f28_decl                { $$ = $2; }
    | S15F0  s15f0_decl                 { $$ = $2; }
    | S15F1  s15f1_decl                 { $$ = $2; }
    | S15F2  s15f2_decl                 { $$ = $2; }
    | S15F3  s15f3_decl                 { $$ = $2; }
    | S15F4  s15f4_decl                 { $$ = $2; }
    | S15F5  s15f5_decl                 { $$ = $2; }
    | S15F6  s15f6_decl                 { $$ = $2; }
    | S15F7  s15f7_decl                 { $$ = $2; }
    | S15F8  s15f8_decl                 { $$ = $2; }
    | S15F9  s15f9_decl                 { $$ = $2; }
    | S15F10 s15f10_decl                { $$ = $2; }
    | S15F11 s15f11_decl                { $$ = $2; }
    | S15F12 s15f12_decl                { $$ = $2; }
    | S15F13 s15f13_decl                { $$ = $2; }
    | S15F14 s15f14_decl                { $$ = $2; }
    | S15F15 s15f15_decl                { $$ = $2; }
    | S15F16 s15f16_decl                { $$ = $2; }
    | S15F17 s15f17_decl                { $$ = $2; }
    | S15F18 s15f18_decl                { $$ = $2; }
    | S15F19 s15f19_decl                { $$ = $2; }
    | S15F20 s15f20_decl                { $$ = $2; }
    | S15F21 s15f21_decl                { $$ = $2; }
    | S15F22 s15f22_decl                { $$ = $2; }
    | S15F23 s15f23_decl                { $$ = $2; }
    | S15F24 s15f24_decl                { $$ = $2; }
    | S15F25 s15f25_decl                { $$ = $2; }
    | S15F26 s15f26_decl                { $$ = $2; }
    | S15F27 s15f27_decl                { $$ = $2; }
    | S15F28 s15f28_decl                { $$ = $2; }
    | S15F29 s15f29_decl                { $$ = $2; }
    | S15F30 s15f30_decl                { $$ = $2; }
    | S15F31 s15f31_decl                { $$ = $2; }
    | S15F32 s15f32_decl                { $$ = $2; }
    | S15F33 s15f33_decl                { $$ = $2; }
    | S15F34 s15f34_decl                { $$ = $2; }
    | S15F35 s15f35_decl                { $$ = $2; }
    | S15F36 s15f36_decl                { $$ = $2; }
    | S15F37 s15f37_decl                { $$ = $2; }
    | S15F38 s15f38_decl                { $$ = $2; }
    | S15F39 s15f39_decl                { $$ = $2; }
    | S15F40 s15f40_decl                { $$ = $2; }
    | S15F41 s15f41_decl                { $$ = $2; }
    | S15F42 s15f42_decl                { $$ = $2; }
    | S15F43 s15f43_decl                { $$ = $2; }
    | S15F44 s15f44_decl                { $$ = $2; }
    | S15F45 s15f45_decl                { $$ = $2; }
    | S15F46 s15f46_decl                { $$ = $2; }
    | S15F47 s15f47_decl                { $$ = $2; }
    | S15F48 s15f48_decl                { $$ = $2; }
    | S16F0  s16f0_decl                 { $$ = $2; }
    | S16F1  s16f1_decl                 { $$ = $2; }
    | S16F2  s16f2_decl                 { $$ = $2; }
    | S16F3  s16f3_decl                 { $$ = $2; }
    | S16F4  s16f4_decl                 { $$ = $2; }
    | S16F5  s16f5_decl                 { $$ = $2; }
    | S16F6  s16f6_decl                 { $$ = $2; }
    | S16F7  s16f7_decl                 { $$ = $2; }
    | S16F8  s16f8_decl                 { $$ = $2; }
    | S16F9  s16f9_decl                 { $$ = $2; }
    | S16F10 s16f10_decl                { $$ = $2; }
    | S16F11 s16f11_decl                { $$ = $2; }
    | S16F12 s16f12_decl                { $$ = $2; }
    | S16F13 s16f13_decl                { $$ = $2; }
    | S16F14 s16f14_decl                { $$ = $2; }
    | S16F15 s16f15_decl                { $$ = $2; }
    | S16F16 s16f16_decl                { $$ = $2; }
    | S16F17 s16f17_decl                { $$ = $2; }
    | S16F18 s16f18_decl                { $$ = $2; }
    | S16F19 s16f19_decl                { $$ = $2; }
    | S16F20 s16f20_decl                { $$ = $2; }
    | S16F21 s16f21_decl                { $$ = $2; }
    | S16F22 s16f22_decl                { $$ = $2; }
    | S16F23 s16f23_decl                { $$ = $2; }
    | S16F24 s16f24_decl                { $$ = $2; }
    | S16F25 s16f25_decl                { $$ = $2; }
    | S16F26 s16f26_decl                { $$ = $2; }
    | S16F27 s16f27_decl                { $$ = $2; }
    | S16F28 s16f28_decl                { $$ = $2; }
    | S16F29 s16f29_decl                { $$ = $2; }
    | S16F30 s16f30_decl                { $$ = $2; }
    | S17F0  s17f0_decl                 { $$ = $2; }
    | S17F1  s17f1_decl                 { $$ = $2; }
    | S17F2  s17f2_decl                 { $$ = $2; }
    | S17F3  s17f3_decl                 { $$ = $2; }
    | S17F4  s17f4_decl                 { $$ = $2; }
    | S17F5  s17f5_decl                 { $$ = $2; }
    | S17F6  s17f6_decl                 { $$ = $2; }
    | S17F7  s17f7_decl                 { $$ = $2; }
    | S17F8  s17f8_decl                 { $$ = $2; }
    | S17F9  s17f9_decl                 { $$ = $2; }
    | S17F10 s17f10_decl                { $$ = $2; }
    | S17F11 s17f11_decl                { $$ = $2; }
    | S17F12 s17f12_decl                { $$ = $2; }
    | S17F13 s17f13_decl                { $$ = $2; }
    | S17F14 s17f14_decl                { $$ = $2; }
    | S18F0  s18f0_decl                 { $$ = $2; }
    | S18F1  s18f1_decl                 { $$ = $2; }
    | S18F2  s18f2_decl                 { $$ = $2; }
    | S18F3  s18f3_decl                 { $$ = $2; }
    | S18F4  s18f4_decl                 { $$ = $2; }
    | S18F5  s18f5_decl                 { $$ = $2; }
    | S18F6  s18f6_decl                 { $$ = $2; }
    | S18F7  s18f7_decl                 { $$ = $2; }
    | S18F8  s18f8_decl                 { $$ = $2; }
    | S18F9  s18f9_decl                 { $$ = $2; }
    | S18F10 s18f10_decl                { $$ = $2; }
    | S18F11 s18f11_decl                { $$ = $2; }
    | S18F12 s18f12_decl                { $$ = $2; }
    | S18F13 s18f13_decl                { $$ = $2; }
    | S18F14 s18f14_decl                { $$ = $2; }
    | SXXFXX { _tcscpy(_streamFunction, $1); free($1); } sxxfxx_decl  { $$ = $3; }
    | error ';'                         { yyclearin; }
    ;

/* User define */
sxxfxx_decl
    : /* empty */
        {
            if (getMessageFormat(&msginfo, _streamFunction) >= 0)
                $$ = func_sxxfxx(&msginfo);
            else
                yyclearin;
        }
    | user_top_atom
        {
            if (getMessageFormat(&msginfo, _streamFunction) >= 0)
                $$ = func_sxxfxx_top(&msginfo, $1);
            else
                yyclearin;
        }
    | atom_list
        {
            if (getMessageFormat(&msginfo, _streamFunction) >= 0)
                $$ = func_sxxfxx_toplist(&msginfo, $1);
            else
                yyclearin;
        }
    ;


atom_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE user_atoms RBRACE          { $$ = $2; }
    ;

user_atoms
    : user_atom                         { $$ = make_atom_list(NULL, $1); }
    | user_atoms user_atom              { $$ = make_atom_list($1, $2); }
    ;

user_atom
    : bin_decl                          { $$ = $1; }
    | bool_decl                         { $$ = $1; }
    | intx_decl                         { $$ = $1; }
    | uintx_decl                        { $$ = $1; }
    | realx_decl                        { $$ = $1; }
    | str_ex_decl                       { $$ = $1; }
    | atom_list                         { $$ = $1; }
    ;

user_top_atom
    : bin_decl                          { $$ = $1; }
    | bool_decl                         { $$ = $1; }
    | intx_decl                         { $$ = $1; }
    | uintx_decl                        { $$ = $1; }
    | realx_decl                        { $$ = $1; }
    | str_ex_decl                       { $$ = $1; }
    ;

/* Abort Transaction */
s1f0_decl
    : /* empty */                       { $$ = func_s1f0(); }
    ;

/* Are You There Request */
s1f1_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(1,1)); }
    ;

/* On Line Data */
s1f2_decl
    : LBRACE RBRACE                     { $$ = func_s1f2(NULL, NULL); }
    | LBRACE mdln softrev RBRACE        { $$ = func_s1f2($2, $3); }
    ;

/* Selected Equipment Status Request */
s1f3_decl
    : svid_list                         { $$ = func_item1(SFCODE(1,3), $1); }
    ;

svid_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE svids RBRACE               { $$ = $2; }
    ;

svids
    : svid                              { $$ = make_item_list(NULL, $1); }
    | svids svid                        { $$ = make_item_list($1, $2); }
    ;

/* Selected Equipment Status Data */
s1f4_decl
    : sv_list                           { $$ = func_item1(SFCODE(1,4), $1); }
    ;

sv_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE svs RBRACE                 { $$ = $2; }
    ;

svs
    : sv                                { $$ = make_item_list(NULL, $1); }
    | svs sv                            { $$ = make_item_list($1, $2); }
    ;

/* Formatted Status Request */
s1f5_decl
    : sfcd                              { $$ = func_item1(SFCODE(1,5), $1); }
    ;

/* Formatted Status Data */
s1f6_decl
    : val    /* state_variable_value: (???????) */
        { $$ = func_s1f6($1); }
    | /* empty */
        { $$ = func_s1f6(NULL); }
    ;

/* Fixed Form Request */
s1f7_decl
    : sfcd                             { $$ = func_item1(SFCODE(1,7), $1); }
    ;

/* Fixed Form Data */
s1f8_decl
    : val                     /* state_variable_value: (?????) */
        { $$ = func_s1f8($1); }
    | /* empty */
        { $$ = func_s1f8(NULL); }
    ;

/* Material Transfer Status Request */
s1f9_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(1,9)); }
    ;

/* Material Transfer Status Data */
s1f10_decl
    : LBRACE RBRACE
        { $$ = func_s1f10(NULL, NULL); }
    | LBRACE tsip_list_decl tsop_list_decl RBRACE
        { $$ = func_s1f10($2, $3); }
    ;

tsip_list_decl
    : LBRACE tsip_list RBRACE           { $$ = $2; }
    ;

tsip_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE tsips RBRACE               { $$ = $2; }
    ;

tsips
    : tsip                              { $$ = make_item_list(NULL, $1); }
    | tsips tsip                        { $$ = make_item_list($1, $2); }
    ;

tsop_list_decl
    : LBRACE tsop_list RBRACE           { $$ = $2; }
    ;

tsop_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE tsops RBRACE               { $$ = $2; }
    ;

tsops
    : tsop                              { $$ = make_item_list(NULL, $1); }
    | tsops tsop                        { $$ = make_item_list($1, $2); }
    ;

/* Status Variable Namelist Request */
s1f11_decl
    : svid_list                         { $$ = func_item1(SFCODE(1,11), $1); }
    ;

/* Status Variable Namelist Reply */
s1f12_decl
    : state_name_list                   { $$ = func_item1(SFCODE(1,12), $1); }
    ;

state_name_list
    : LBRACE state_names RBRACE         { $$ = $2; }
    ;

state_names
    : state_name                        { $$ = make_item_list(NULL, $1); }
    | state_names state_name            { $$ = make_item_list($1, $2); }
    ;

state_name
    : LBRACE svid svname units RBRACE   { $$ = mklist_3items($2, $3, $4); }
    ;

/* Establish Communications Requet */
s1f13_decl
    : LBRACE RBRACE                     { $$ = func_s1f13(NULL, NULL); }
    | LBRACE mdln softrev RBRACE        { $$ = func_s1f13($2, $3); }
    ;

/* Establish Communications Requet Acknowledge */
s1f14_decl
    : LBRACE commack LBRACE mdln softrev RBRACE RBRACE
        { $$ = func_s1f14($2, $4, $5); }
    | LBRACE commack LBRACE RBRACE RBRACE
        { $$ = func_s1f14($2, NULL, NULL); }
    ;

/* Request OFF-LINE */
s1f15_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(1,15)); }
    ;

/* OFF-LINE Acknowledge */
s1f16_decl
    : oflack                            { $$ = func_item1(SFCODE(1,16), $1); }
    ;

/* Request ON-LINE */
s1f17_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(1,17)); }
    ;

/* ON-LINE Acknowledge */
s1f18_decl
    : onlack                            { $$ = func_item1(SFCODE(1,18), $1); }
    ;

/* Get Attribute */
s1f19_decl
    : LBRACE objtype objid_list attrid_list RBRACE
        { $$ = func_s1f19($2, $3, $4); }
    | LBRACE objtype RBRACE
        { $$ = func_s1f19($2, NULL, NULL); }
    ;

objid_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE objids RBRACE              { $$ = $2; }
    ;

objids
    : objid                             { $$ = make_item_list(NULL, $1); }
    | objids objid                      { $$ = make_item_list($1, $2); }
    ;

attrid_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE attrids RBRACE             { $$ = $2; }
    ;

attrids
    : attrid                            { $$ = make_item_list(NULL, $1); }
    | attrids attrid                    { $$ = make_item_list($1, $2); }
    ;

/* Attribute Data */
s1f20_decl
    : LBRACE LBRACE attrdata_lists RBRACE error_list RBRACE
        { $$ = func_s1f20($3, $5); }
    | LBRACE LBRACE attrdata_lists RBRACE RBRACE
        { $$ = func_s1f20($3, NULL); }
    ;

attrdata_lists
    : attrdata_list                     { $$ = make_item_list(NULL, $1); }
    | attrdata_lists attrdata_list      { $$ = make_item_list($1, $2); }
    ;

attrdata_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE attr_decl RBRACE           { $$ = $2; }
    ;

attr_decl
    : attrdata                          { $$ = make_item_list(NULL, $1); }
    | attr_decl attrdata                { $$ = make_item_list($1, $2);   }
    ;

error_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE errors RBRACE              { $$ = $2;   }
    ;

errors
    : error_decl                        { $$ = make_item_list(NULL, $1); }
    | errors error_decl                 { $$ = make_item_list($1, $2);   }
    ;

error_decl
    : LBRACE errcode errtext RBRACE     { $$ = mklist_2items($2, $3); }
    ;


/* Abort Transaction */
s2f0_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(2,0)); }
    ;

/* Service Program Load Inquire */
s2f1_decl
    : LBRACE spid length RBRACE         { $$ = func_item2(SFCODE(2,1), $2, $3); }
    ;

/* Service Program Load Grant */
s2f2_decl
    : grant                             { $$ = func_item1(SFCODE(2,2), $1); }
    ;

/* Service Program Send */
s2f3_decl
    : spd                               { $$ = func_item1(SFCODE(2,3), $1); }
    ;

/* Service Program Send Acknowledge */
s2f4_decl
    : spaack                            { $$ = func_item1(SFCODE(2,4), $1); }
    ;

/* Service Program Load Request */
s2f5_decl
    : spid                              { $$ = func_item1(SFCODE(2,5), $1); }
    ;

/* Service Program Load Data */
s2f6_decl
    : spd                               { $$ = func_item1(SFCODE(2,6), $1); }
    ;

/* Service Program Run Send */
s2f7_decl
    : spid                              { $$ = func_item1(SFCODE(2,7), $1); }
    ;

/* Service Program Run Acknowledge */
s2f8_decl
    : csaack                            { $$ = func_item1(SFCODE(2,8), $1); }
    ;

/* Service Program Result Request */
s2f9_decl
    : spid                              { $$ = func_item1(SFCODE(2,9), $1); }
    ;

/* Service Program Result Data */
s2f10_decl
    : spr                               { $$ = func_item1(SFCODE(2,10), $1); }
    ;

/* Service Program Directory Request */
s2f11_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(2,11)); }
    ;

/* Service Program Directory Data */
s2f12_decl
    : spid_list                         { $$ = func_item1(SFCODE(2,12), $1); }
    ;

spid_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE spids RBRACE               { $$ = $2; }
    ;

spids
    : spid                              { $$ = make_item_list(NULL, $1); }
    | spids spid                        { $$ = make_item_list($1, $2); }
    ;

/* Equipment Constant Request */
s2f13_decl
    : ecid_list                         { $$ = func_item1(SFCODE(2,13), $1); }
    ;

ecid_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE ecids RBRACE               { $$ = $2; }
    ;

ecids
    : ecid                              { $$ = make_item_list(NULL, $1); }
    | ecids ecid                        { $$ = make_item_list($1, $2); }
    ;

/* Equipment Constant Data */
s2f14_decl
    : ecv_list                          { $$ = func_item1(SFCODE(2,14), $1); }
    ;

ecv_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE ecvs RBRACE                { $$ = $2; }
    ;

ecvs
    : ecv                               { $$ = make_item_list(NULL, $1); }
    | ecvs ecv                          { $$ = make_item_list($1, $2); }
    ;

/* New Equipment Constant Send */
s2f15_decl
    : ecv_data_list                     { $$ = func_item1(SFCODE(2,15), $1); }
    ;

ecv_data_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE ecv_data RBRACE            { $$ = $2; }
    ;

ecv_data
    : ecv_datum                         { $$ = make_item_list(NULL, $1); }
    | ecv_data ecv_datum                { $$ = make_item_list($1, $2); }
    ;

ecv_datum
    : LBRACE ecid ecv RBRACE            { $$ = mklist_2items($2, $3); }
    ;

/* New Equipment Constant Acknowledge */
s2f16_decl
    : eac                               { $$ = func_item1(SFCODE(2,16), $1); }
    ;

/* Date and Time Request */
s2f17_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(2,17)); }
    ;

/* Date and Time Data */
s2f18_decl
    : time                              { $$ = func_item1(SFCODE(2,18), $1); }
    | /* empty */                       { $$ = func_item1(SFCODE(2,18), NULL); }
    ;

/* Reset/Initialize Send */
s2f19_decl
    : ric                               { $$ = func_item1(SFCODE(2,19), $1); }
    ;

/* Reset Acknowledge */
s2f20_decl
    : rac                               { $$ = func_item1(SFCODE(2,20), $1); }
    ;

/* Remote Command Send */
s2f21_decl
    : rcmd                              { $$ = func_item1(SFCODE(2,21), $1); }
    ;

/* Remote Command Acknowledge */
s2f22_decl
    : cmda                              { $$ = func_item1(SFCODE(2,22), $1); }
    ;

/* Trace Initialize Send */
s2f23_decl
    : LBRACE trid dsper totsmp repgsz svid_list RBRACE
        { $$ = func_iiiil(SFCODE(2,23), $2, $3, $4, $5, $6); }
    ;

/* Trace Initialize Acknowledge */
s2f24_decl
    : tiaack                            { $$ = func_item1(SFCODE(2,24), $1); }
    ;

/* Loopback Diagnostic Request */
s2f25_decl
    : abs                               { $$ = func_item1(SFCODE(2,25), $1); }
    ;

/* Loopback Diagnostic Data */
s2f26_decl
    : abs                               { $$ = func_item1(SFCODE(2,26), $1); }
    ;

/* Initiate Processing Request */
s2f27_decl
    : LBRACE loc ppid mid_list RBRACE   { $$ = func_s2f27($2, $3, $4); }
    | LBRACE loc RBRACE                 { $$ = func_s2f27($2, NULL, NULL); }
    ;

mid_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE mids RBRACE                { $$ = $2; }
    ;

mids
    : mid                               { $$ = make_item_list(NULL, $1); }
    | mids mid                          { $$ = make_item_list($1, $2); }
    ;

/* Initiate Processing Acknowledge */
s2f28_decl
    : cmda                              { $$ = func_item1(SFCODE(2,28), $1); }
    ;

/* Equipment Constant Namelist Request */
s2f29_decl
    : ecid_list                         { $$ = func_item1(SFCODE(2,29), $1); }
    ;

/* Equipment Constant Namelist */
s2f30_decl
    : ecv_decl_list                     { $$ = func_item1(SFCODE(2,30), $1); }
    ;

ecv_decl_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE ecv_decl_set RBRACE        { $$ = $2; }
    ;

ecv_decl_set
    : ecv_decl                          { $$ = make_item_list(NULL, $1); }
    | ecv_decl_set ecv_decl             { $$ = make_item_list($1, $2); }
    ;

ecv_decl
    : LBRACE ecid ecname ecmin ecmax ecdef units RBRACE
        { $$ = make_equipment_info($2, $3, $4, $5, $6, $7); }
    ;

/* Date and Time Set Request */
s2f31_decl
    : time                              { $$ = func_item1(SFCODE(2,31), $1); }
    ;

/* Date and Time Set Acknowledge */
s2f32_decl
    : tiack                             { $$ = func_item1(SFCODE(2,32), $1); }
    ;

/* Define Report */
s2f33_decl
    : LBRACE dataid report_list RBRACE
        { $$ = func_il(SFCODE(2,33), $2, $3); }
    ;

report_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE reports RBRACE             { $$ = $2; }
    ;

reports
    : report                            { $$ = make_item_list(NULL, $1); }
    | reports report                    { $$ = make_item_list($1, $2); }
    ;

report
    : LBRACE rptid vid_list RBRACE      { $$ = mklist_item_itemlist($2, $3); }
    ;

vid_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE vids RBRACE                { $$ = $2; }
    ;

vids
    : vid                               { $$ = make_item_list(NULL, $1); }
    | vids vid                          { $$ = make_item_list($1, $2); }
    ;

/* Define Report Acknowledge */
s2f34_decl
    : drack                             { $$ = func_item1(SFCODE(2,34), $1); }
    ;

/* Link Event Report */
s2f35_decl
    : LBRACE dataid event_report_list RBRACE
        { $$ = func_il(SFCODE(2,35), $2, $3); }
    ;

event_report_list
    : LBRACE event_reports RBRACE       { $$ = $2; }
    ;

event_reports
    : event_report                      { $$ = make_item_list(NULL, $1); }
    | event_reports event_report        { $$ = make_item_list($1, $2); }
    ;

event_report
    : LBRACE ceid rptid_list RBRACE     { $$ = mklist_item_itemlist($2, $3); }
    ;

rptid_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE rptids RBRACE              { $$ = $2; }
    ;

rptids
    : rptid                             { $$ = make_item_list(NULL, $1); }
    | rptids rptid                      { $$ = make_item_list($1, $2); }
    ;

/* Link Report Acknowledge */
s2f36_decl
    : lrack                             { $$ = func_item1(SFCODE(2,36), $1); }
    ;

/* Enable/Disable Event Report */
s2f37_decl
    : LBRACE ceed ceid_list RBRACE      { $$ = func_il(SFCODE(2,37), $2, $3); }
    ;

ceid_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE ceids RBRACE               { $$ = $2; }
    ;

ceids
    : ceid                              { $$ = make_item_list(NULL, $1); }
    | ceids ceid                        { $$ = make_item_list($1, $2); }
    ;

/* Enable/Disable Event Report Acknowledge */
s2f38_decl
    : erack                             { $$ = func_item1(SFCODE(2,38), $1); }
    ;

/* Multi-block Inquire */
s2f39_decl
    : LBRACE dataid datalength RBRACE
        { $$ = func_item2(SFCODE(2,39), $2, $3); }
    ;

/* Multi-block Grant */
s2f40_decl
    : grant                             { $$ = func_item1(SFCODE(2,40), $1); }
    ;

/* Host Command Send */
s2f41_decl
    : LBRACE rcmd parameter_list RBRACE
        { $$ = func_il(SFCODE(2,41), $2, $3); }
    ;

parameter_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE parameters RBRACE          { $$ = $2; }
    ;

parameters
    : parameter                         { $$ = make_item_list(NULL, $1); }
    | parameters parameter              { $$ = make_item_list($1, $2); }
    ;

parameter
    : LBRACE cpname cpval RBRACE        { $$ = mklist_2items($2, $3); }
    ;

/* Host Command Acknowledge */
s2f42_decl
    : LBRACE hcack result_list RBRACE   { $$ = func_il(SFCODE(2,42), $2, $3); }
    | LBRACE hcack RBRACE               { $$ = func_il(SFCODE(2,42), $2, NULL); }
    ;

result_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE results RBRACE             { $$ = $2; }
    ;

results
    : result                            { $$ = make_item_list(NULL, $1); }
    | results result                    { $$ = make_item_list($1, $2); }
    ;

result
    : LBRACE cpname cpack RBRACE        { $$ = mklist_2items($2, $3); }
    ;

/* Reset Spooling Streams and Functions */
s2f43_decl
    : LBRACE RBRACE                     { $$ = func_listitem(SFCODE(2,43), NULL); }
    | LBRACE stream_list RBRACE         { $$ = func_listitem(SFCODE(2,43), $2); }
    ;

stream_list
    : stream                            { $$ = make_item_list(NULL, $1); }
    | stream_list stream                { $$ = make_item_list($1, $2); }
    ;

stream
    : LBRACE strid fcnid_list RBRACE    { $$ = mklist_item_itemlist($2, $3); }
    ;

fcnid_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE fcnids RBRACE              { $$ = $2; }
    ;

fcnids
    : fcnid                             { $$ = make_item_list(NULL, $1); }
    | fcnids fcnid                      { $$ = make_item_list($1, $2); }
    ;

/* Reset Spooling Acknowledge */
s2f44_decl
    : LBRACE rspack stream_ack_list RBRACE
        { $$ = func_il(SFCODE(2,44), $2, $3); }
    ;

stream_ack_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE stream_ack_set RBRACE      { $$ = $2; }
    ;

stream_ack_set
    : stream_ack                        { $$ = make_item_list(NULL, $1); }
    | stream_ack_set stream_ack         { $$ = make_item_list($1, $2); }
    ;

stream_ack
    : LBRACE strid strack fcnid_list RBRACE
        { $$ = make_stream_ack($2, $3, $4); }
    ;

/* Define Variable Limit Attributes */
s2f45_decl
    : LBRACE dataid limit_decl_list RBRACE
        { $$ = func_il(SFCODE(2,45), $2, $3); }
    | LBRACE dataid RBRACE
        { $$ = func_il(SFCODE(2,45), $2, NULL); }
    ;

limit_decl_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE limit_decl_s RBRACE        { $$ = $2; }
    ;

limit_decl_s
    : limit_decl                        { $$ = make_item_list(NULL, $1); }
    | limit_decl_s limit_decl           { $$ = make_item_list($1, $2); }
    ;

limit_decl
    : LBRACE vid limit_list RBRACE      { $$ = mklist_item_itemlist($2, $3); }
    ;

limit_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE limit_attr_list RBRACE     { $$ = $2; }
    ;

limit_attr_list
    : limit_attr                        { $$ = make_item_list(NULL, $1); }
    | limit_attr_list limit_attr        { $$ = make_item_list($1, $2); }
    ;

limit_attr
    : LBRACE limitid LBRACE upperdb lowerdb RBRACE RBRACE
        { $$ = make_limit_data($2, $4, $5); }
    | LBRACE limitid RBRACE
        { $$ = make_limit_data($2, NULL, NULL); }
    ;

/* Variable Limit Attribute Acknowledge */
s2f46_decl
    : LBRACE vlaack limit_ack_list RBRACE
        { $$ = func_il(SFCODE(2,46), $2, $3); }
    ;

limit_ack_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE limit_ack_set RBRACE       { $$ = $2; }
    ;

limit_ack_set
    : limit_ack                         { $$ = make_item_list(NULL, $1); }
    | limit_ack_set limit_ack           { $$ = make_item_list($1, $2); }
    ;

limit_ack
    : LBRACE vid lvack limitid limitack RBRACE
        { $$ = make_limit_ack($2, $3, $4, $5); }
    | LBRACE vid lvack RBRACE
        { $$ = make_limit_ack($2, $3, NULL, NULL); }
    ;

/* Variable Limit Attribute Request */
s2f47_decl
    : vid_list                          { $$ = func_listitem(SFCODE(2,47), $1); }
    ;

/* Variable Limit Attributes Send */
s2f48_decl
    : var_limit_list                    { $$ = func_listitem(SFCODE(2,48), $1); }
    ;

var_limit_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE var_limits RBRACE          { $$ = $2; }
    ;

var_limits
    : var_limit                         { $$ = make_item_list(NULL, $1); }
    | var_limits var_limit              { $$ = make_item_list($1, $2); }
    ;

var_limit
    : LBRACE vid units limitmin limitmax limit_def_list RBRACE
        { $$ = make_var_limit($2, $3, $4, $5, $6); }
    | LBRACE vid RBRACE
        { $$ = make_var_limit($2, NULL, NULL, NULL, NULL); }
    ;

limit_def_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE limit_defs RBRACE          { $$ = $2; }
    ;

limit_defs
    : limit_def                         { $$ = make_item_list(NULL, $1); }
    | limit_defs limit_def              { $$ = make_item_list($1, $2); }
    ;

limit_def
    : LBRACE limitid upperdb lowerdb RBRACE
        { $$ = mklist_3items($2, $3, $4); }
    ;

/* Enhanced Remote Command */
s2f49_decl
    : LBRACE dataid objspec rcmd RBRACE
        { $$ = func_iiil(SFCODE(2,49), $2, $3, $4, NULL); }
    | LBRACE dataid objspec rcmd cmdparm_list RBRACE
        { $$ = func_iiil(SFCODE(2,49), $2, $3, $4, $5); }
    ;

cmdparm_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE cmd_parameters RBRACE      { $$ = $2; }
    ;

cmd_parameters
    : cmd_parm                          { $$ = make_item_list(NULL, $1); }
    | cmd_parameters cmd_parm           { $$ = make_item_list($1, $2); }
    ;

cmd_parm
    : LBRACE cpname cepval RBRACE       { $$ = mklist_2items($2, $3); }
    ;

/* Enhanced Remote Command Acknowledge */
s2f50_decl
    : LBRACE hcack ercmd_result_list RBRACE
        { $$ = func_il(SFCODE(2,50), $2, $3); }
    | LBRACE hcack RBRACE
        { $$ = func_il(SFCODE(2,50), $2, NULL); }
    ;

ercmd_result_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE ercmd_results RBRACE       { $$ = $2; }
    ;

ercmd_results
    : ercmd_result                      { $$ = make_item_list(NULL, $1); }
    | ercmd_results ercmd_result        { $$ = make_item_list($1, $2); }
    ;

ercmd_result
    : LBRACE cpname cepack RBRACE       { $$ = mklist_2items($2, $3); }
    ;

/* Abort Transaction */
s3f0_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(3,0)); }
    ;

/* Material Status Request */
s3f1_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(3,1)); }
    ;

/* Material Status Data */
s3f2_decl
    : LBRACE mf material_status_list RBRACE
        { $$ = func_il(SFCODE(3,2), $2, $3); }
    ;

material_status_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE material_status_set RBRACE { $$ = $2; }
    ;

material_status_set
    : material_status                       { $$ = make_item_list(NULL, $1); }
    | material_status_set material_status   { $$ = make_item_list($1, $2); }
    ;

material_status
    : LBRACE loc qua mid RBRACE         { $$ = mklist_3items($2, $3, $4); }
    ;

/* Time to Completion Request */
s3f3_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(3,3)); }
    ;

/* Time to Completion Data */
s3f4_decl
    : LBRACE mf comp_time_list RBRACE
        { $$ = func_il(SFCODE(3,4), $2, $3); }
    ;

comp_time_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE comp_times RBRACE          { $$ = $2; }
    ;

comp_times
    : comp_time                         { $$ = make_item_list(NULL, $1); }
    | comp_times comp_time              { $$ = make_item_list($1, $2); }
    ;

comp_time
    : LBRACE ttc qua mid RBRACE         { $$ = mklist_3items($2, $3, $4); }
    ;

/* Material Found Send */
s3f5_decl
    : LBRACE mf qua RBRACE              { $$ = func_item2(SFCODE(3,5), $2, $3); }
    ;

/* Material Found Acknowledge */
s3f6_decl
    : ackc3                             { $$ = func_item1(SFCODE(3,6), $1); }
    ;

/* Material Lost Send */
s3f7_decl
    : LBRACE mf qua mid RBRACE
        { $$ = func_item3(SFCODE(3,7), $2, $3, $4); }
    ;

/* Material Lost Acknowledge */
s3f8_decl
    : ackc3                             { $$ = func_item1(SFCODE(3,8), $1); }
    ;

/* Material ID Equate Send */
s3f9_decl
    : LBRACE mid emid RBRACE            { $$ = func_item2(SFCODE(3,9), $2, $3); }
    ;

/* Material ID Equate Acknowledge */
s3f10_decl
    : ackc3                             { $$ = func_item1(SFCODE(3,10), $1); }
    ;

/* Material ID Request */
s3f11_decl
    : ptn                               { $$ = func_item1(SFCODE(3,11), $1); }
    ;

/* Material ID Request Acknowledge */
s3f12_decl
    : LBRACE ptn midra mid RBRACE
        { $$ = func_item3(SFCODE(3,12), $2, $3, $4); }
    ;

/* Material ID Send */
s3f13_decl
    : LBRACE ptn mid RBRACE             { $$ = func_item2(SFCODE(3,13), $2, $3); }
    ;

/* Material ID Acknowledge */
s3f14_decl
    : midac                             { $$ = func_item1(SFCODE(3,14), $1); }
    ;

/* Multi-block Inquire */
s3f15_decl
    : LBRACE dataid datalength RBRACE
        { $$ = func_item2(SFCODE(3,15), $2, $3); }
    ;

/* Multi-block Grant */
s3f16_decl
    : grant                             { $$ = func_item1(SFCODE(3,16), $1); }
    ;

/* Carrier Action Request */
s3f17_decl
    : LBRACE dataid carrieraction carrierspec ptn cattr_list RBRACE
        { $$ = func_iiiil(SFCODE(3,17), $2, $3, $4, $5, $6); }
    ;

cattr_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE cattrs RBRACE              { $$ = $2; }
    ;

cattrs
    : cattr                             { $$ = make_item_list(NULL, $1); }
    | cattrs cattr                      { $$ = make_item_list($1, $2); }
    ;

cattr
    : LBRACE cattrid cattrdata RBRACE   { $$ = mklist_2items($2, $3); }
    ;

/* Carrier Action Acknowledge */
s3f18_decl
    : LBRACE caack error_list RBRACE
        { $$ = func_il(SFCODE(3,18), $2, $3); }
    ;

/* Cancel All Carrier Out Request */
s3f19_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(3,19)); }
    ;

/* Cancel All Carrier Out Acknowledge */
s3f20_decl
    : LBRACE caack error_list RBRACE
        { $$ = func_il(SFCODE(3,20), $2, $3); }
    ;

/* Port Group Definition */
s3f21_decl
    : LBRACE portgrpname accessmode ptn_list RBRACE
        { $$ = func_iil(SFCODE(3,21), $2, $3, $4); }
    ;

ptn_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE ptns RBRACE                { $$ = $2; }
    ;

ptns
    : ptn                               { $$ = make_item_list(NULL, $1); }
    | ptns ptn                          { $$ = make_item_list($1, $2); }
    ;

/* Port Group Definition Acknowledge */
s3f22_decl
    : LBRACE caack error_list RBRACE
        { $$ = func_il(SFCODE(3,22), $2, $3); }
    ;

/* Port Group Action Request */
s3f23_decl
    : LBRACE pgrpaction portgrpname paramval_list RBRACE
        { $$ = func_iil(SFCODE(3,23), $2, $3, $4); }
    ;

paramval_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE paramvals RBRACE           { $$ = $2; }
    ;

paramvals
    : paramval_pair                     { $$ = make_item_list(NULL, $1); }
    | paramvals paramval_pair           { $$ = make_item_list($1, $2); }
    ;

paramval_pair
    : LBRACE paramname paramval RBRACE  { $$ = mklist_2items($2, $3); }
    ;

/* Port Group Action Acknowledge */
s3f24_decl
    : LBRACE caack error_list RBRACE
        { $$ = func_il(SFCODE(3,24), $2, $3); }
    ;

/* Port Action Request */
s3f25_decl
    : LBRACE portaction ptn paramval_list RBRACE
        { $$ = func_iil(SFCODE(3,25), $2, $3, $4); }
    ;

/* Port Action Acknowledge */
s3f26_decl
    : LBRACE caack error_list RBRACE
        { $$ = func_il(SFCODE(3,26), $2, $3); }
    ;

/* Change Access */
s3f27_decl
    : LBRACE accessmode ptn_list RBRACE
        { $$ = func_il(SFCODE(3,27), $2, $3); }
    ;

/* Change Access Acknowledge */
s3f28_decl
    : LBRACE caack ptnerror_list RBRACE
        { $$ = func_il(SFCODE(3,28), $2, $3); }
    ;

ptnerror_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE ptnerrors RBRACE           { $$ = $2; }
    ;

ptnerrors
    : ptnerror                          { $$ = make_item_list(NULL, $1); }
    | ptnerrors ptnerror                { $$ = make_item_list($1, $2); }
    ;

ptnerror
    : LBRACE ptn errcode errtext RBRACE { $$ = mklist_3items($2, $3, $4); }
    ;

/* Carrier Tag Read Request */
s3f29_decl
    : LBRACE locid carrierspec dataseg datalength RBRACE
        { $$ = func_item4(SFCODE(3,29), $2, $3, $4, $5); }
    ;

/* Carrier Tag Read Data */
s3f30_decl
    : LBRACE data ctag_ack RBRACE
        { $$ = func_item2(SFCODE(3,30), $2, $3); }
    ;

ctag_ack
    : LBRACE caack error_list RBRACE    { $$ = mklist_2items($2, $3); }
    | LBRACE caack RBRACE               { $$ = mklist_2items($2, NULL); }
    ;

/* Carrier Tag Write Request */
s3f31_decl
    : LBRACE locid carrierspec dataseg datalength data RBRACE
        { $$ = func_item5(SFCODE(3,31), $2, $3, $4, $5, $6); }
    ;

/* Carrier Tag Write Data Acknowledge */
s3f32_decl
    : LBRACE caack error_list RBRACE
        { $$ = func_il(SFCODE(3,32), $2, $3); }
    ;


/* Abort Transaction */
s4f0_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(4,0)); }
    ;

/* Ready to Send Material */
s4f1_decl
    : LBRACE ptn mid RBRACE             { $$ = func_item2(SFCODE(4,1), $2, $3); }
    ;

/* Ready to Send Acknowledge */
s4f2_decl
    : rsack                             { $$ = func_item1(SFCODE(4,2), $1); }
    ;

/* Send Material */
s4f3_decl
    : LBRACE ptn mid RBRACE             { $$ = func_item2(SFCODE(4,3), $2, $3); }
    ;

/* Handshake Complete */
s4f5_decl
    : LBRACE ptn mid RBRACE             { $$ = func_item2(SFCODE(4,5), $2, $3); }
    ;

/* Not Ready to Send */
s4f7_decl
    : LBRACE ptn mid RBRACE             { $$ = func_item2(SFCODE(4,7), $2, $3); }
    ;

/* Stuck in Sender */
s4f9_decl
    : LBRACE ptn mid RBRACE             { $$ = func_item2(SFCODE(4,9), $2, $3); }
    ;

/* Stuck in Receiver */
s4f11_decl
    : LBRACE ptn mid RBRACE             { $$ = func_item2(SFCODE(4,11), $2, $3); }
    ;

/* Send Incomplete Timeout */
s4f13_decl
    : LBRACE ptn mid RBRACE             { $$ = func_item2(SFCODE(4,13), $2, $3); }
    ;

/* Material Received */
s4f15_decl
    : LBRACE ptn mid RBRACE             { $$ = func_item2(SFCODE(4,15), $2, $3); }
    ;

/* Request to Receive */
s4f17_decl
    : LBRACE ptn mid RBRACE             { $$ = func_item2(SFCODE(4,17), $2, $3); }
    ;

/* Request to Receive Acknowledge */
s4f18_decl
    : rrack                             { $$ = func_item1(SFCODE(4,18), $1); }
    ;

/* Transfer Job Create */
s4f19_decl
    : LBRACE dataid trjobname trjob_list RBRACE
        { $$ = func_s4f19($2, $3, $4); }
    ;

trjob_list
    : trjob_decl                        { $$ = make_item_list(NULL, $1); }
    | trjob_list trjob_decl             { $$ = make_item_list($1, $2); }
    ;

trjob_decl
    : LBRACE trlink trport trobjname trobjtype trrole trrcp trptnr trptport trdir trtype trlocation trautostart RBRACE
        { $$ = make_trjob($2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13); }
    ;

/* Transfer Job Acknowledge */
s4f20_decl
    : LBRACE trjobid tratomicid_list tr_result RBRACE
        { $$ = func_s4f20($2, $3, $4); }
    ;

tratomicid_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE tratomicids RBRACE         { $$ = $2; }
    ;

tratomicids
    : tratomicid                        { $$ = make_item_list(NULL, $1); }
    | tratomicids tratomicid            { $$ = make_item_list($1, $2); }
    ;

tr_result
    : LBRACE track error_list RBRACE
        { $$ = mklist_item_itemlist($2, $3); }
    ;

/* Transfer Job Command */
s4f21_decl
    : LBRACE trjobid trcmdname parameter_list RBRACE
        { $$ = func_iil(SFCODE(4,21), $2, $3, $4); }
    ;

/* Transfer Command Acknowledge */
s4f22_decl
    : LBRACE track error_list RBRACE
        { $$ = func_item2(SFCODE(4,22), $2, $3); }
    ;

/* Transfer Job Alert */
s4f23_decl
    : LBRACE trjobid trjobname trjobms tr_result RBRACE
        { $$ = func_item4(SFCODE(4,23), $2, $3, $4, $5); }
    ;

/* Transfer Alert Acknowledge */
s4f24_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(4,24)); }
    ;

/* Multi-Block Inquire */
s4f25_decl
    : LBRACE dataid datalength RBRACE
        { $$ = func_item2(SFCODE(4,25), $2, $3); }
    ;

/* Multi-Block Grant */
s4f26_decl
    : grant                             { $$ = func_item1(SFCODE(4,26), $1); }
    ;

/* Handoff Ready */
s4f27_decl
    : LBRACE eqname trlink trport trobjname trobjtype trrole trptnr trptport trdir trtype trlocation RBRACE
        { $$ = func_s4f27($2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12); }
    ;

/* Handoff Command */
s4f29_decl
    : LBRACE trlink mcindex hocmdname parameter_list RBRACE
        { $$ = func_iiil(SFCODE(4,29), $2, $3, $4, $5); }
    ;

/* Handoff Command Complete */
s4f31_decl
    : LBRACE trlink mcindex ho_result RBRACE
        { $$ = func_item3(SFCODE(4,31), $2, $3, $4); }
    ;

ho_result
    : LBRACE hoack error_list RBRACE    { $$ = mklist_item_itemlist($2, $3); }
    ;


/* Handoff Verify */
s4f33_decl
    : LBRACE trlink ho_result RBRACE
        { $$ = func_item2(SFCODE(4,33), $2, $3); }
    ;

/* Handoff Cancel Ready */
s4f35_decl
    : trlink                            { $$ = func_item1(SFCODE(4,35), $1); }
    ;

/* Handoff Cancel Ready Acknowledge */
s4f37_decl
    : LBRACE trlink hocancelack RBRACE
        { $$ = func_item2(SFCODE(4,37), $2, $3); }
    ;

/* Handoff Halt */
s4f39_decl
    : trlink                            { $$ = func_item1(SFCODE(4,39), $1); }
    ;

/* Handoff Halt Acknowledge */
s4f41_decl
    : LBRACE trlink hohaltack RBRACE
        { $$ = func_item2(SFCODE(4,41), $2, $3); }
    ;

/* Abort Transaction */
s5f0_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(5,0)); }
    ;

/* Alarm Report Send */
s5f1_decl
    : LBRACE alcd alid altx RBRACE
        { $$ = func_item3(SFCODE(5,1), $2, $3, $4); }
    ;

/* Alarm Report Acknowledge */
s5f2_decl
    : ackc5                             { $$ = func_item1(SFCODE(5,2), $1); }
    ;

/* Enable/Disable Alarm Send */
s5f3_decl
    : LBRACE aled alid RBRACE           { $$ = func_item2(SFCODE(5,3), $2, $3); }
    ;

/* Enable/Disable Alarm Acknowledge */
s5f4_decl
    : ackc5                             { $$ = func_item1(SFCODE(5,4), $1); }
    ;

/* List Alarms Request */
s5f5_decl
    : alid_list                         { $$ = func_s5f5($1); }
    ;

alid_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE alids RBRACE               { $$ = $2; }
    ;

alids
    : alid                              { $$ = make_alid_array(NULL, $1); }
    | alids alid                        { $$ = make_alid_array($1, $2); }
    ;

/* List Alarm Data */
s5f6_decl
    : alarm_data_list                   { $$ = func_listitem(SFCODE(5,6), $1); }
    ;

alarm_data_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE alarm_data RBRACE          { $$ = $2; }
    ;

alarm_data
    : alarm_datum                       { $$ = make_item_list(NULL, $1); }
    | alarm_data alarm_datum            { $$ = make_item_list($1, $2); }
    ;

alarm_datum
    : LBRACE alcd alid altx RBRACE      { $$ = mklist_3items($2, $3, $4); }
    ;

/* List Enabled Alarm Request */
s5f7_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(5,7)); }
    ;

/* List Enabled Alarm Data */
s5f8_decl
    : alarm_data_list                   { $$ = func_listitem(SFCODE(5,8), $1); }
    ;

/* Exception Post Notify */
s5f9_decl
    : LBRACE timestamp exid extype exmessage exrecvra_list RBRACE
        { $$ = func_iiiil(SFCODE(5,9), $2, $3, $4, $5, $6); }
    | LBRACE timestamp exid extype exmessage RBRACE
        { $$ = func_iiiil(SFCODE(5,9), $2, $3, $4, $5, NULL); }
    ;

exrecvra_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE exrecvra_s RBRACE          { $$ = $2; }
    ;

exrecvra_s
    : exrecvra                          { $$ = make_item_list(NULL, $1); }
    | exrecvra_s exrecvra               { $$ = make_item_list($1, $2); }
    ;

/* Exception Post Confirm */
s5f10_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(5,10)); }
    ;

/* Exception Clear Notify */
s5f11_decl
    : LBRACE timestamp exid extype exmessage RBRACE
        { $$ = func_item4(SFCODE(5,11), $2, $3, $4, $5); }
    ;

/* Exception Clear Confirm */
s5f12_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(5,12)); }
    ;

/* Exception Recover Request */
s5f13_decl
    : LBRACE exid exrecvra RBRACE       { $$ = func_item2(SFCODE(5,13), $2, $3); }
    ;

/* Exception Recover Acknowledge */
s5f14_decl
    : LBRACE exid acka_list RBRACE      { $$ = func_item2(SFCODE(5,14), $2, $3); }
    ;

acka_list
    : LBRACE acka error_decl RBRACE     { $$ = mklist_item_itemlist($2, $3); }
    | LBRACE acka LBRACE RBRACE RBRACE  { $$ = mklist_item_itemlist($2, NULL); }
    | LBRACE acka RBRACE                { $$ = mklist_item_itemlist($2, NULL); }
    ;

/* Exception Recover Complete Notify */
s5f15_decl
    : LBRACE timestamp exid acka_list RBRACE
        { $$ = func_item3(SFCODE(5,15), $2, $3, $4); }
    ;

/* Exception Recover Complete Confirm */
s5f16_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(5,12)); }
    ;

/* Exception Recover Abort Request */
s5f17_decl
    : exid                              { $$ = func_item1(SFCODE(5,17), $1); }
    ;

/* Exception Recover Abort Acknowledge */
s5f18_decl
    : LBRACE exid acka_list RBRACE      { $$ = func_item2(SFCODE(5,18), $2, $3); }
    ;

/* Abort Transaction */
s6f0_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(6,0)); }
    ;

/* Trace Data Send */
s6f1_decl
    : LBRACE trid smpln stime sv_list RBRACE
        { $$ = func_s6f1($2, $3, $4, $5); }
    ;

/* Trace Data Acknowledge */
s6f2_decl
    : ackc6                             { $$ = func_item1(SFCODE(6,2), $1); }
    ;

/* Discrete Variable Data Send */
s6f3_decl
    : LBRACE dataid ceid senddata_list RBRACE
        { $$ = func_s6f3($2, $3, $4); }
    ;

senddata_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE senddata RBRACE            { $$ = $2; }
    ;

senddata
    : senddatum                         { $$ = make_item_list(NULL, $1); }
    | senddata senddatum                { $$ = make_item_list($1, $2); }
    ;

senddatum
    : LBRACE dsid dvdata_list RBRACE    { $$ = mklist_item_itemlist($2, $3); }
    ;

dvdata_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE dvdata RBRACE              { $$ = $2; }
    ;

dvdata
    : dvdatum                           { $$ = make_item_list(NULL, $1); }
    | dvdata dvdatum                    { $$ = make_item_list($1, $2); }
    ;

dvdatum
    : LBRACE dvname dvval RBRACE        { $$ = mklist_2items($2, $3); }
    ;

/* Discrete Variable Data Acknowledge */
s6f4_decl
    : ackc6                             { $$ = func_item1(SFCODE(6,4), $1); }
    ;

/* Multi-Block Data Send Inquire */
s6f5_decl
    : LBRACE dataid datalength RBRACE
        { $$ = func_item2(SFCODE(6,5), $2, $3); }
    ;

/* Multi-Block Grant */
s6f6_decl
    : grant6                            { $$ = func_item1(SFCODE(6,6), $1); }
    ;

/* Data Transfer Request */
s6f7_decl
    : dataid                            { $$ = func_item1(SFCODE(6,7), $1); }
    ;

/* Data Transfer data */
s6f8_decl
    : LBRACE dataid ceid senddata_list RBRACE
        { $$ = func_iil(SFCODE(6,8), $2, $3, $4); }
    ;

/* Formatted Variable Send */
s6f9_decl
    : LBRACE pfcd dataid ceid formatted_var_list RBRACE
        { $$ = func_iiil(SFCODE(6,9), $2, $3, $4, $5); }
    ;

formatted_var_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE formatted_variables RBRACE { $$ = $2; }
    ;

formatted_variables
    : formatted_var                     { $$ = make_item_list(NULL, $1); }
    | formatted_variables formatted_var { $$ = make_item_list($1, $2); }
    ;

formatted_var
    : LBRACE dsid dvval_list RBRACE     { $$ = mklist_item_itemlist($2, $3); }
    ;

dvval_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE dvval_set RBRACE           { $$ = $2; }
    ;

dvval_set
    : dvval                             { $$ = make_item_list(NULL, $1); }
    | dvval_set dvval                   { $$ = make_item_list($1, $2); }
    ;

/* Formatted Variable Acknowledge */
s6f10_decl
    : ackc6                             { $$ = func_item1(SFCODE(6,10), $1); }
    ;

/* Event Report Send */
s6f11_decl
    : LBRACE dataid ceid event_data_list RBRACE
        { $$ = func_iil(SFCODE(6,11), $2, $3, $4); }
    ;

event_data_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE event_data RBRACE          { $$ = $2; }
    ;

event_data
    : event_datum                       { $$ = make_item_list(NULL, $1); }
    | event_data event_datum            { $$ = make_item_list($1, $2); }
    ;

event_datum
    : LBRACE rptid val_list RBRACE      { $$ = mklist_item_itemlist($2, $3); }
    ;

val_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE value_set RBRACE           { $$ = $2; }
    ;

value_set
    : val                               { $$ = make_item_list(NULL, $1); }
    | value_set val                     { $$ = make_item_list($1, $2); }
    ;

/* Event Report Acknowledge */
s6f12_decl
    : ackc6                             { $$ = func_item1(SFCODE(6,12), $1); }
    ;

/* Annotated Event Report Send */
s6f13_decl
    : LBRACE dataid ceid annotated_report_list RBRACE
        { $$ = func_iil(SFCODE(6,13), $2, $3, $4); }
    ;

annotated_report_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE annotated_reports RBRACE   { $$ = $2; }
    ;

annotated_reports
    : annotated_report                      { $$ = make_item_list(NULL, $1); }
    | annotated_reports annotated_report    { $$ = make_item_list($1, $2); }
    ;

annotated_report
    : LBRACE rptid annotated_data_list RBRACE
        { $$ = mklist_2items($2, $3); }
    ;

annotated_data_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE annotated_data RBRACE      { $$ = $2; }
    ;

annotated_data
    : annotated_datum                   { $$ = make_item_list(NULL, $1); }
    | annotated_data annotated_datum    { $$ = make_item_list($1, $2); }
    ;

annotated_datum
    : LBRACE vid val RBRACE             { $$ = mklist_2items($2, $3); }
    ;

/* Annotated Event Report Acknowledge */
s6f14_decl
    : ackc6                             { $$ = func_item1(SFCODE(6,14), $1); }
    ;

/* Event Report Request */
s6f15_decl
    : ceid                              { $$ = func_item1(SFCODE(6,15), $1); }
    ;

/* Event Report Data */
s6f16_decl
    : LBRACE dataid ceid event_data_list RBRACE
        { $$ = func_iil(SFCODE(6,16), $2, $3, $4); }
    ;

/* Annotated Event Report Request */
s6f17_decl
    : ceid                              { $$ = func_item1(SFCODE(6,17), $1); }
    ;

/* Annotated Event Report Data */
s6f18_decl
    : LBRACE dataid ceid annotated_report_list RBRACE
        { $$ = func_iil(SFCODE(6,18), $2, $3, $4); }
    ;

/* Indivisual Report Request */
s6f19_decl
    : rptid                             { $$ = func_item1(SFCODE(6,19), $1); }
    ;

/* Indivisual Report Data */
s6f20_decl
    : val_list                          { $$ = func_listitem(SFCODE(6,20), $1); }
    ;

/* Annotated Indivisual Report Request */
s6f21_decl
    : rptid                             { $$ = func_item1(SFCODE(6,21), $1); }
    ;

/* Annotated Indivisual Report Data */
s6f22_decl
    : annotated_data_list               { $$ = func_listitem(SFCODE(6,22), $1); }
    ;

/* Request Spooled Data */
s6f23_decl
    : rsdc                              { $$ = func_item1(SFCODE(6,23), $1); }
    ;

/* Request Spooled Data Acknowledge Send */
s6f24_decl
    : rsda                              { $$ = func_item1(SFCODE(6,24), $1); }
    ;

/* Notification Report Send */
s6f25_decl
    : LBRACE dataid opid linkid rcpspec rmchgstat rcpattr_list rmack_list RBRACE
        { $$ = func_s6f25($2, $3, $4, $5, $6, $7, $8); }
    ;

rcpattr_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE rcpattr_s RBRACE           { $$ = $2; }
    ;

rcpattr_s
    : rcpattr_decl                      { $$ = make_item_list(NULL, $1); }
    | rcpattr_s rcpattr_decl            { $$ = make_item_list($1, $2);   }
    ;

rcpattr_decl
    : LBRACE rcpattrid rcpattrdata RBRACE
        { $$ = mklist_2items($2, $3);  }
    ;

rmack_list
    : LBRACE rmack error_list RBRACE    { $$ = mklist_item_itemlist($2, $3); }
    | LBRACE rmack RBRACE               { $$ = mklist_item_itemlist($2, NULL); }
    ;

/* Notification Report Send Acknowledge */
s6f26_decl
    : ackc6                             { $$ = func_item1(SFCODE(6,26), $1); }
    ;

/* Trace Report Send */
s6f27_decl
    : LBRACE dataid trid event_data_list RBRACE
        { $$ = func_iil(SFCODE(6,27), $2, $3, $4); }
    ;

/* Trace Report Send Acknowledge */
s6f28_decl
    : trid                              { $$ = func_item1(SFCODE(6,28), $1); }
    ;

/* Trace Report Request */
s6f29_decl
    : trid                              { $$ = func_item1(SFCODE(6,29), $1); }
    ;

/* Trace Report Data */
s6f30_decl
    : LBRACE trid event_data_list errcode RBRACE
        { $$ = func_s6f30($2, $3, $4); }
    ;

/* Abort Transaction */
s7f0_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(7,0)); }
    ;

/* Process Program Load Inquire */
s7f1_decl
    : LBRACE ppid length RBRACE         { $$ = func_item2(SFCODE(7,1), $2, $3); }
    ;

/* Process Program Load Grant */
s7f2_decl
    : ppgnt                             { $$ = func_item1(SFCODE(7,2), $1); }
    ;

/* Process Program Send */
s7f3_decl
    : LBRACE ppid ppbody RBRACE         { $$ = func_item2(SFCODE(7,3), $2, $3); }
    ;

/* Process Program Acknowledge */
s7f4_decl
    : ackc7                             { $$ = func_item1(SFCODE(7,4), $1); }
    ;

/* Process Program Request */
s7f5_decl
    : ppid                              { $$ = func_item1(SFCODE(7,5), $1); }
    ;

/* Process Program Data */
s7f6_decl
    : LBRACE ppid ppbody RBRACE         { $$ = func_item2(SFCODE(7,6), $2, $3); }
    ;

/* Process Program ID Request */
s7f7_decl
    : mid                               { $$ = func_item1(SFCODE(7,7), $1); }
    ;

/* Process Program ID Data */
s7f8_decl
    : LBRACE ppid mid RBRACE            { $$ = func_item2(SFCODE(7,8), $2, $3); }
    ;

/* M/P M Request */
s7f9_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(7,9)); }
    ;

/* M/P M (Material/Process Matrix) Data */
s7f10_decl
    : material_process_list             { $$ = func_listitem(SFCODE(7,10), $1); }
    ;

material_process_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE material_processes RBRACE  { $$ = $2; }
    ;

material_processes
    : material_process                      { $$ = make_item_list(NULL, $1); }
    | material_processes material_process   { $$ = make_item_list($1, $2); }
    ;

material_process
    : LBRACE ppid mid_list RBRACE       { $$ = mklist_item_itemlist($2, $3); }
    ;

/* M/P M Update Send */
s7f11_decl
    : material_process_list             { $$ = func_listitem(SFCODE(7,11), $1); }
    ;

/* M/P M Update Acknowledge */
s7f12_decl
    : ackc7                             { $$ = func_item1(SFCODE(7,12), $1); }
    ;

/* Delete M/P M Entry Send */
s7f13_decl
    : material_process_list             { $$ = func_listitem(SFCODE(7,13), $1); }
    ;

/* Delete M/P M Entry Acknowledge */
s7f14_decl
    : ackc7                             { $$ = func_item1(SFCODE(7,14), $1); }
    ;

/* Matrix Mode Select Send */
s7f15_decl
    : mmode                             { $$ = func_item1(SFCODE(7,15), $1); }
    ;

/* Matrix Mode Select Acknowledge */
s7f16_decl
    : ackc7                             { $$ = func_item1(SFCODE(7,16), $1); }
    ;

/* Delete Process Program Send */
s7f17_decl
    : ppid_list                         { $$ = func_listitem(SFCODE(7,17), $1); }
    ;

ppid_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE ppids RBRACE               { $$ = $2; }
    ;

ppids
    : ppid                              { $$ = make_item_list(NULL, $1); }
    | ppids ppid                        { $$ = make_item_list($1, $2); }
    ;

/* Delete Process Program Acknowledge */
s7f18_decl
    : ackc7                             { $$ = func_item1(SFCODE(7,18), $1); }
    ;

/* Current EPPD Request */
s7f19_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(7,19)); }
    ;

/* Current EPPD Data */
s7f20_decl
    : ppid_list                         { $$ = func_listitem(SFCODE(7,20), $1); }
    ;

/* Equipment Process Capabilities Request */
s7f21_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(7,21)); }
    ;

/* Equipment Process Capabilities Data */
s7f22_decl
    : LBRACE mdln softrev cmdmax bytmax process_prog_list RBRACE
        { $$ = func_iiiil(SFCODE(7,22), $2, $3, $4, $5, $6); }
    ;

process_prog_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE process_programs RBRACE    { $$ = $2; }
    ;

process_programs
    : process_prog                      { $$ = make_item_list(NULL, $1); }
    | process_programs process_prog     { $$ = make_item_list($1, $2); }
    ;

process_prog
    : LBRACE ccode cname rqcmd blkdef bcds ibcds nbcds acds iacds nacds parameter_data RBRACE
        { $$ = make_proc_prog($2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12); }
    ;

parameter_data
    : LBRACE pname rqpar pdflt pmax llim ulim units resc resv RBRACE
        { $$ = make_parameter($2, $3, $4, $5, $6, $7, $8, $9, $10); }
    | LBRACE pname rqpar pdflt pmax stemp_list RBRACE
        { $$ = make_parameter($2, $3, $4, $5, $6, NULL, NULL, NULL, NULL); }
    | LBRACE pname rqpar pdflt pmax RBRACE
        { $$ = make_parameter($2, $3, $4, $5, NULL, NULL, NULL, NULL, NULL); }
    ;

stemp_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE stemps RBRACE              { $$ = $2; }
    ;

stemps
    : stemp                             { $$ = make_item_list(NULL, $1); }
    | stemps stemp                      { $$ = make_item_list($1, $2); }
    ;

/* Formatted Process Program Send */
s7f23_decl
    : LBRACE ppid mdln softrev proc_cmd_list RBRACE
        { $$ = func_iiil(SFCODE(7,23), $2, $3, $4, $5); }
    ;

proc_cmd_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE proc_commands RBRACE       { $$ = $2; }
    ;

proc_commands
    : proc_cmd                          { $$ = make_item_list(NULL, $1); }
    | proc_commands proc_cmd            { $$ = make_item_list($1, $2); }
    ;

proc_cmd
    : LBRACE ccode pparm_list RBRACE    { $$ = mklist_item_itemlist($2, $3); }
    ;

pparm_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE pparameters RBRACE         { $$ = $2; }
    ;

pparameters
    : pparm                             { $$ = make_item_list(NULL, $1); }
    | pparameters pparm                 { $$ = make_item_list($1, $2); }
    ;

/* Formatted Process Program Acknowledge */
s7f24_decl
    : ackc7                             { $$ = func_item1(SFCODE(7,24), $1); }
    ;

/* Formatted Process Program Request */
s7f25_decl
    : ppid                              { $$ = func_item1(SFCODE(7,25), $1); }
    ;

/* Formatted Process Program Data */
s7f26_decl
    : LBRACE ppid mdln softrev proc_cmd_list RBRACE
        { $$ = func_iiil(SFCODE(7,26), $2, $3, $4, $5); }
    ;

/* Process Program Verification Send */
s7f27_decl
    : LBRACE ppid pp_verification_list RBRACE
        { $$ = func_il(SFCODE(7,27), $2, $3); }
    ;

pp_verification_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE pp_verifications RBRACE    { $$ = $2; }
    ;

pp_verifications
    : pp_verification                   { $$ = make_item_list(NULL, $1); }
    | pp_verifications pp_verification  { $$ = make_item_list($1, $2); }
    ;

pp_verification
    : LBRACE ackc7a seqnum errw7 RBRACE { $$ = mklist_3items($2, $3, $4); }
    ;


/* Process Program Verification Acknowledge */
s7f28_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(7,28)); }
    ;

/* Process Program Verification Inquire */
s7f29_decl
    : length                            { $$ = func_item1(SFCODE(7,29), $1); }
    ;

/* Process Program Verification Grant */
s7f30_decl
    : ppgnt                             { $$ = func_item1(SFCODE(7,30), $1); }
    ;

/* Verification Request Send */
s7f31_decl
    : LBRACE ppid mdln softrev proc_cmd_list RBRACE
        { $$ = func_iiil(SFCODE(7,31), $2, $3, $4, $5); }
    ;

/* Verification Request Acknowledge */
s7f32_decl
    : ackc7                             { $$ = func_item1(SFCODE(7,32), $1); }
    ;

/* Process Program Available Request */
s7f33_decl
    : ppid                              { $$ = func_item1(SFCODE(7,33), $1); }
    ;

/* Process Program Availability Data */
s7f34_decl
    : LBRACE ppid unflen frmlen RBRACE
        { $$ = func_item3(SFCODE(7,34), $2, $3, $4); }
    ;

/* Process Program for MID Request */
s7f35_decl
    : mid                               { $$ = func_item1(SFCODE(7,35), $1); }
    ;

/* Process Program for MID Data */
s7f36_decl
    : LBRACE RBRACE                     { $$ = func_s7f36(NULL, NULL, NULL); }
    | LBRACE mid ppid ppbody RBRACE     { $$ = func_s7f36($2, $3, $4); }
    ;

/* Abort Transaction */
s8f0_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(8,0)); }
    ;

/* Boot Program Request */
s8f1_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(8,1)); }
    ;

/* Boot Program Data */
s8f2_decl
    : bpd                               { $$ = func_s8f2($1); }
    | /* empty */                       { $$ = func_s8f2(NULL); }
    ;

/* Executive Program Request */
s8f3_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(8,3)); }
    ;

/* Executive Program Data */
s8f4_decl
    : epd                               { $$ = func_s8f4($1); }
    | /* empty */                       { $$ = func_s8f4(NULL); }
    ;

/* Abort Transaction */
s9f0_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(9,0)); }
    ;

/* Unrecognized Device ID */
s9f1_decl
    : mhead                             { $$ = func_item1(SFCODE(9,1), $1); }
    ;

/* Unrecognized Stream Type */
s9f3_decl
    : mhead                             { $$ = func_item1(SFCODE(9,3), $1); }
    ;

/* Unrecognized Function Type */
s9f5_decl
    : mhead                             { $$ = func_item1(SFCODE(9,5), $1); }
    ;

/* Illegal Data */
s9f7_decl
    : mhead                             { $$ = func_item1(SFCODE(9,7), $1); }
    ;

/* Transaction Timer Timeout */
s9f9_decl
    : shead                             { $$ = func_item1(SFCODE(9,9), $1); }
    ;

/* Data Too Long */
s9f11_decl
    : mhead                             { $$ = func_item1(SFCODE(9,11), $1); }
    ;

/* Conversation Timeout */
s9f13_decl
    : LBRACE mexp edid RBRACE           { $$ = func_item2(SFCODE(9,13), $2, $3); }
    ;

/* Abort Transaction */
s10f0_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(10,0)); }
    ;

/* Terminal Request */
s10f1_decl
    : LBRACE tid text RBRACE            { $$ = func_item2(SFCODE(10,1), $2, $3); }
    ;

/* Terminal Request Acknowledge */
s10f2_decl
    : ackc10                            { $$ = func_item1(SFCODE(10,2), $1); }
    ;

/* Terminal Display, Single */
s10f3_decl
    : LBRACE tid text RBRACE            { $$ = func_item2(SFCODE(10,3), $2, $3); }
    ;

/* Terminal Display, Single Acknowledge */
s10f4_decl
    : ackc10                            { $$ = func_item1(SFCODE(10,4), $1); }
    ;

/* Terminal Display, Multi-Block */
s10f5_decl
    : LBRACE tid text_list RBRACE       { $$ = func_il(SFCODE(10,5), $2, $3); }
    ;

text_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE texts RBRACE               { $$ = $2; }
    ;

texts
    : text                              { $$ = make_item_list(NULL, $1); }
    | texts text                        { $$ = make_item_list($1, $2); }
    ;

/* Terminal Display, Multi-Block Acknowledge */
s10f6_decl
    : ackc10                            { $$ = func_item1(SFCODE(10,6), $1); }
    ;

/* Multi-Block Not Allowed */
s10f7_decl
    : tid                               { $$ = func_item1(SFCODE(10,7), $1); }
    ;

/* Broadcast */
s10f9_decl
    : text                              { $$ = func_item1(SFCODE(10,9), $1); }
    ;

/* Broadcast Acknowledge */
s10f10_decl
    : ackc10                            { $$ = func_item1(SFCODE(10,10), $1); }
    ;

/* Transaction */
s11f0_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(11,0)); }
    ;

/* Abort Transaction */
s12f0_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(12,0)); }
    ;

/* Map Set-up Data Send */
s12f1_decl
    : LBRACE mid idtyp fnloc ffrot orloc rpsel refp_list dutms xdies ydies rowct colct nulbc prdct praxi RBRACE
        { $$ = func_s12f1($2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16); }
    ;

refp_list
    : LBRACE refpoints RBRACE           { $$ = $2; }
    ;

refpoints
    : refp_xy                           { $$ = make_item_list(NULL, $1); }
    | refpoints refp_xy                 { $$ = make_item_list($1, $2); }
    ;

/* Map Set-up Data Acknowledge */
s12f2_decl
    : sdack                             { $$ = func_item1(SFCODE(12,2), $1); }
    ;

/* Map Set-up Data Request */
s12f3_decl
    : LBRACE mid idtyp mapft fnloc ffrot orloc praxi bcequ nulbc RBRACE
        { $$ = func_s12f3($2, $3, $4, $5, $6, $7, $8, $9, $10); }
    ;

/* Map Set-up Data */
s12f4_decl
    : LBRACE mid idtyp fnloc orloc rpsel refp_list dutms xdies ydies rowct
             colct prdct bcequ nulbc mlcl RBRACE
        { $$ = func_s12f4($2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16); }
    | /* empty */
        { $$ = func_nobody(SFCODE(12,4)); }
    ;

/* Map Transmit Inquire */
s12f5_decl
    : LBRACE mid idtyp mapft mlcl RBRACE
        { $$ = func_item4(SFCODE(12,5), $2, $3, $4, $5); }
    ;

/* Map Transmit Grant */
s12f6_decl
    : grnt1                             { $$ = func_item1(SFCODE(12,6), $1); }
    ;

/* Map Data Send Type 1 */
s12f7_decl
    : LBRACE mid idtyp mapdata_list RBRACE
        { $$ = func_iil(SFCODE(12,7), $2, $3, $4); }
    ;

mapdata_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE mapdata RBRACE             { $$ = $2; }
    ;

mapdata
    : mapdatum                          { $$ = make_item_list(NULL, $1); }
    | mapdata mapdatum                  { $$ = make_item_list($1, $2); }
    ;

mapdatum
    : LBRACE rsinf binlt RBRACE         { $$ = mklist_2items($2, $3); }
    ;

/* Map Data Acknowledge Type 1 */
s12f8_decl
    : mdack                             { $$ = func_item1(SFCODE(12,8), $1); }
    ;

/* Map Data Send Type 2 */
s12f9_decl
    : LBRACE mid idtyp strp_xy binlt RBRACE
        { $$ = func_item4(SFCODE(12,9), $2, $3, $4, $5); }
    ;

/* Map Data Acknowledge Type 2 */
s12f10_decl
    : mdack                             { $$ = func_item1(SFCODE(12,10), $1); }
    ;

/* Data Send Type 3 */
s12f11_decl
    : LBRACE mid idtyp xypos_data_list RBRACE
        { $$ = func_iil(SFCODE(12,11), $2, $3, $4); }
    ;

xypos_data_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE xypos_data RBRACE          { $$ = $2; }
    ;

xypos_data
    : xypos_datum                       { $$ = make_item_list(NULL, $1); }
    | xypos_data xypos_datum            { $$ = make_item_list($1, $2); }
    ;

xypos_datum
    : LBRACE xypos binlt RBRACE         { $$ = mklist_2items($2, $3); }
    ;

/* Map Data Type 3 */
s12f12_decl
    : mdack                             { $$ = func_item1(SFCODE(12,12), $1); }
    ;

/* Map Data Type 1 */
s12f13_decl
    : LBRACE mid idtyp RBRACE           { $$ = func_item2(SFCODE(12,13), $2, $3); }
    ;

/* Map Data 1 */
s12f14_decl
    : LBRACE RBRACE
        { $$ = func_nobody(SFCODE(12,14)); }
    | LBRACE mid idtyp map_rowcol_list RBRACE
        { $$ = func_iil(SFCODE(12,14), $2, $3, $4); }
    ;

map_rowcol_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE map_rowcol RBRACE          { $$ = $2; }
    ;

map_rowcol
    : rowcol                            { $$ = make_item_list(NULL, $1); }
    | map_rowcol rowcol                 { $$ = make_item_list($1, $2); }
    ;

rowcol
    : LBRACE rsinf_xyd binlt RBRACE     { $$ = mklist_2items($2, $3); }
    ;

/* Map Data Type 2 */
s12f15_decl
    : LBRACE mid idtyp RBRACE           { $$ = func_item2(SFCODE(12,15), $2, $3); }
    ;

/* Map Data 2 */
s12f16_decl
    : LBRACE RBRACE
        { $$ = func_nobody(SFCODE(12,16)); }
    | LBRACE mid idtyp strp_xy binlt RBRACE
        { $$ = func_item4(SFCODE(12,16), $2, $3, $4, $5); }
    ;

/* Map Data Type 3 */
s12f17_decl
    : LBRACE mid idtyp sdbin RBRACE     { $$ = func_item3(SFCODE(12,17), $2, $3, $4); }
    ;

/* Map Data 3 */
s12f18_decl
    : LBRACE RBRACE
        { $$ = func_nobody(SFCODE(12,18)); }
    | LBRACE mid idtyp xypos_data_list RBRACE
        { $$ = func_iil(SFCODE(12,18), $2, $3, $4); }
    ;

/* Map Error Send */
s12f19_decl
    : LBRACE maper datlc RBRACE         { $$ = func_item2(SFCODE(12,19), $2, $3); }
    ;

/* Abort Transaction */
s13f0_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(13,0)); }
    ;

/* Send Data Set Send */
s13f1_decl
    : LBRACE dsname RBRACE
        { $$ = func_item1(SFCODE(13,1), make_item_list(NULL, $2)); }
    ;

/* Send Data Set Acknowledge */
s13f2_decl
    : LBRACE dsname ackc13 RBRACE       { $$ = func_item2(SFCODE(13,2), $2, $3); }
    ;

/* Open Data Set Request */
s13f3_decl
    : LBRACE handle dsname ckpnt RBRACE
        { $$ = func_item3(SFCODE(13,3), $2, $3, $4); }
    ;

/* Open Data Set Data */
s13f4_decl
    : LBRACE handle dsname ackc13 rtype reclen RBRACE
        { $$ = func_item5(SFCODE(13,4), $2, $3, $4, $5, $6); }
    ;

/* Read Data Set Request */
s13f5_decl
    : LBRACE handle readln RBRACE       { $$ = func_item2(SFCODE(13,5), $2, $3); }
    ;

/* Read Data Set Data */
s13f6_decl
    : LBRACE handle ackc13 ckpnt fildat_list_decl RBRACE
        { $$ = func_iiil(SFCODE(13,6), $2, $3, $4, $5); }
    ;

fildat_list_decl
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE fildat_list RBRACE         { $$ = $2; }
    ;

fildat_list
    : fildat                            { $$ = make_item_list(NULL, $1); }
    | fildat_list fildat                { $$ = make_item_list($1, $2); }
    ;

/* Close Data Set Send */
s13f7_decl
    : LBRACE handle RBRACE              { $$ = func_item1(SFCODE(13,7), make_item_list(NULL, $2)); }
    ;

/* Close Data Set Acknowledge */
s13f8_decl
    : LBRACE handle ackc13 RBRACE       { $$ = func_item2(SFCODE(13,8), $2, $3); }
    ;

/* Reset Data Set Send */
s13f9_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(13,9)); }
    ;

/* Reset Data Set Acknowledge */
s13f10_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(13,10)); }
    ;

/* Data Set Object Multi-Block Inquire */
s13f11_decl
    : LBRACE dataid objspec datalength RBRACE
        { $$ = func_item3(SFCODE(13,11), $2, $3, $4); }
    ;

/* Data Set Object Multi-Block Grant */
s13f12_decl
    : grant                             { $$ = func_item1(SFCODE(13,12), $1); }
    ;

/* Table Data Send */
s13f13_decl
    : LBRACE dataid objspec tbltyp tblid tblcmd property_list colhdr_list table_element_list RBRACE
        { $$ = func_s13f13($2, $3, $4, $5, $6, $7, $8, $9); }
    | LBRACE dataid objspec tbltyp tblid tblcmd property_list colhdr_list RBRACE
        { $$ = func_s13f13($2, $3, $4, $5, $6, $7, $8, NULL); }
    ;

colhdr_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE colhdr_s RBRACE            { $$ = $2; }
    ;

colhdr_s
    : colhdr                            { $$ = make_item_list(NULL, $1); }
    | colhdr_s colhdr                   { $$ = make_item_list($1, $2);   }
    ;

table_element_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE table_elements RBRACE      { $$ = $2; }
    ;

table_elements
    : tblelt_list                       { $$ = make_item_list(NULL, $1); }
    | table_elements tblelt_list        { $$ = make_item_list($1, $2);   }
    ;

tblelt_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE tblelt_s RBRACE            { $$ = $2; }
    ;

tblelt_s
    : tblelt                            { $$ = make_item_list(NULL, $1); }
    | tblelt_s tblelt                   { $$ = make_item_list($1, $2);   }
    ;

/* Table Data Acknowledge */
s13f14_decl
    : LBRACE tblack error_list RBRACE   { $$ = func_il(SFCODE(13,14), $2, $3); }
    | LBRACE tblack RBRACE              { $$ = func_il(SFCODE(13,14), $2, NULL); }
    ;

/* Table Data Request */
s13f15_decl
    : LBRACE dataid objspec tbltyp tblid tblcmd colhdr_list tblelt_list RBRACE
        { $$ = func_s13f15($2, $3, $4, $5, $6, $7, $8); }
    | LBRACE dataid objspec tbltyp tblid tblcmd colhdr_list RBRACE
        { $$ = func_s13f15($2, $3, $4, $5, $6, $7, NULL); }
    | LBRACE dataid objspec tbltyp tblid tblcmd RBRACE
        { $$ = func_s13f15($2, $3, $4, $5, $6, NULL, NULL); }
    ;

/* Table Data */
s13f16_decl
    : LBRACE tbltyp tblid property_list colhdr_list table_element_list tblack_list RBRACE
        { $$ = func_s13f16($2, $3, $4, $5, $6, $7); }
    ;

tblack_list
    : LBRACE tblack error_list RBRACE   { $$ = mklist_item_itemlist($2, $3); }
    | LBRACE tblack RBRACE              { $$ = mklist_item_itemlist($2, NULL); }
    ;

/* Transaction */
s14f0_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(14,0)); }
    ;

/* GetAttr Request */
s14f1_decl
    : LBRACE objspec objtype objid_list member_attr_list attrid_list RBRACE
        { $$ = func_s14f1($2, $3, $4, $5, $6); }
    ;

member_attr_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE attrinfo_list RBRACE       { $$ = $2; }
    ;

attrinfo_list
    : attrdatum                         { $$ = make_item_list(NULL, $1); }
    | attrinfo_list attrdatum           { $$ = make_item_list($1, $2); }
    ;

attrdatum
    : LBRACE attrid attrdata attrreln RBRACE
        { $$ = mklist_3items($2, $3, $4); }
    ;


/* GetAttr Data */
s14f2_decl
    : LBRACE LBRACE attributes RBRACE objerror_decl RBRACE
        { $$ = func_li(SFCODE(14,2), $3, $5); }
    ;

attributes
    : attribute                         { $$ = make_item_list(NULL, $1); }
    | attributes attribute              { $$ = make_item_list($1, $2); }
    ;

attribute
    : LBRACE objid property_list RBRACE
        { $$ = mklist_2items($2, $3); }
    ;

property_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE properties RBRACE          { $$ = $2; }
    ;

properties
    : property                          { $$ = make_item_list(NULL, $1); }
    | properties property               { $$ = make_item_list($1, $2); }
    ;

property
    : LBRACE attrid attrdata RBRACE     { $$ = mklist_2items($2, $3); }
    ;

objerror_decl
    : LBRACE objack error_list RBRACE
        { $$ = mklist_item_itemlist($2, $3); }
    ;

/* SetAttr Request */
s14f3_decl
    : LBRACE objspec objtype objid_list property_list RBRACE
        { $$ = func_s14f3($2, $3, $4, $5); }
    ;


/* SetAttr Data */
s14f4_decl
    : LBRACE LBRACE attributes RBRACE objerror_decl RBRACE
        { $$ = func_item2(SFCODE(14,4), $3, $5); }
    ;

/* GetType Request */
s14f5_decl
    : objspec                           { $$ = func_s14f5($1); }
    ;

/* GetType Data */
s14f6_decl
    : LBRACE objtype_list objerror_decl RBRACE
        { $$ = func_item2(SFCODE(14,6), $2, $3); }
    ;

objtype_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE objtypes RBRACE            { $$ = $2; }
    ;

objtypes
    : objtype                           { $$ = make_item_list(NULL, $1); }
    | objtypes objtype                  { $$ = make_item_list($1, $2); }
    ;

/* GetAttrName Request */
s14f7_decl
    : LBRACE objspec objtype_list RBRACE
        { $$ = func_il(SFCODE(14,7), $2, $3); }
    ;

/* GetAttrName Data */
s14f8_decl
    : LBRACE LBRACE objattrid_list RBRACE  objerror_decl RBRACE
        { $$ = func_li(SFCODE(14,8), $3, $5); }
    ;

objattrid_list
    : objattrid_decl                    { $$ = make_item_list(NULL, $1); }
    | objattrid_list objattrid_decl     { $$ = make_item_list($1, $2); }
    ;

objattrid_decl
    : LBRACE objtype attrid_list RBRACE { $$ = mklist_item_itemlist($2, $3); }

/* Create Object Request */
s14f9_decl
    : LBRACE objspec objtype property_list RBRACE
        { $$ = func_iil(SFCODE(14,9), $2, $3, $4); }
    | LBRACE objspec objtype RBRACE
        { $$ = func_iil(SFCODE(14,9), $2, $3, NULL); }
    ;

/* Create Object Acknowledge */
s14f10_decl
    : LBRACE objspec property_list objerror_decl RBRACE
        { $$ = func_ill(SFCODE(14,10), $2, $3, $4); }
    ;

/* Delete Object Request */
s14f11_decl
    : LBRACE objspec property_list RBRACE
        { $$ = func_il(SFCODE(14,11), $2, $3); }
    | LBRACE objspec RBRACE
        { $$ = func_il(SFCODE(14,11), $2, NULL); }
    ;

/* Delete Object Request Acknowledge */
s14f12_decl
    : LBRACE property_list objerror_decl RBRACE
        { $$ = func_li(SFCODE(14,12), $2, $3); }
    ;

/* Object Attach Request */
s14f13_decl
    : LBRACE objspec property_list RBRACE
        { $$ = func_il(SFCODE(14,13), $2, $3); }
    ;

/* Object Attach Acknowledge */
s14f14_decl
    : LBRACE objtoken property_list objerror_decl RBRACE
        { $$ = func_ill(SFCODE(14,14), $2, $3, $4); }
    ;

/* Attached Object Action Request */
s14f15_decl
    : LBRACE objspec objcmd objtoken property_list RBRACE
        { $$ = func_iiil(SFCODE(14,15), $2, $3, $4, $5); }
    | LBRACE objspec objcmd objtoken RBRACE
        { $$ = func_iiil(SFCODE(14,15), $2, $3, $4, NULL); }
    ;

/* Attached Object Action Acknowledge */
s14f16_decl
    : LBRACE property_list objerror_decl RBRACE
        { $$ = func_li(SFCODE(14,16), $2, $3); }
    ;

/* Supervised Object Action Request */
s14f17_decl
    : LBRACE objspec objcmd targetspec property_list RBRACE
        { $$ = func_iiil(SFCODE(14,17), $2, $3, $4, $5); }
    | LBRACE objspec objcmd targetspec RBRACE
        { $$ = func_iiil(SFCODE(14,17), $2, $3, $4, NULL); }
    ;

/* Supervised Object Action Acknowledge */
s14f18_decl
    : LBRACE property_list objerror_decl RBRACE
        { $$ = func_li(SFCODE(14,18), $2, $3); }
    ;

/* Generic Service Request */
s14f19_decl
    : LBRACE dataid opid objspec svcname sp_list RBRACE
        { $$ = func_iiiil(SFCODE(14,19), $2, $3, $4, $5, $6); }
    ;

sp_list
    : sparm                             { $$ = make_item_list(NULL, $1); }
    | sp_list sparm                     { $$ = make_item_list($1, $2); }
    ;

sparm
    : LBRACE spname spval RBRACE        { $$ = mklist_2items($2, $3); }
    ;

/* Generic Service Acknowledge */
s14f20_decl
    : LBRACE svcack linkid sp_list RBRACE
        { $$ = func_iil(SFCODE(14,20), $2, $3, $4); }
    ;

/* Generic Service Completion Onformation */
s14f21_decl
    : LBRACE dataid opid linkid sp_list RBRACE
        { $$ = func_iiil(SFCODE(14,21), $2, $3, $4, $5); }
    ;

/* Recipe Management Multi-block Grant */
s14f22_decl
    : dataack
        { $$ = func_item1(SFCODE(14,22), $1); }
    ;

/* Multi-block Process Job Data Inquire */
s14f23_decl
    : LBRACE dataid datalength RBRACE
        { $$ = func_item2(SFCODE(14,23), $2, $3); }
    ;

/* Multi-block Process Job Data Grant */
s14f24_decl
    : grant                             { $$ = func_item1(SFCODE(14,24), $1); }
    ;

/* Get Service Name Request */
s14f25_decl
    : LBRACE objspec objtype_list RBRACE
        { $$ = func_il(SFCODE(14,25), $2, $3); }
    ;

/* Get Service Name Data */
s14f26_decl
    : LBRACE objsvc_list objerror_decl RBRACE
        { $$ = func_ll(SFCODE(14,26), $2, $3); }
    ;

objsvc_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE objsvcs RBRACE             { $$ = $2; }
    ;

objsvcs
    : objsvc                            { $$ = make_item_list(NULL, $1); }
    | objsvcs objsvc                    { $$ = make_item_list($1, $2); }
    ;

objsvc
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE objtype svcname_list RBRACE { $$ = $2; }
    ;

svcname_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE svcnames RBRACE            { $$ = $2; }
    ;

svcnames
    : svcname                           { $$ = make_item_list(NULL, $1); }
    | svcnames svcname                  { $$ = make_item_list($1, $2); }
    ;

/* Get Service Parameter Name Request */
s14f27_decl
    : LBRACE objspec objtype svcname_list RBRACE
        { $$ = func_iil(SFCODE(14,27), $2, $3, $4); }
    ;

/* Get Service Name Data */
s14f28_decl
    : LBRACE svcparm_list objerror_decl RBRACE
        { $$ = func_ll(SFCODE(14,28), $2, $3); }
    ;

svcparm_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE svcparms RBRACE            { $$ = $2; }
    ;

svcparms
    : svcparm                           { $$ = make_item_list(NULL, $1); }
    | svcparms svcparm                  { $$ = make_item_list($1, $2); }
    ;

svcparm
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE svcname spname_list RBRACE { $$ = mklist_2items($2, $3); }
    ;

spname_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE spnames RBRACE             { $$ = $2; }
    ;

spnames
    : spname                            { $$ = make_item_list(NULL, $1); }
    | spnames spname                    { $$ = make_item_list($1, $2); }
    ;


/* Abort Transaction */
s15f0_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(15,0)); }
    ;

/* Recipe Management Multi-block Inquire */
s15f1_decl
    : LBRACE dataid rcpspec rmdatasize RBRACE
        { $$ = func_item3(SFCODE(15,1), $2, $3, $4); }
    ;

/* Recipe Management Multi-block Grant */
s15f2_decl
    : rmgrnt                            { $$ = func_item1(SFCODE(15,2), $1); }
    ;

/* Recipe Namespace Action Request */
s15f3_decl
    : LBRACE rmnsspec rmnscmd RBRACE
        { $$ = func_item2(SFCODE(15,3), $2, $3); }
    ;

/* Recipe Namespace Action Acknowledge */
s15f4_decl
    : LBRACE rmack error_list RBRACE
        { $$ = func_il(SFCODE(15,4), $2, $3); }
    | LBRACE rmack RBRACE
        { $$ = func_il(SFCODE(15,4), $2, NULL); }
    ;

/* Recipe Namespace Rename Request */
s15f5_decl
    : LBRACE rmnsspec rmnewns RBRACE
        { $$ = func_item2(SFCODE(15,5), $2, $3); }
    ;

/* Recipe Namespace Rename Acknowledge */
s15f6_decl
    : LBRACE rmack error_list RBRACE
        { $$ = func_il(SFCODE(15,6), $2, $3); }
    | LBRACE rmack RBRACE
        { $$ = func_il(SFCODE(15,6), $2, NULL); }
    ;

/* Recipe Space Request */
s15f7_decl
    : objspec                           { $$ = func_item1(SFCODE(15,7), $1); }
    ;

/* Recipe Space Data */
s15f8_decl
    : LBRACE rmspace rmack_list RBRACE
        { $$ = func_item2(SFCODE(15,8), $2, $3); }
    ;

/* Recipe Status Request */
s15f9_decl
    : rcpspec                           { $$ = func_item1(SFCODE(15,9), $1); }
    ;

/* Recipe Status Data */
s15f10_decl
    : LBRACE rcpstat rcpvers rmack_list RBRACE
        { $$ = func_item3(SFCODE(15,10), $2, $3, $4); }
    ;

/* Recipe Version Request */
s15f11_decl
    : LBRACE rmnsspec rcpclass rcpname agent RBRACE
        { $$ = func_item4(SFCODE(15,11), $2, $3, $4, $5); }
    ;

/* Recipe Version Data */
s15f12_decl
    : LBRACE agent rcpvers rmack_list RBRACE
        { $$ = func_item3(SFCODE(15,12), $2, $3, $4); }
    ;

/* Recipe Create Request */
s15f13_decl
    : LBRACE dataid rcpupdt rcpspec rcpattr_list rcpbody RBRACE
        { $$ = func_s15f13($2, $3, $4, $5, $6); }
    | LBRACE dataid rcpupdt rcpspec rcpattr_list RBRACE
        { $$ = func_s15f13($2, $3, $4, $5, NULL); }
    ;

/* Recipe Create Acknowledge */
s15f14_decl
    : LBRACE rmack error_list RBRACE
        { $$ = func_il(SFCODE(15,14), $2, $3); }
    | LBRACE rmack RBRACE
        { $$ = func_il(SFCODE(15,14), $2, NULL); }
    ;

/* Recipe Store Request */
s15f15_decl
    : LBRACE dataid rcpspec rcpseccode recipe_info RBRACE
        { $$ = func_item4(SFCODE(15,15), $2, $3, $4, $5); }
    ;

recipe_info
    : LBRACE recipe_section rcpbody recipe_section_list RBRACE
        { $$ = make_recipe_info($2, $3, $4); }
    | LBRACE recipe_section rcpbody RBRACE
        { $$ = make_recipe_info($2, $3, NULL); }
    | LBRACE recipe_section RBRACE
        { $$ = make_recipe_info($2, NULL, NULL); }
    ;

recipe_section_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE recipe_section_s RBRACE    { $$ = $2; }
    ;

recipe_section_s
    : recipe_section                    { $$ = make_item_list(NULL, $1); }
    | recipe_section_s recipe_section   { $$ = make_item_list($1, $2);   }
    ;

recipe_section
    : LBRACE rcpsecnm rcpattr_list RBRACE
        { $$ = make_recipe_section($2, $3); }
    | LBRACE rcpsecnm RBRACE
        { $$ = make_recipe_section($2, NULL); }
    ;

/* Recipe Store Acknowledge */
s15f16_decl
    : LBRACE rcpseccode rmack_list RBRACE
        { $$ = func_item2(SFCODE(15,16), $2, $3); }
    ;

/* Recipe Retrieve Request */
s15f17_decl
    : LBRACE rcpspec rcpseccode RBRACE  { $$ = func_item2(SFCODE(15,17), $2, $3); }
    ;

/* Recipe Retrieve Data */
s15f18_decl
    : LBRACE recipe_info rmack_list RBRACE
        { $$ = func_item2(SFCODE(15,18), $2, $3); }
    ;

/* Recipe Rename Request */
s15f19_decl
    : LBRACE rcpspec rcprename rcpnewid RBRACE
        { $$ = func_item3(SFCODE(15,19), $2, $3, $4); }
    ;

/* Recipe Rename Acknowledge */
s15f20_decl
    : LBRACE rmack error_list RBRACE    { $$ = func_il(SFCODE(15,20), $2, $3); }
    | LBRACE rmack RBRACE               { $$ = func_il(SFCODE(15,20), $2, NULL); }
    ;

/* Recipe Action Request */
s15f21_decl
    : LBRACE dataid rcpcmd rmnsspec opid agent rcpid_list RBRACE
        { $$ = func_s15f21($2, $3, $4, $5, $6, $7); }
    ;

rcpid_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE rcpid_s RBRACE             { $$ = $2; }
    ;

rcpid_s
    : rcpid                             { $$ = make_item_list(NULL, $1); }
    | rcpid_s rcpid                     { $$ = make_item_list($1, $2);   }
    ;

/* Recipe Action Acknowledge */
s15f22_decl
    : LBRACE agent linkid rcpcmd rmack_list RBRACE
        { $$ = func_item4(SFCODE(15,22), $2, $3, $4, $5); }
    ;

/* Recipe Descriptor Request */
s15f23_decl
    : LBRACE dataid objspec rcpid_list RBRACE
        { $$ = func_iil(SFCODE(15,23), $2, $3, $4); }
    ;

/* Recipe Descriptor Data */
s15f24_decl
    : LBRACE recipe_descript_list rmack_list RBRACE
        { $$ = func_item2(SFCODE(15,24), $2, $3); }
    ;

recipe_descript_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE recipe_descript_s RBRACE   { $$ = $2; }
    ;

recipe_descript_s
    : rcpdesc_list                      { $$ = make_item_list(NULL, $1); }
    | recipe_descript_s rcpdesc_list    { $$ = make_item_list($1, $2);   }
    ;

rcpdesc_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE rcpdesc_s RBRACE           { $$ = $2; }
    ;

rcpdesc_s
    : rcpdesc                           { $$ = make_item_list(NULL, $1); }
    | rcpdesc_s rcpdesc                 { $$ = make_item_list($1, $2);   }
    ;

rcpdesc
    : LBRACE rcpdescnm rcpdesctime rcpdesclth RBRACE
        { $$ = make_recipe_descriptor($2, $3, $4); }
    | LBRACE RBRACE
        { $$ = make_recipe_descriptor(NULL, NULL, NULL); }
    ;

/* Recipe Parameter Update Request */
s15f25_decl
    : LBRACE dataid rmnsspec agent rcpparm_list RBRACE
        { $$ = func_iiil(SFCODE(15,25), $2, $3, $4, $5); }
    ;

rcpparm_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE rcpparm_s RBRACE           { $$ = $2; }
    ;

rcpparm_s
    : rcpparm                           { $$ = make_item_list(NULL, $1); }
    | rcpparm_s rcpparm                 { $$ = make_item_list($1, $2);   }
    ;

rcpparm
    : LBRACE rcpparnm rcpparval rcpparrule RBRACE
        { $$ = mklist_3items($2, $3, $4); }
    ;

/* Recipe Parameter Update Acknowledge */
s15f26_decl
    : LBRACE rmack error_list RBRACE    { $$ = func_il(SFCODE(15,26), $2, $3); }
    | LBRACE rmack RBRACE               { $$ = func_il(SFCODE(15,26), $2, NULL); }
    ;

/* Recipe Download Request */
s15f27_decl
    : LBRACE dataid rcpowcode rcpspec rcpattr_list rcpbody RBRACE
        { $$ = func_s15f27($2, $3, $4, $5, $6); }
    ;

/* Recipe Download Acknowledge */
s15f28_decl
    : LBRACE rcpid rcpattr_list rmack_list RBRACE
        { $$ = func_item3(SFCODE(15,28), $2, $3, $4); }
    ;

/* Recipe Verify Request */
s15f29_decl
    : LBRACE dataid opid rcpspec rcpid_list RBRACE
        { $$ = func_iiil(SFCODE(15,29), $2, $3, $4, $5); }
    ;

/* Recipe Verify Acknowledge */
s15f30_decl
    : LBRACE opid linkid rcpid rcpattr_list rmack_list RBRACE
        { $$ = func_item5(SFCODE(15,30), $2, $3, $4, $5, $6); }
    ;

/* Recipe Upload Request */
s15f31_decl
    : rcpspec                           { $$ = func_item1(SFCODE(15,31), $1); }
    ;

/* Recipe Upload Data */
s15f32_decl
    : LBRACE rcpspec rcpattr_list rcpbody rmack_list RBRACE
        { $$ = func_item4(SFCODE(15,32), $2, $3, $4, $5); }
    ;

/* Recipe Select Request */
s15f33_decl
    : LBRACE dataid respec rcp_parmdata_list RBRACE
        { $$ = func_iil(SFCODE(15,33), $2, $3, $4); }
    ;

rcp_parmdata_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE rcp_parmdata_s RBRACE      { $$ = $2; }
    ;

rcp_parmdata_s
    : rcp_parmdata                      { $$ = make_item_list(NULL, $1); }
    | rcp_parmdata_s rcp_parmdata       { $$ = make_item_list($1, $2);   }
    ;

rcp_parmdata
    : LBRACE rcpid rcp_parmval_list RBRACE
        { $$ = mklist_2items($2, $3); }
    ;

rcp_parmval_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE rcp_parmval_s RBRACE       { $$ = $2; }
    ;

rcp_parmval_s
    : rcp_parmval                       { $$ = make_item_list(NULL, $1); }
    | rcp_parmval_s rcp_parmval         { $$ = make_item_list($1, $2);   }
    ;

rcp_parmval
    : LBRACE rcpparnm rcpparval RBRACE  { $$ = mklist_2items($2, $3); }
    ;

/* Recipe Select Acknowledge */
s15f34_decl
    : LBRACE rmack error_list RBRACE    { $$ = func_il(SFCODE(15,34), $2, $3); }
    | LBRACE rmack RBRACE               { $$ = func_il(SFCODE(15,34), $2, NULL); }
    ;

/* Recipe Delete Request */
s15f35_decl
    : LBRACE dataid respec rcpdel rcpid_list RBRACE
        { $$ = func_iiil(SFCODE(15,35), $2, $3, $4, $5); }
    ;

/* Recipe Delete Acknowledge */
s15f36_decl
    : LBRACE rmack error_list RBRACE    { $$ = func_il(SFCODE(15,36), $2, $3); }
    | LBRACE rmack RBRACE               { $$ = func_il(SFCODE(15,36), $2, NULL); }
    ;

/* DRNS Segment Approve Action Request */
s15f37_decl
    : LBRACE rmsegspec objtoken rmgrnt opid rcpid rmchgtype RBRACE
        { $$ = func_s15f37($2, $3, $4, $5, $6, $7); }
    ;

/* DRNS Segment Approve Action Acknowledge */
s15f38_decl
    : LBRACE rmack error_list RBRACE    { $$ = func_il(SFCODE(15,38), $2, $3); }
    | LBRACE rmack RBRACE               { $$ = func_il(SFCODE(15,38), $2, NULL); }
    ;

/* DRNS Recorder Segment Request */
s15f39_decl
    : LBRACE dataid rmnscmd rmrecspec rmsegspec objtoken RBRACE
        { $$ = func_item5(SFCODE(15,39), $2, $3, $4, $5, $6); }
    ;

/* DRNS Recorder Segment Acknowledge */
s15f40_decl
    : LBRACE rmack error_list RBRACE    { $$ = func_il(SFCODE(15,40), $2, $3); }
    | LBRACE rmack RBRACE               { $$ = func_il(SFCODE(15,40), $2, NULL); }
    ;

/* DRNS Recorder Modify Request */
s15f41_decl
    : LBRACE dataid rmrecspec objtoken rmnscmd modify_record_info RBRACE
        { $$ = func_item5(SFCODE(15,41), $2, $3, $4, $5, $6); }
    ;

modify_record_info
    : LBRACE rcpid rcpnewid rmsegspec rmchgtype opid timestamp rmrequestor RBRACE
        { $$ = make_rec_info($2, $3, $4, $5, $6, $7, $8); }
    ;

/* DRNS Recorder Modify Acknowledge */
s15f42_decl
    : LBRACE rmack error_list RBRACE    { $$ = func_il(SFCODE(15,42), $2, $3); }
    | LBRACE rmack RBRACE               { $$ = func_il(SFCODE(15,42), $2, NULL); }
    ;

/* DRNS Get Change Request */
s15f43_decl
    : LBRACE dataid objspec targetspec RBRACE
        { $$ = func_item3(SFCODE(15,43), $2, $3, $4); }
    ;

/* DRNS Get Change Request Data */
s15f44_decl
    : LBRACE modify_record_list rmack_list RBRACE
        { $$ = func_li(SFCODE(15,44), $2, $3); }
    ;

modify_record_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE modify_records RBRACE      { $$ = $2; }
    ;

modify_records
    : modify_record_info                { $$ = make_item_list(NULL, $1); }
    | modify_records modify_record_info { $$ = make_item_list($1, $2);   }
    ;

/* DRNS Manager Segment Change Approval Request */
s15f45_decl
    : LBRACE dataid rcpspec rcpnewid rmchgtype RBRACE
        { $$ = func_item4(SFCODE(15,45), $2, $3, $4, $5); }
    ;

/* DRNS Manager Segment Change Approval Acknowledge */
s15f46_decl
    : LBRACE rmchgtype rmgrnt opid RBRACE
        { $$ = func_item3(SFCODE(15,46), $2, $3, $4); }
    ;

/* DRNS Manager Rebuild Request */
s15f47_decl
    : LBRACE dataid objspec rmnsspec rmrecspec rmsegspec_list RBRACE
        { $$ = func_iiiil(SFCODE(15,47), $2, $3, $4, $5, $6); }
    ;

rmsegspec_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE rmsegspec_s RBRACE         { $$ = $2; }
    ;

rmsegspec_s
    : rmsegspec                         { $$ = make_item_list(NULL, $1); }
    | rmsegspec_s rmsegspec             { $$ = make_item_list($1, $2);   }
    ;

/* DRNS Manager Rebuild Acknowledge */
s15f48_decl
    : LBRACE rmack error_list RBRACE    { $$ = func_il(SFCODE(15,48), $2, $3); }
    | LBRACE rmack RBRACE               { $$ = func_il(SFCODE(15,48), $2, NULL); }
    ;

/* Abort Transaction */
s16f0_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(16,0)); }
    ;

/* Multi-block Process Job Data Inquire */
s16f1_decl
    : LBRACE dataid datalength RBRACE   { $$ = func_item2(SFCODE(16,1), $2, $3); }
    ;

/* Multi-block Process Job Data Grant */
s16f2_decl
    : grant                             { $$ = func_item1(SFCODE(16,2), $1); }
    ;

/* Process Job Create Request */
s16f3_decl
    : LBRACE dataid mf mid_list proc_recipe prprocessstart RBRACE
        { $$ = func_item5(SFCODE(16,3), $2, $3, $4, $5, $6); }
    ;

proc_recipe
    : LBRACE prrecipemethod rcpspec rcp_parmval_list RBRACE
        { $$ = mklist_3items($2, $3, $4); }
    ;

/* Process Job Create Acknowledge */
s16f4_decl
    : LBRACE prjobid pracka_list RBRACE { $$ = func_item2(SFCODE(16,4), $2, $3); }
    ;

pracka_list
    : LBRACE acka error_list RBRACE     { $$ = mklist_item_itemlist($2, $3); }
    | LBRACE acka RBRACE                { $$ = mklist_item_itemlist($2, NULL); }
    ;

/* Process Job Command Request */
s16f5_decl
    : LBRACE dataid prjobid prcmdname parameter_list RBRACE
        { $$ = func_iiil(SFCODE(16,5), $2, $3, $4, $5); }
    ;

/* Process Job Command Acknowledge */
s16f6_decl
    : LBRACE prjobid pracka_list RBRACE { $$ = func_item2(SFCODE(16,6), $2, $3); }
    ;

/* Process Job Alert Notify */
s16f7_decl
    : LBRACE timestamp prjobid prjobmilestone pracka_list RBRACE
        { $$ = func_item4(SFCODE(16,7), $2, $3, $4, $5); }
    ;

/* Process Job Alert Confirm */
s16f8_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(16,8)); }
    ;

/* Process Job Event Notify */
s16f9_decl
    : LBRACE preventid timestamp prjobid annotated_data_list RBRACE
        { $$ = func_item4(SFCODE(16,9), $2, $3, $4, $5); }
    ;

/* Process Job Event Confirm */
s16f10_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(16,10)); }
    ;

/* PrJobCreateEhn */
s16f11_decl
    : LBRACE dataid prjobid carrier_mf carslot_list proc_recipe prprocessstart prpauseevent RBRACE
        { $$ = func_s16f11($2, $3, $4, $5, $6, $7, $8); }
    | LBRACE dataid prjobid mf mid_list proc_recipe prprocessstart prpauseevent RBRACE
        { $$ = func_s16f11($2, $3, $4, $5, $6, $7, $8); }
    ;

carrier_mf
    : CARRIERS                          { $$ = make_item("mf", "carriers"); }
    ;

carslot_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE car_slots RBRACE           { $$ = $2; }
    ;

car_slots
    : car_slot                          { $$ = make_item_list(NULL, $1); }
    | car_slots car_slot                { $$ = make_item_list($1, $2);   }
    ;

car_slot
    : LBRACE carrierid slotid_list RBRACE
        { $$ = mklist_2items($2, $3); }
    ;

slotid_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE slotids RBRACE             { $$ = $2; }
    ;

slotids
    : slotid                            { $$ = make_item_list(NULL, $1); }
    | slotids slotid                    { $$ = make_item_list($1, $2);   }
    ;

/* PRJobCreateEnh Acknowledge */
s16f12_decl
    : LBRACE prjobid pracka_list RBRACE { $$ = func_il(SFCODE(16,12), $2, $3); }
    ;

/* PRJobDuplicateCreate */
s16f13_decl
    : LBRACE dataid prjob_list proc_recipe prprocessstart prpauseevent RBRACE
        { $$ = func_s16f13($2, $3, $4, $5, $6); }
    ;

prjob_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE prjobs RBRACE              { $$ = $2; }
    ;

prjobs
    : prjob                             { $$ = make_item_list(NULL, $1); }
    | prjobs prjob                      { $$ = make_item_list($1, $2);   }
    ;

prjob
    : LBRACE prjobid carrier_mf carslot_list RBRACE
        { $$ = mklist_3items($2, $3, $4); }
    | LBRACE prjobid mf mid_list RBRACE
        { $$ = mklist_3items($2, $3, $4); }
    ;

/* PRJobDuplicateCreate Acknowledge */
s16f14_decl
    : LBRACE prjobid_list pracka_list RBRACE
        { $$ = func_ll(SFCODE(16,14), $2, $3); }
    ;

prjobid_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE prjobids RBRACE            { $$ = $2; }
    ;

prjobids
    : prjobid                           { $$ = make_item_list(NULL, $1); }
    | prjobids prjobid                  { $$ = make_item_list($1, $2);   }
    ;

/* PRJobMultiCreate */
s16f15_decl
    : LBRACE dataid create_prjob_list RBRACE
        { $$ = func_il(SFCODE(16,15), $2, $3); }
    ;

create_prjob_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE create_prjobs RBRACE       { $$ = $2; }
    ;

create_prjobs
    : create_prjob                      { $$ = make_item_list(NULL, $1); }
    | create_prjobs create_prjob        { $$ = make_item_list($1, $2);   }
    ;

create_prjob
    : LBRACE prjobid carrier_mf carslot_list proc_recipe prprocessstart prpauseevent RBRACE
        { $$ = make_prjob($2, $3, $4, $5, $6, $7); }
    | LBRACE prjobid mf mid_list proc_recipe prprocessstart prpauseevent RBRACE
        { $$ = make_prjob($2, $3, $4, $5, $6, $7); }
    ;

/* PRJobMultiCreate Acknowledge */
s16f16_decl
    : LBRACE prjobid_list pracka_list RBRACE
        { $$ = func_ll(SFCODE(16,16), $2, $3); }
    ;

/* PRJobDequeue */
s16f17_decl
    : prjobid_list                      { $$ = func_item1(SFCODE(16,17), $1); }
    ;

/* PRJobDequeue Acknowledge */
s16f18_decl
    : LBRACE prjobid_list pracka_list RBRACE
        { $$ = func_ll(SFCODE(16,18), $2, $3); }
    ;

/* PRGetAllJobs */
s16f19_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(16,19)); }
    ;

/* PRGetAllJobs Send */
s16f20_decl
    :  prjobstate_list                  { $$ = func_listitem(SFCODE(16,20), $1); }
    ;

prjobstate_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE prjobstates RBRACE         { $$ = $2; }
    ;

prjobstates
    : prjobstate                        { $$ = make_item_list(NULL, $1); }
    | prjobstates prjobstate            { $$ = make_item_list($1, $2);   }
    ;

prjobstate
    : LBRACE prjobid prstate RBRACE
        { $$ = mklist_2items($2, $3); }
    ;

/* PRGetSpace */
s16f21_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(16,21)); }
    ;

/* PRGetSpace Send */
s16f22_decl
    : prjobspace                        { $$ = func_item1(SFCODE(16,22), $1); }
    ;

/* PRJobSetRecipeVariable */
s16f23_decl
    : LBRACE prjobid rcp_parmval_list RBRACE
        { $$ = func_il(SFCODE(16,23), $2, $3); }
    ;

/* PRJobSetRecipeVariable Acknowledge */
s16f24_decl
    : pracka_list                       { $$ = func_listitem(SFCODE(16,24), $1); }
    ;

/* PRJobSetStartMethod */
s16f25_decl
    : LBRACE prjobid_list prprocessstart RBRACE
        { $$ = func_li(SFCODE(16,25), $2, $3); }
    ;

/* PRJobSetStartMethod Acknowledge */
s16f26_decl
    : LBRACE prjobid_list pracka_list RBRACE
        { $$ = func_ll(SFCODE(16,26), $2, $3); }
    ;

/* Control Job Command Request */
s16f27_decl
    : LBRACE ctljobid ctljobcmd parameter RBRACE
        { $$ = func_iil(SFCODE(16,27), $2, $3, $4); }
    ;

/* Control Job Command Acknowledge */
s16f28_decl
    : pracka_list                       { $$ = func_listitem(SFCODE(16,28), $1); }
    ;

/* PRSetMtrlOrder */
s16f29_decl
    : prmtrlorder                       { $$ = func_item1(SFCODE(16,29), $1); }
    ;

/* Control Job Command Acknowledge */
s16f30_decl
    : acka                              { $$ = func_item1(SFCODE(16,30), $1); }
    ;

/* Abort Transaction */
s17f0_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(17,0)); }
    ;

/* Data Report Create Request */
s17f1_decl
    : LBRACE dataid rptid datasrc vid_list RBRACE
        { $$ = func_iiil(SFCODE(17,1), $2, $3, $4, $5); }
    ;

/* Data Report Create Acknowledge */
s17f2_decl
    : LBRACE rptid errcode RBRACE       { $$ = func_item2(SFCODE(17,2), $2, $3); }
    ;

/* Data Report Delete Request */
s17f3_decl
    : rptid_list                        { $$ = func_listitem(SFCODE(17,3), $1); }
    ;

/* Data Report Delete Acknowledge */
s17f4_decl
    : LBRACE acka rpt_error_list RBRACE
        { $$ = func_il(SFCODE(17,4), $2, $3); }
    ;

rpt_error_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE rpt_error_s RBRACE         { $$ = $2; }
    ;

rpt_error_s
    : rpt_error                         { $$ = make_item_list(NULL, $1); }
    | rpt_error_s rpt_error             { $$ = make_item_list($1, $2);   }
    ;

rpt_error
    : LBRACE rptid errcode errtext RBRACE
        { $$ = mklist_3items($2, $3, $4); }
    ;

/* Trace Create Request */
s17f5_decl
    : LBRACE dataid trid ceed rptid_list trsper trace_decl RBRACE
        { $$ = func_s17f5($2, $3, $4, $5, $6, $7); }
    | LBRACE dataid trid ceed rptid_list trsper LBRACE RBRACE RBRACE
        { $$ = func_s17f5($2, $3, $4, $5, $6, NULL); }
    | LBRACE dataid trid ceed rptid_list trsper RBRACE
        { $$ = func_s17f5($2, $3, $4, $5, $6, NULL); }
    ;

trace_decl
    : LBRACE totsmp repgsz evntsrc ceid evntsrc ceid trautod rptoc RBRACE
        { $$ = make_trace_decl($2, $3, $4, $5, $6, $7, $8, $9); }
    ;

/* Trace Create Acknowledge */
s17f6_decl
    : LBRACE trid errcode RBRACE        { $$ = func_item2(SFCODE(17,6), $2, $3); }
    ;

/* Trace Delete Request */
s17f7_decl
    : trid_list                         { $$ = func_listitem(SFCODE(17,7), $1); }
    ;

trid_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE trid_s RBRACE              { $$ = $2; }
    ;

trid_s
    : trid                              { $$ = make_item_list(NULL, $1); }
    | trid_s trid                       { $$ = make_item_list($1, $2);   }
    ;

/* Trace Delete Acknowledge */
s17f8_decl
    : LBRACE acka trace_error_list RBRACE
        { $$ = func_il(SFCODE(17,8), $2, $3); }
    ;

trace_error_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE trace_error_s RBRACE       { $$ = $2; }
    ;

trace_error_s
    : trace_error                       { $$ = make_item_list(NULL, $1); }
    | trace_error_s trace_error         { $$ = make_item_list($1, $2);   }
    ;

trace_error
    : LBRACE trid errcode errtext RBRACE
        { $$ = mklist_3items($2, $3, $4); }
    ;

/* Collection Event Link Request */
s17f9_decl
    : LBRACE dataid evntsrc ceid rptid_list RBRACE
        { $$ = func_iiil(SFCODE(17,9), $2, $3, $4, $5); }
    ;

/* Collection Event Link Acknowledge */
s17f10_decl
    : LBRACE evntsrc ceid errcode RBRACE
        { $$ = func_item3(SFCODE(17,10), $2, $3, $4); }
    ;

/* Collection Event Unlink Request */
s17f11_decl
    : LBRACE evntsrc ceid errcode RBRACE
        { $$ = func_item3(SFCODE(17,11), $2, $3, $4); }
    ;

/* Collection Event Unlink Acknowledge */
s17f12_decl
    : LBRACE evntsrc ceid rptid errcode RBRACE
        { $$ = func_item4(SFCODE(17,12), $2, $3, $4, $5); }
    ;

/* Trace Reset Request */
s17f13_decl
    : trid_list                         { $$ = func_listitem(SFCODE(17,13), $1); }
    ;

/* Trace Reset Acknowledge */
s17f14_decl
    : LBRACE acka trace_error_list RBRACE
        { $$ = func_il(SFCODE(17,14), $2, $3); }
    ;

/* Abort Transaction */
s18f0_decl
    : /* empty */                       { $$ = func_nobody(SFCODE(18,0)); }
    ;

/* Read Attribute Request */
s18f1_decl
    : LBRACE targetid attrid_list RBRACE
        { $$ = func_il(SFCODE(18,1), $2, $3); }
    ;

/* Read Attribute Data */
s18f2_decl
    : LBRACE targetid ssack attrdata_list RBRACE
        { $$ = func_iil(SFCODE(18,2), $2, $3, $4); }
    ;

/* Write Attribute Request */
s18f3_decl
    : LBRACE targetid property_list RBRACE
        { $$ = func_il(SFCODE(18,3), $2, $3); }
    ;

/* Write Attribute Acknowledge */
s18f4_decl
    : LBRACE targetid ssack statuslist RBRACE
        { $$ = func_iil(SFCODE(18,4), $2, $3, $4); }
    ;

/* Read Request */
s18f5_decl
    : LBRACE targetid dataseg datalength RBRACE
        { $$ = func_item3(SFCODE(18,5), $2, $3, $4); }
    ;

/* Read Data */
s18f6_decl
    : LBRACE targetid ssack data RBRACE
        { $$ = func_item3(SFCODE(18,6), $2, $3, $4); }
    ;

/* Write Data Request */
s18f7_decl
    : LBRACE targetid dataseg datalength data RBRACE
        { $$ = func_item4(SFCODE(18,7), $2, $3, $4, $5); }
    ;

/* Write Data Acknowledge */
s18f8_decl
    : LBRACE targetid ssack statuslist RBRACE
        { $$ = func_iil(SFCODE(18,8), $2, $3, $4); }
    ;

/* Read ID Request */
s18f9_decl
    : targetid
        { $$ = func_item1(SFCODE(18,9), $1); }
    ;

/* Read ID Data */
s18f10_decl
    : LBRACE targetid ssack mid statuslist RBRACE
        { $$ = func_iiil(SFCODE(18,10), $2, $3, $4, $5); }
    ;

/* Write ID Request */
s18f11_decl
    : LBRACE targetid mid RBRACE
        { $$ = func_item2(SFCODE(18,11), $2, $3); }
    ;

/* Write ID Acknowledge */
s18f12_decl
    : LBRACE targetid ssack statuslist RBRACE
        { $$ = func_iil(SFCODE(18,12), $2, $3, $4); }
    ;

/* Subsystem Command Request */
s18f13_decl
    : LBRACE targetid sscmd cpval_list RBRACE
        { $$ = func_iil(SFCODE(18,13), $2, $3, $4); }
    ;

cpval_list
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE cpvals RBRACE              { $$ = $2; }
    ;

cpvals
    : cpval                             { $$ = make_item_list(NULL, $1); }
    | cpvals cpval                      { $$ = make_item_list($1, $2); }
    ;

/* Subsystem Command Acknowledge */
s18f14_decl
    : LBRACE targetid ssack statuslist RBRACE
        { $$ = func_iil(SFCODE(18,14), $2, $3, $4); }
    ;

/*---------------------------------------------------------------------------*/
abs            /* Any binary string */
    : binary_ex             { $$ = make_item("ABS", $1); }
    ;

accessmode     /* Load port access mode */
    : uint1_ex_decl         { $$ = make_item("ACCESSMODE", $1); }
    ;

acds           /* After Command Codes */
    : uint2_ex_decl         { $$ = make_item("ACDS", $1); }
    | int2_ex_decl          { $$ = make_item("ACDS", $1); }
    ;

acka           /* Indicates success of a request */
    : bool_decl             { $$ = make_item("ACKA", $1); }
    ;

ackc3          /* Acknowledge Code */
    : ack_decl              { $$ = make_item("ACKC3", $1); }
    ;

ackc5          /* Acknowledge Code */
    : ack_decl              { $$ = make_item("ACKC5", $1); }
    ;

ackc6          /* Acknowledge Code */
    : ack_decl              { $$ = make_item("ACKC6", $1); }
    ;

ackc7          /* Acknowledge Code */
    : ack_decl              { $$ = make_item("ACKC7", $1); }
    ;

ackc7a         /* Acknowledge Code */
    : uint1_ex_decl         { $$ = make_item("ACKC7A", $1); }
    | int1_ex_decl          { $$ = make_item("ACKC7A", $1); }
    ;

ackc10         /* Acknowledge Code */
    : ack_decl              { $$ = make_item("ACKC10", $1); }
    ;

ackc13         /* Return code for secondary messages */
    : ack_decl              { $$ = make_item("ACKC13", $1); }
    ;

agent          /* Agent */
    : str_decl              { $$ = make_item("AGENT", $1); }
    ;

alcd           /* Alarm code byte */
    : binary_ex             { $$ = make_item("ALCD", $1); }
    ;

aled           /* Alarm enable/disable code */
    : bin_decl              { $$ = make_item("ALED", $1); }
    ;

alid           /* Alarm indentification */
    : uintx_decl            { $$ = make_item("ALID", $1); }
    | intx_decl             { $$ = make_item("ALID", $1); }
    | LBRACE RBRACE         { $$ = make_item("ALID", NULL); }
    ;

altx           /* Alarm text */
    : str_ex_decl           { $$ = make_item("ALTX", $1); }
    ;

attrdata       /* Contains a specific attribute value for a specific object */
    : attr                  { $$ = make_item("ATTRDATA", $1); }
    ;

attrid         /* Identifier for an attribute for a specific type of object */
    : uintx_decl            { $$ = make_item("ATTRID", $1); }
    | str_decl              { $$ = make_item("ATTRID", $1); }
    ;

attrreln       /* The relationship that a specified qualifying value has to
                  the value of an attribute of an object instance (the value
                  of interest) */
    : uint1_ex_decl         { $$ = make_item("ATTRRELN", $1); }
    ;

bcds           /* Before Command Codes */
    : uint2_ex_decl         { $$ = make_item("BCDS", $1); }
    | int2_ex_decl          { $$ = make_item("BCDS", $1); }
    ;

bcequ          /* Bin code equivalents */
    : uint1_ex_decl         { $$ = make_item("BCEQU", $1); }
    | str_decl              { $$ = make_item("BCEQU", $1); }
    ;

binlt          /* The Bin List */
    : uint1_ex_decl         { $$ = make_item("BINLT", $1); }
    | str_decl              { $$ = make_item("BINLT", $1); }
    ;

blkdef         /* Block Definition */
    : uint1_ex_decl         { $$ = make_item("BLKDEF", $1); }
    | int1_ex_decl          { $$ = make_item("BLKDEF", $1); }
    ;

bpd            /* Boot program Data */
    : binary_ex             { $$ = make_item("BPD", $1); }
    ;

bytmax         /* Byte Maximum */
    : uintx_decl            { $$ = make_item("BYTMAX", $1); }
    | intx_decl             { $$ = make_item("BYTMAX", $1); }
    ;

caack          /* Carrier Action Acknowledge Code */
    : uint1_ex_decl         { $$ = make_item("CAACK", $1); }
    ;

carrieraction  /* Specifies the action requested for a carrier */
    : str_decl              { $$ = make_item("CARRIERACTION", $1); }
    ;

carrierid     /* The identifier of a carrier */
    : str_decl              { $$ = make_item("CARRIERID", $1); }
    ;

carrierspec   /* The object specifier for a carrier, conforms to OBJSPEC */
    : str_decl              { $$ = make_item("CARRIERSPEC", $1); }
    ;

cattrdata     /* The value of a carrier attribute */
    : attr                  { $$ = make_item("CATTRDATA", $1); }
    ;

cattrid       /* The name of a carrier attribute */
    : str_decl              { $$ = make_item("CATTRID", $1); }
    ;

ccode          /* Command Code */
    : uint2_ex_decl         { $$ = make_item("CCODE", $1); }
    | int2_ex_decl          { $$ = make_item("CCODE", $1); }
    ;

ceed           /* Collection event or trace enable/disable code */
    : bool_decl             { $$ = make_item("CEED", $1); }
    ;

ceid           /* Collected event ID */
    : uintx_decl            { $$ = make_item("CEID", $1); }
    | intx_decl             { $$ = make_item("CEID", $1); }
    | str_decl              { $$ = make_item("CEID", $1); }
    ;

cepack         /* Command Enhanced Parameter Acknowledge  */
    : LBRACE cpname cepval RBRACE   { $$ = make_cepack_list($2, $3); }
    | uint1_ex_decl                 { $$ = make_item("CEPACK", $1); }
    ;

cepval         /* Command Enhanced Parameter Value  */
    : LBRACE cpname cpval RBRACE    { $$ = make_cepval_list($2, $3); }
    | bool_decl             { $$ = make_item("CEPVAL", $1); }
    | bin_decl              { $$ = make_item("CEPVAL", $1); }
    | str_decl              { $$ = make_item("CEPVAL", $1); }
    | jstr_decl             { $$ = make_item("CEPVAL", $1); }
    | uintx_decl            { $$ = make_item("CEPVAL", $1); }
    | intx_decl             { $$ = make_item("CEPVAL", $1); }
    | realx_decl            { $$ = make_item("CEPVAL", $1); }
    ;

ckpnt          /* Checkpoint as defined by the sending system */
    : uint_ex_decl          { $$ = make_item("CKPNT", $1); }
    ;

cmda           /* Command acknowledge code */
    : uint1_ex_decl         { $$ = make_item("CMDA", $1); }
    | int1_ex_decl          { $$ = make_item("CMDA", $1); }
    ;

cmdmax         /* Command Maximum */
    : uintx_decl            { $$ = make_item("CMDMAX", $1); }
    | intx_decl             { $$ = make_item("CMDMAX", $1); }
    ;

cname          /* Command Name */
    : str_decl              { $$ = make_item("CNAME", $1); }
    ;

colct          /* Column count in die increments */
    : uintx_ex_decl         { $$ = make_item("COLCT", $1); }
    ;

colhdr         /* Text description of contents of TBLELT */
    : str_decl              { $$ = make_item("COLHDR", $1); }
    ;

commack        /* Establish Communications Acknowledge Code */
    : ack_decl              { $$ = make_item("COMMACK", $1); }
    ;

cpack          /* Command Parameter Acknowledge Code */
    : ack_decl              { $$ = make_item("CPACK", $1); }
    ;

cpname         /* Command Parameter Name */
    : uintx_decl            { $$ = make_item("CPNAME", $1); }
    | intx_decl             { $$ = make_item("CPNAME", $1); }
    | str_decl              { $$ = make_item("CPNAME", $1); }
    ;

cpval          /* Command Parameter Value */
    : str_decl              { $$ = make_item("CPVAL", $1); }
    | jstr_decl             { $$ = make_item("CPVAL", $1); }
    | uintx_decl            { $$ = make_item("CPVAL", $1); }
    | intx_decl             { $$ = make_item("CPVAL", $1); }
    | binary                { $$ = make_item("CPVAL", $1); }
    | bool_decl             { $$ = make_item("CPVAL", $1); }
    ;

csaack         /* Equipment Acknowledgement code */
    : ack_decl              { $$ = make_item("CSAACK", $1); }
    ;

ctljobcmd       /* Control job command code */
    : uint1_ex_decl         { $$ = make_item("CTLJOBCMD", $1); }
    ;

ctljobid       /* Identifier for control job */
    : str_decl              { $$ = make_item("CTLJOBID", $1); }
    ;

data           /* A vector or string of unformatted data */
    : str_decl              { $$ = make_item("DATA", $1); }
    ;

dataack        /* Acknowledge code for data */
    : ack_decl              { $$ = make_item("CSAACK", $1); }
    ;

dataid         /* Data ID */
    : intx_decl             { $$ = make_item("DATAID", $1); }
    | uintx_decl            { $$ = make_item("DATAID", $1); }
    | str_decl              { $$ = make_item("DATAID", $1); }
    ;

datalength     /* Total bytes to be sent */
    : uintx_decl            { $$ = make_item("DATALENGTH", $1); }
    | intx_decl             { $$ = make_item("DATALENGTH", $1); }
    ;

dataseg        /* Used to identify the data requested */
    : str_decl              { $$ = make_item("DATASEG", $1); }
    ;

datasrc        /* Object type for Data Source Objects */
    : str_decl              { $$ = make_item("DATASRC", $1); }
    ;

datlc          /* Data location */
    : uint1_ex_decl         { $$ = make_item("DATLC", $1); }
    ;

drack          /* Define Report Acknowledge Code */
    : ack_decl              { $$ = make_item("DRACK", $1); }
    ;

dsid           /* Data set ID */
    : uintx_decl            { $$ = make_item("DSID", $1); }
    | intx_decl             { $$ = make_item("DSID", $1); }
    | str_decl              { $$ = make_item("DSID", $1); }
    ;

dsname         /* The name of the Data Set */
    : str_decl              { $$ = make_item("DSNAME", $1); }
    ;

dsper          /* Data sample period */
    : str_decl              { $$ = make_item("DSPER", $1); }
    ;

dutms          /* Die Units of Measure */
    : str_decl              { $$ = make_item("DUTMS", $1); }
    ;

dvname         /* Data value name */
    : uintx_decl            { $$ = make_item("DVNAME", $1); }
    | intx_decl             { $$ = make_item("DVNAME", $1); }
    | str_decl              { $$ = make_item("DVNAME", $1); }
    ;

dvval          /* Data value */
    : attr                  { $$ = make_item("DVVAL", $1); }
    ;

eac            /* Equipment acknowledge code */
    : ack_decl              { $$ = make_item("EAC", $1); }
    ;

ecdef          /* Equipment constant default value */
    : str_decl              { $$ = make_item("ECDEF", $1); }
    | jstr_decl             { $$ = make_item("ECDEF", $1); }
    | binary                { $$ = make_item("ECDEF", $1); }
    | uintx_decl            { $$ = make_item("ECDEF", $1); }
    | realx_decl            { $$ = make_item("ECDEF", $1); }
    | intx_decl             { $$ = make_item("ECDEF", $1); }
    | bool_decl             { $$ = make_item("ECDEF", $1); }
    ;

ecid           /* Equipment Constant ID */
    : intx_decl             { $$ = make_item("ECID", $1); }
    | uintx_decl            { $$ = make_item("ECID", $1); }
    | str_decl              { $$ = make_item("ECID", $1); }
    ;

ecmax          /* Equipment constant maximum value */
    : str_decl              { $$ = make_item("ECMAX", $1); }
    | jstr_decl             { $$ = make_item("ECMAX", $1); }
    | uintx_decl            { $$ = make_item("ECMAX", $1); }
    | intx_decl             { $$ = make_item("ECMAX", $1); }
    | realx_decl            { $$ = make_item("ECMAX", $1); }
    | bool_decl             { $$ = make_item("ECMAX", $1); }
    | binary                { $$ = make_item("ECMAX", $1); }
    ;

ecmin          /* Equipment constant name */
    : str_decl              { $$ = make_item("ECMIN", $1); }
    | jstr_decl             { $$ = make_item("ECMIN", $1); }
    | uintx_decl            { $$ = make_item("ECMIN", $1); }
    | intx_decl             { $$ = make_item("ECMIN", $1); }
    | realx_decl            { $$ = make_item("ECMIN", $1); }
    | bool_decl             { $$ = make_item("ECMIN", $1); }
    | binary                { $$ = make_item("ECMIN", $1); }
    ;

ecname         /* Equipment constant name */
    : str_decl              { $$ = make_item("ECNAME", $1); }
    ;

ecv            /* Equipment Constant Value */
    : str_decl              { $$ = make_item("ECV", $1); }
    | jstr_decl             { $$ = make_item("ECV", $1); }
    | uintx_decl            { $$ = make_item("ECV", $1); }
    | intx_decl             { $$ = make_item("ECV", $1); }
    | realx_decl            { $$ = make_item("ECV", $1); }
    | bool_decl             { $$ = make_item("ECV", $1); }
    | binary                { $$ = make_item("ECV", $1); }
    ;

edid           /* Expected data Identification */
    : str_decl              { $$ = make_item("EDID", $1); }
    | uintx_decl            { $$ = make_item("EDID", $1); }
    | intx_decl             { $$ = make_item("EDID", $1); }
    | realx_decl            { $$ = make_item("EDID", $1); }
    ;

emid           /* Equivalent material ID */
    : str_decl              { $$ = make_item("EMID", $1); }
    | binary_ex             { $$ = make_item("EMID", $1); }
    ;

epd                    /* Executive program data */
    : binary_ex             { $$ = make_item("EPD", $1); }
    ;

eqname         /* A unique ASCII equipment identifier assigned by the factory
                  to the equipment */
    : str_decl              { $$ = make_item("EQNAME", $1); }
    ;

erack          /* Enable/Disable Event Report */
    : ack_decl              { $$ = make_item("ERACK", $1); }
    ;

errcode        /* Code identifying an error */
    : uintx_ex_decl         { $$ = make_item("ERRCODE", $1); }
    ;

errtext        /* Text string describing the error noted in the corresponding
                  ERRCODE */
    : str_decl              { $$ = make_item("ERRTEXT", $1); }
    ;

errw7          /* Text string describing error found in process program */
    : str_decl              { $$ = make_item("ERRW7", $1); }
    ;

evntsrc        /* Object type for Event Source Objects */
    : str_decl              { $$ = make_item("EVNTSRC", $1); }
    ;

exid           /* Unique identifier for the exception */
    : str_decl              { $$ = make_item("EXID", $1); }
    ;

exmessage      /* Text which describes the nature of the exception */
    : str_decl              { $$ = make_item("EXMESSAGE", $1); }
    ;

exrecvra       /* Text which specifies a recovery action for an exception */
    : str_decl              { $$ = make_item("EXRECVRA", $1); }
    ;

extype         /* Text which identifies the type of an exception */
    : str_decl              { $$ = make_item("EXTYPE", $1); }
    ;

fcnid          /* Function Identification */
    : uint1_ex_decl         { $$ = make_item("FCNID", $1); }
    ;

ffrot          /* Film Frame Rotation */
    : uint2_ex_decl         { $$ = make_item("FFROT", $1); }
    ;

fildat         /* Data from the Data Set */
    : str_decl              { $$ = make_item("FILDAT", $1); }
    | binary_ex             { $$ = make_item("FILDAT", $1); }
    ;

fnloc          /* Flat/Notch Location */
    : uint2_ex_decl         { $$ = make_item("FNLOC", $1); }
    ;

frmlen         /* Formatted Process Program Length */
    : uintx_decl            { $$ = make_item("FRMLEN", $1); }
    | intx_decl             { $$ = make_item("FRMLEN", $1); }
    ;

grant          /* Grant code */
    : ack_decl              { $$ = make_item("GRANT", $1); }
    ;

grant6         /* Permission to send */
    : ack_decl              { $$ = make_item("GRANT6", $1); }
    ;

grnt1          /* Grant code */
    : bin                   { $$ = make_item("GRNT1", $1); }
    ;

handle         /* Logical unit or channel */
    : uintx_decl            { $$ = make_item("HANDLE", $1); }
    | intx_decl             { $$ = make_item("HANDLE", $1); }
    ;

hcack          /* Host Command Parameter Acknowledge Code */
    : ack_decl              { $$ = make_item("HCACK", $1); }
    ;

hoack          /* Conveys whether the corresponding handoff activity
                 success or failed */
    : bool_decl             { $$ = make_item("HOACK", $1); }
    ;

hocancelack    /* Tells whether the cancel ready message was accepted or
                  rejected */
    : uint1_ex_decl         { $$ = make_item("HOCANCELACK", $1); }
    ;

hocmdname      /* Identifier for the handoff command to be executed */
    : str_decl              { $$ = make_item("HOCMDNAME", $1); }
    ;

hohaltack      /* Tells whether the halt command was accepted or rejected */
    : uint1_ex_decl         { $$ = make_item("HOHALTACK", $1); }
    ;

iacds          /* Immediately After Command Codes */
    : uint2_ex_decl         { $$ = make_item("IACDS", $1); }
    | int2_ex_decl          { $$ = make_item("IACDS", $1); }
    ;

ibcds          /* Immediately Before Command Codes */
    : uint2_ex_decl         { $$ = make_item("IBCDS", $1); }
    | int2_ex_decl          { $$ = make_item("IBCDS", $1); }
    ;

idtyp          /* id type */
    : binary_ex             { $$ = make_item("IDTYP", $1); }
    ;

length         /* Length of the service program or process program in bytes */
    : uintx_decl            { $$ = make_item("LENGTH", $1); }
    | intx_decl             { $$ = make_item("LENGTH", $1); }
    ;

limitack       /* Acknowledgement code for variable limit attribute set */
    : ack_decl              { $$ = make_item("LIMITACK", $1); }
    ;

limitid        /* The identifier of a specific limit in the set of limits
                  (as defined by UPPERDB and LOWERDB) for a variable to which
                  the corresponding limit attributes refer */
    : bin                   { $$ = make_item("LIMITID", $1); }
    ;

limitmax       /* The maximum allowed value for the limit values of a specific
                  variable. The equipment manufacturer should specify this
                  value, which would typically coincide with the maximum value
                  of the variable being monitored. The format must match that
                  of the referenced variable */
    : uintx_decl            { $$ = make_item("LIMITMAX", $1); }
    | intx_decl             { $$ = make_item("LIMITMAX", $1); }
    | realx_decl            { $$ = make_item("LIMITMAX", $1); }
    | str_decl              { $$ = make_item("LIMITMAX", $1); }
    | bool_decl             { $$ = make_item("LIMITMAX", $1); }
    ;

limitmin       /* The minimum allowed value for the limit values of a specific
                  variable. The equipment manufacturer should specify this
                  value, which would typically coincide with the maximum value
                  of the variable being monitored. The format must match that
                  of the referenced variable */
    : uintx_decl            { $$ = make_item("LIMITMIN", $1); }
    | intx_decl             { $$ = make_item("LIMITMIN", $1); }
    | realx_decl            { $$ = make_item("LIMITMIN", $1); }
    | str_decl              { $$ = make_item("LIMITMIN", $1); }
    | bool_decl             { $$ = make_item("LIMITMIN", $1); }
    ;

linkid         /* Used to link a completion message with request with a request
                  that an operation be performed */
    : uint_ex_decl          { $$ = make_item("LINKID", $1); }
    ;

llim           /* Lower limit for numeric value */
    : uintx_decl            { $$ = make_item("LLIM", $1); }
    | intx_decl             { $$ = make_item("LLIM", $1); }
    | realx_decl            { $$ = make_item("LLIM", $1); }
    ;

loc            /* Machine material location code */
    : bin                   { $$ = make_item("LOC", $1); }
    ;

locid          /* The logical identifier of a material location */
    : str_decl              { $$ = make_item("LOCID", $1); }
    ;

lowerdb        /* A variable limit attribute which defines the lower boundary
                  of the deadband of a limit. The value applies to a single
                  limit (LIMITID) for a specified VID. Thus, UPPERDB and
                  LOWERDB as a pair define a limit. */
    : uintx_decl            { $$ = make_item("LOWERDB", $1); }
    | intx_decl             { $$ = make_item("LOWERDB", $1); }
    | realx_decl            { $$ = make_item("LOWERDB", $1); }
    | str_decl              { $$ = make_item("LOWERDB", $1); }
    | bool_decl             { $$ = make_item("LOWERDB", $1); }
    ;

lrack          /* Link Report Acknowledge Code */
    : ack_decl              { $$ = make_item("LRACK", $1); }
    ;

lvack          /* Variable limit definition acknowledge code. Defines the
                  error with the limit attributes for the reference VID */
    : ack_decl              { $$ = make_item("LVACK", $1); }
    ;

maper          /* Map Error */
    : binary_ex             { $$ = make_item("MAPER", $1); }
    ;

mapft          /* Map data format type */
    : binary_ex             { $$ = make_item("MAPFT", $1); }
    ;

mcindex        /* Identifier used to link a handoff command message with its
                  eventual completion message. Corresponding messages carry
                  the same value for this data item */
    : uintx_ex_decl         { $$ = make_item("MCINDEX", $1); }
    ;

mdack          /* Map data acknowledge */
    : ack_decl              { $$ = make_item("MDACK", $1); }
    ;

mdln           /* Equipment Model Type */
    : str_decl              { $$ = make_item("MDLN", $1); }
    ;

mexp           /* Message expected in the form SxxFxx where x is stream and y
                  is function */
    : str_decl              { $$ = make_item("MEXP", $1); }
    ;

mf             /* Material format code */
    : bin                   { $$ = make_item("MF", $1); }
    | str_decl              { $$ = make_item("MF", $1); }
    ;

mhead          /* SECS message block header associated with message block in
                  error */
    : binary_ex             { $$ = make_item("MHEAD", $1); }
    ;

mid            /* Material ID */
    : binary_ex             { $$ = make_item("MID", $1); }
    | str_decl              { $$ = make_item("MID", $1); }
    ;

midac          /* Material ID Acknowledge Code */
    : ack_decl              { $$ = make_item("MIDAC", $1); }
    ;

midra          /* Material ID Acknowledge Code */
    : bin                   { $$ = make_item("MIDRA", $1); }
    ;

mlcl           /* Message length */
    : uintx_ex_decl         { $$ = make_item("MLCL", $1); }
    ;

mmode          /* Matrix mode select */
    : bin                   { $$ = make_item("MMODE", $1); }
    ;

nacds          /* Not After Command Codes */
    : uint2_ex_decl         { $$ = make_item("NACDS", $1); }
    | int2_ex_decl          { $$ = make_item("NACDS", $1); }
    ;

nbcds          /* Not Before Command Codes */
    : uint2_ex_decl         { $$ = make_item("NBCDS", $1); }
    | int2_ex_decl          { $$ = make_item("NBCDS", $1); }
    ;

nulbc          /* Null bin code value */
    : uint1_ex_decl         { $$ = make_item("NULBC", $1); }
    | str_decl              { $$ = make_item("NULBC", $1); }
    ;

objack         /* Acknowledge code */
    : uint1_ex_decl         { $$ = make_item("OBJACK", $1); }
    ;

objcmd         /* Specifies an action to be performed by an object */
    : uint1_ex_decl         { $$ = make_item("OBJCMD", $1); }
    ;

objid          /* Identifier for an object */
    : uintx_ex_decl         { $$ = make_item("OBJID", $1); }
    | str_decl              { $$ = make_item("OBJID", $1); }
    ;

objspec        /* A text string that has an internal format and that is used
                  to point to a specific object instance. */
    : str_decl              { $$ = make_item("OBJSPEC", $1); }
    ;

objtoken       /* Token used for authorization */
    : uint_ex_decl          { $$ = make_item("OBJTOKEN", $1); }
    ;

objtype         /* Identifier for a group or class of objects */
    : uintx_ex_decl         { $$ = make_item("OBJTYPE", $1); }
    | str_decl              { $$ = make_item("OBJTYPE", $1); }
    ;

oflack         /* Acknowledge code for OFF-LINE request */
    : ack_decl              { $$ = make_item("OFLACK", $1); }
    ;

opid           /* Operation ID */
    : uintx_ex_decl         { $$ = make_item("OPID", $1); }
    ;

onlack         /* Acknowledge code for ON-LINE request */
    : ack_decl              { $$ = make_item("ONLACK", $1); }
    ;

orloc          /* Origin Location */
    : binary_ex             { $$ = make_item("ORLOC", $1); }
    ;

paramname     /* The name of a parameter in a request */
    : str_decl              { $$ = make_item("PARAMNAME", $1); }
    ;

paramval      /* The value of a parameter named in PARAMNAME */
    : attr                  { $$ = make_item("PARAMVAL", $1); }
    ;

pdflt          /* Parameter Default Value */
    : uintx_decl            { $$ = make_item("PDFLT", $1); }
    | intx_decl             { $$ = make_item("PDFLT", $1); }
    | realx_decl            { $$ = make_item("PDFLT", $1); }
    | str_decl              { $$ = make_item("PDFLT", $1); }
    | bool_decl             { $$ = make_item("PDFLT", $1); }
    ;

pfcd           /* Predefined form code */
    : bin                   { $$ = make_item("PFCD", $1); }
    ;

pgrpaction     /* The action to be performed on a port group */
    : str_decl              { $$ = make_item("PGRPACTION", $1); }
    ;

pmax           /* Parameter Count Maximum */
    : uintx_decl            { $$ = make_item("PMAX", $1); }
    | intx_decl             { $$ = make_item("PMAX", $1); }
    ;

pname          /* Parameter Name */
    : str_decl              { $$ = make_item("PNAME", $1); }
    ;

portaction     /* The action to be performed on a port */
    : str_decl              { $$ = make_item("PORTACTION", $1); }
    ;

portgrpname    /* The identifier of a group of ports */
    : str_decl              { $$ = make_item("PORTGRPNAME", $1); }
    ;

pparm          /* Process Parameter */
    : uintx_decl            { $$ = make_item("PPARM", $1); }
    | intx_decl             { $$ = make_item("PPARM", $1); }
    | realx_decl            { $$ = make_item("PPARM", $1); }
    | str_decl              { $$ = make_item("PPARM", $1); }
    | bool_decl             { $$ = make_item("PPARM", $1); }
    ;

ppbody         /* Process Program body */
    : binary                { $$ = make_item("PPBODY", $1); }
    | str_decl              { $$ = make_item("PPBODY", $1); }
    | uint_array_decl       { $$ = make_item("PPBODY", $1); }
    ;

ppgnt          /* Process program grant status */
    : ack_decl              { $$ = make_item("PPGNT", $1); }
    ;

ppid           /* Process program ID */
    : binary_ex             { $$ = make_item("PPID", $1); }
    | str_decl              { $$ = make_item("PPID", $1); }
    ;

praxi          /* Process axis */
    : binary_ex             { $$ = make_item("PRAXI", $1); }
    ;

prcmdname      /* Commands sent to a process job */
    : str_decl              { $$ = make_item("PRCMDNAME", $1); }
    ;

prdct          /* Process Die Count */
    : uintx_ex_decl         { $$ = make_item("PRDCT", $1); }
    ;

preventid      /* Processing related event identification */
    : uintx_ex_decl         { $$ = make_item("PREVENTID", $1); }
    ;

prjobid        /* Text string which uniquely identifies a process job */
    : str_decl              { $$ = make_item("PRJOBID", $1); }
    ;

prjobmilestone
    : uintx_ex_decl         { $$ = make_item("PRJOBMILESTONE", $1); }
    ;

prjobspace     /* The number of process jobs that can be created */
    : uint2_ex_decl         { $$ = make_item("PRJOBSPACE", $1); }
    ;

prmtrlorder    /* Define the order by which material in the process jobs */
    : uint1_ex_decl         { $$ = make_item("PRMTRLORDER", $1); }
    ;

prpauseevent   /* The list of event identifiers  */
    : attr                  { $$ = make_item("PRPAUSEEVENT", $1); }
    ;

prprocessstart
    : bool_decl             { $$ = make_item("PRPROCESSSTART", $1); }
    ;

prrecipemethod
    : uintx_ex_decl         { $$ = make_item("PRRECIPEMETHOD", $1); }
    ;

prstate        /* Enumerated value */
    : uint1_ex_decl         { $$ = make_item("PRSTATE", $1); }
    ;

ptn            /* Material Port number */
    : bin                   { $$ = make_item("PTN", $1); }
    ;

qua            /* Quantity in format */
    : bin                   { $$ = make_item("QUA", $1); }
    ;

rac            /* Reset acknowledge */
    : uint1_ex_decl         { $$ = make_item("RAC", $1); }
    | int1_ex_decl          { $$ = make_item("RAC", $1); }
    ;

rcmd           /* Remote command code or string */
    : uint1_ex_decl         { $$ = make_item("RCMD", $1); }
    | int1_ex_decl          { $$ = make_item("RCMD", $1); }
    | str_decl              { $$ = make_item("RCMD", $1); }
    ;

rcpattrdata    /* Notification of Processing status shall have one of
                  the following values */
    : value                 { $$ = make_item("RCPATTRDATA", $1); }
    ;

rcpattrid      /* The contents (value) of a recipe attribute */
    : str_decl              { $$ = make_item("RCPATTRID", $1); }
    ;

rcpbody        /* Recipe body */
    : binary                { $$ = make_item("RCPBODY", $1); }
    | str_decl              { $$ = make_item("RCPBODY", $1); }
    | uint_array_decl       { $$ = make_item("RCPBODY", $1); }
    ;

rcpclass       /* Recipe class */
    : str_decl              { $$ = make_item("RCPCLASS", $1); }
    ;

rcpcmd         /* Indicates an action to be performed on a recipe */
    : uint1_ex_decl         { $$ = make_item("RCPCMD", $1); }
    ;

rcpdel         /* Recipe delete */
    : uint1_ex_decl         { $$ = make_item("RCPDEL", $1); }
    ;

rcpdesclth     /* The length in bytes of a recipe section */
    : uintx_ex_decl         { $$ = make_item("RCPDESCLTH", $1); }
    ;

rcpdescnm      /* Identifies a type of descriptor of a recipe */
    : str_decl              { $$ = make_item("RCPDESCNM", $1); }
    ;

rcpdesctime    /* The timestamp of a recipe section */
    : str_decl              { $$ = make_item("RCPDESCTIME", $1); }
    ;

rcpid          /* Recipe identifier */
    : str_decl              { $$ = make_item("RCPID", $1); }
    ;

rcpname        /* Recipe name */
    : str_decl              { $$ = make_item("RCPNAME", $1); }
    ;

rcpnewid       /* The new recipe identifier assigned as the result of a copy
                  or rename operation */
    : str_decl              { $$ = make_item("RCPNEWID", $1); }
    ;

rcpowcode      /* Indicates whether any pre-existing recipe is to be
                  overwritten (=TRUE) or not (=FALSE) on download */
    : bool_decl             { $$ = make_item("RCPOWCODE", $1); }
    ;

rcpparnm       /* The name of a recipe variable parameter */
    : str_decl              { $$ = make_item("RCPPARNM", $1); }
    ;

rcpparrule     /* The restrictions applied to a recipe variable parameter
                  setting */
    : str_decl              { $$ = make_item("RCPPARRULE", $1); }
    ;

rcpparval      /*The initial setting assigned to a recipe variable parameter*/
    : bool_decl             { $$ = make_item("RCPPARVAL", $1); }
    | bin_decl              { $$ = make_item("RCPPARVAL", $1); }
    | str_decl              { $$ = make_item("RCPPARVAL", $1); }
    | uintx_decl            { $$ = make_item("RCPPARVAL", $1); }
    | intx_decl             { $$ = make_item("RCPPARVAL", $1); }
    | realx_decl            { $$ = make_item("RCPPARVAL", $1); }
    ;

rcprename      /* Indicates whether a recipe is to be renamed (=TRUE) or
                  copied (=FALSE) */
    : bool_decl             { $$ = make_item("RCPRENAME", $1); }
    ;

rcpseccode     /* Indicates the sections of a recipe requested for transfer or
                  being transferred */
    : bin                   { $$ = make_item("RCPSECCODE", $1); }
    ;

rcpsecnm       /* Recipe section name */
    : str_decl              { $$ = make_item("RCPSECNM", $1); }
    ;

rcpspec        /* Recipe specifier */
    : str_decl              { $$ = make_item("RCPSPEC", $1); }
    ;

rcpstat        /* The status of a managed recipe */
    : uint1_ex_decl         { $$ = make_item("RCPSTAT", $1); }
    ;

rcpupdt        /* Indicates if an existing recipe is to be updated (=TRUE) or
                  a new recipe is to be created (=FALSE) */
    : bool_decl             { $$ = make_item("RCPUPDT", $1); }
    ;

rcpvers        /* Recipe version */
    : str_decl              { $$ = make_item("RCPVERS", $1); }
    ;

readln         /* Maximum length to read */
    : uintx_decl            { $$ = make_item("READLN", $1); }
    | intx_decl             { $$ = make_item("READLN", $1); }
    ;

reclen         /* Maximum length of a Discrete record */
    : uintx_decl            { $$ = make_item("RECLEN", $1); }
    | intx_decl             { $$ = make_item("RECLEN", $1); }
    ;

refp_xy        /* reference Point */
    : int_array_decl        { $$ = make_item("REFP", $1); }
    ;

repgsz         /* Reporting group size */
    : uintx_decl            { $$ = make_item("REPGSZ", $1); }
    | intx_decl             { $$ = make_item("REPGSZ", $1); }
    | str_decl              { $$ = make_item("REPGSZ", $1); }
    ;

resc           /* Resolution code for numeric data */
    : uint1_ex_decl         { $$ = make_item("RESC", $1); }
    | int1_ex_decl          { $$ = make_item("RESC", $1); }
    ;

respec         /* Object specifier for the recipe executor */
    : str_decl              { $$ = make_item("RESPEC", $1); }
    ;

resv           /* Resolution value for numeric data */
    : uintx_decl            { $$ = make_item("RESV", $1); }
    | intx_decl             { $$ = make_item("RESV", $1); }
    | real_decl             { $$ = make_item("RESV", $1); }
    ;

ric            /* Reset code */
    : uint1_ex_decl         { $$ = make_item("RIC", $1); }
    | int1_ex_decl          { $$ = make_item("RIC", $1); }
    ;

rmack          /* Conveys whether a requested action was successfully
                  completed, denies, completed with errors, or will be
                  completed with notification to the requestor */
    : uint1_ex_decl         { $$ = make_item("RMACK", $1); }
    ;

rmchgstat      /* Indicates the change that occurred for an object */
    : uintx_ex_decl         { $$ = make_item("RMCHGSTAT", $1); }
    ;

rmchgtype      /* Indicates the type of change for a recipe */
    : uintx_ex_decl         { $$ = make_item("RMCHGTYPE", $1); }
    ;

rmdatasize     /* Tha maximum total length, in bytes, of a multi-block
                  message, used by the receiver to determine if the
                  anticipated message exceeds the receiver's capacity */
    : uintx_ex_decl         { $$ = make_item("RMDATASIZE", $1); }
    ;

rmgrnt         /* Grant code, used to grant or deny a request */
    : bin                   { $$ = make_item("RMGRNT", $1); }
    ;

rmnewns        /* New name (identifier) assigned to a recipe namespace */
    : str_decl              { $$ = make_item("RMNEWNS", $1); }
    ;

rmnscmd        /* Action to be performed on a recipe namespace */
    : uint1_ex_decl         { $$ = make_item("RMNSCMD", $1); }
    ;

rmnsspec       /* The object specifier of a recipe namespace */
    : str_decl              { $$ = make_item("RMNSSPEC", $1); }
    ;

rmrecspec      /* The object specifier of a descributed recipe namespace
                  recorder */
    : str_decl              { $$ = make_item("RMRECSPEC", $1); }
    ;

rmrequestor    /* Set to TRUE if initiator of change request was an attached
                  segment */
    : bool_decl             { $$ = make_item("RMREQUESTOR", $1); }
    ;

rmsegspec      /* The object specifier of a descributed recipe namespace
                  segment */
    : str_decl              { $$ = make_item("RMSEGSPEC", $1); }
    ;

rmspace        /* The amount of strage available for at least one recipe in
                  a recipe namespace */
    : uintx_ex_decl         { $$ = make_item("RMSPACE", $1); }
    ;

rowct          /* Row count in die increments */
    : uintx_ex_decl         { $$ = make_item("ROWCT", $1); }
    ;

rpsel          /* Reference Point Select */
    : uint1_ex_decl         { $$ = make_item("RPSEL", $1); }
    ;

rptid          /* Report ID */
    : uintx_decl            { $$ = make_item("RPTID", $1); }
    | intx_decl             { $$ = make_item("RPTID", $1); }
    | str_decl              { $$ = make_item("RPTID", $1); }
    ;

rptoc          /* A Trace object attribute for a flag */
    : bool_decl             { $$ = make_item("RPTOC", $1); }
    ;

rqcmd          /* Required Command */
    : bool_decl             { $$ = make_item("RQCMD", $1); }
    ;

rqpar          /* Required Parameter */
    : bool_decl             { $$ = make_item("RQPAR", $1); }
    ;

rrack          /* Request to Receive Acknowledge code */
    : ack_decl              { $$ = make_item("RRACK", $1); }
    ;

rsack          /* Ready to Send Acknowledge code */
    : ack_decl              { $$ = make_item("RSACK", $1); }
    ;

rsda           /* Request Spool Data Acknowledge */
    : ack_decl              { $$ = make_item("RSDA", $1); }
    ;

rsdc           /* Request Spool Data Code */
    : uint1_ex_decl         { $$ = make_item("RSDC", $1); }
    ;

rsinf          /* Starting location for row or column */
    : intx_ex_decl          { $$ = make_item("RSINF", $1); }
    ;

rsinf_xyd
    : LBRACE UINTEGER UINTEGER UINTEGER RBRACE
        { $$ = make_rsinf_xyd($2, $3, $4); }
    ;

rspack         /* Reset Spooling Acknowledge */
    : ack_decl              { $$ = make_item("RSPACK", $1); }
    ;

rtype          /* Type of record */
    : uintx_decl            { $$ = make_item("RTYPE", $1); }
    | intx_decl             { $$ = make_item("RTYPE", $1); }
    ;

sdack          /* Map set-up data acknowledge */
    : ack_decl              { $$ = make_item("SDACK", $1); }
    ;

sdbin          /* Send bin information flag */
    : binary_ex             { $$ = make_item("SDBIN", $1); }
    ;

seqnum         /* Command Number */
    : uintx_decl            { $$ = make_item("SEQNUM", $1); }
    | intx_decl             { $$ = make_item("SEQNUM", $1); }
    ;

sfcd           /* Status form code */
    : bin                   { $$ = make_item("SFCD", $1); }
    ;

shead          /* Stored header related to the transaction timer */
    : binary_ex             { $$ = make_item("SHEAD", $1); }
    ;

slotid         /* Used to reference material by slot in a crrier */
    : uint1_ex_decl         { $$ = make_item("SLOTID", $1); }
    ;

smpln          /* Sample number */
    : uintx_decl            { $$ = make_item("SMPLN", $1); }
    | intx_decl             { $$ = make_item("SMPLN", $1); }
    ;

softrev        /* Software revision code */
    : str_decl              { $$ = make_item("SOFTREV", $1); }
    ;

spaack         /* Equipment acknowledgement code */
    : ack_decl              { $$ = make_item("SPAACK", $1); }
    ;

spname         /* Service parameter name */
    : str_decl              { $$ = make_item("SPNAME", $1); }
    ;

spd            /* Service program data */
    : binary_ex             { $$ = make_item("SPD", $1); }
    ;

spval          /* Service parameter value */
    : attr                  { $$ = make_item("SPVAL", $1); }
    ;

spid           /* Service program ID */
    : str_decl              { $$ = make_item("SPID", $1); }
    ;

spr            /* Service program results */
    : str_decl              { $$ = make_item("SPR", $1); }
    ;

ssack          /* Indicates the success or failure of a requested action */
    : str_decl              { $$ = make_item("SSACK", $1); }
    ;

sscmd          /* Indicates an action to be performed by the subsystem  */
    : str_decl              { $$ = make_item("SSCMD", $1); }
    ;

status         /* Provides starus information for a subsystem component */
    : str_decl              { $$ = make_item("STATUS", $1); }
    ;

statuslist     /* A list of status data sent in a fix order */
    : LBRACE RBRACE                     { $$ = NULL; }
    | LBRACE status_list RBRACE         { $$ = $2; }
    ;

status_list
    : status                            { $$ = make_item_list(NULL, $1); }
    | status_list status                { $$ = make_item_list($1, $2); }
    ;

stemp          /* String template */
    : str_decl              { $$ = make_item("STEMP", $1); }
    ;

stime          /* Sample time */
    : str_decl              { $$ = make_item("STIME", $1); }
    ;

strack         /* Spool Stream Acknowledge */
    : ack_decl              { $$ = make_item("STRACK", $1); }
    ;

strid          /* Stream Identification */
    : uint1_ex_decl         { $$ = make_item("STRID", $1); }
    ;

strp_xy        /* Starting position in die coordinate position. Must be in
                  (X,Y) order */
    : int_array_decl        { $$ = make_item("STRP", $1); }
    ;

sv             /* Status variable value */
    : value                 { $$ = make_item("SV", $1); }
    ;

svcack         /* Service acceptance acknowledge code */
    : ack_decl              { $$ = make_item("SVCACK", $1); }
    ;

svcname        /* Service name provided on specified object asking by the host */
    : str_decl              { $$ = make_item("SVCNAME", $1); }
    ;

svid           /* Status variable ID */
    : uintx_decl            { $$ = make_item("SVID", $1); }
    | intx_decl             { $$ = make_item("SVID", $1); }
    | str_decl              { $$ = make_item("SVID", $1); }
    ;

svname         /* Status Variable Name */
    : str_decl              { $$ = make_item("SVNAME", $1); }
    ;

targetid      /* Identifies where a request for action or data */
    : str_decl              { $$ = make_item("TARGETSPEC", $1); }
    ;

targetspec     /* Object specifier of target object */
    : str_decl              { $$ = make_item("TARGETSPEC", $1); }
    ;

tblack         /* Indicates success or failure */
    : uint1_ex_decl         { $$ = make_item("TBLACK", $1); }
    ;

tblcmd         /* Provides information about the table or parts of the table
                  being transferred or requested */
    : uint1_ex_decl         { $$ = make_item("TBLCMD", $1); }
    ;

tblelt         /* Table element */
    : value                 { $$ = make_item("TBLELT", $1); }
    ;

tblid          /* Table identifier */
    : str_decl              { $$ = make_item("TBLID", $1); }
    ;

tbltyp         /* A reserved text to denote the format and application of
                  the table */
    : str_decl              { $$ = make_item("TBLTYP", $1); }
    ;

text           /* A single line of characters */
    : str_decl              { $$ = make_item("TEXT", $1); }
    | binary                { $$ = make_item("TEXT", $1); }
    | uintx_decl            { $$ = make_item("TEXT", $1); }
    | intx_decl             { $$ = make_item("TEXT", $1); }
    ;

tiaack         /* Equipment acknowledgement code */
    : ack_decl              { $$ = make_item("TIAACK", $1); }
    ;

tiack          /* Time Acknowledge Code */
    : ack_decl              { $$ = make_item("TIACK", $1); }
    ;

tid            /* Terminal number */
    : bin                   { $$ = make_item("TID", $1); }
    ;

time           /* Time of day */
    : str_decl              { $$ = make_item("TIME", $1); }
    ;

timeformat     /* Time format */
    : uintx_ex_decl         { $$ = make_item("TIMEFORMAT", $1); }
    ;

timestamp      /* Timestamp */
    : str_decl              { $$ = make_item("TIMESTAMP", $1); }
    ;

totsmp         /* Total samples to be made */
    : uintx_decl            { $$ = make_item("TOTSMP", $1); }
    | intx_decl             { $$ = make_item("TOTSMP", $1); }
    | str_decl              { $$ = make_item("TOTSMP", $1); }
    ;

track          /* Tells whether the related transfer activity was successful
                  or unsuccessful */
    : bool_decl             { $$ = make_item("TRACK", $1); }
    ;

tratomicid     /* Equipment assigned identifier for an atomic transfer */
    : uintx_ex_decl         { $$ = make_item("TRATOMICID", $1); }
    ;

trautod        /* A Trace Object attribute for a control flag */
    : bool_decl             { $$ = make_item("TRAUTOD", $1); }
    ;

trautostart    /* For each atomic transfer, this data item tells the equipment
                  if it should automatically start the handoff when ready
                  (=TRUE) or await the host's "StartHandoff" command (=FALSE)
                  following setup. This data item only affects the primary
                  transfer partner */
    : bool_decl             { $$ = make_item("TRAUTOSTART", $1); }
    ;

trcmdname      /* Identifier of the transfer job-related command to be
                  executed */
    : str_decl              { $$ = make_item("TRCMDNAME", $1); }
    ;

trdir          /* Direction of handoff */
    : uint1_ex_decl         { $$ = make_item("TRDIR", $1); }
    ;

trid           /* Trace request ID */
    : uintx_decl            { $$ = make_item("TRID", $1); }
    | intx_decl             { $$ = make_item("TRID", $1); }
    | str_decl              { $$ = make_item("TRID", $1); }
    ;

trjobid        /* Equipment assigned identifier for the transfer job */
    : binary_ex             { $$ = make_item("TRJOBID", $1); }
    ;

trjobms        /* Milestone for a transfer job */
    : uint1_ex_decl         { $$ = make_item("TRJOBMS", $1); }
    ;

trjobname      /* Host assigned identifier for the transfer job */
    : str_decl              { $$ = make_item("TRJOBNAME", $1); }
    ;

trlink         /* Common identifier for the atomic transfer used by the
                  transfer partners to confirm that they are working on the
                  same host-defined task */
    : uintx_ex_decl         { $$ = make_item("TRLINK", $1); }
    ;

trlocation     /* Identifier of the material location involved with the
                  transfer */
    : uintx_ex_decl         { $$ = make_item("TRLOCATION", $1); }
    ;

trobjname      /* Identifier for the material (transfer object) to be
                  transferred */
    : str_decl              { $$ = make_item("TROBJNAME", $1); }
    ;

trobjtype      /* Type of object to be transferred */
    : uintx_ex_decl         { $$ = make_item("TROBJTYPE", $1); }
    ;

trport         /*Identifier of the equipment port to be used for the handoff*/
    : uintx_ex_decl         { $$ = make_item("TRPORT", $1); }
    ;

trptnr         /* Name of the equipment which will serve as the other transfer
                  partner for this atomic transfer */
    : str_decl              { $$ = make_item("TRPTNR", $1); }
    ;

trptport       /* Identifier of the transfer partner's port to be used for
                  the transfer */
    : uintx_ex_decl         { $$ = make_item("TRPTPORT", $1); }
    ;

trrcp          /* Name of the transfer recipe for this handoff */
    : str_decl              { $$ = make_item("TRRCP", $1); }
    ;

trrole         /* Tells whether the equipment is to be the primary or
                  secondary transfer partner */
    : uint1_ex_decl         { $$ = make_item("TRROLE", $1); }
    ;

trsper         /* A Trace Object attribute which holds the value for sampling
                  interval time */
    : realx_decl            { $$ = make_item("TRSPER", $1); }
    ;

trtype         /* Tells whether the equipment is to be an active or passive
                  participant in the transfer */
    : uint1_ex_decl         { $$ = make_item("TRTYPE", $1); }
    ;

tsip           /* Transfer status of input port */
    : bin                   { $$ = make_item("TSIP", $1); }
    ;

tsop           /* Transfer status of output port */
    : bin                   { $$ = make_item("TSOP", $1); }
    ;

ttc            /* Time of completion */
    : uintx_decl            { $$ = make_item("TTC", $1); }
    | intx_decl             { $$ = make_item("TTC", $1); }
    ;

ulim           /* Upper limit for numeric value */
    : uintx_decl            { $$ = make_item("ULIM", $1); }
    | intx_decl             { $$ = make_item("ULIM", $1); }
    | realx_decl            { $$ = make_item("ULIM", $1); }
    ;

unflen         /* Unformatted Process Program Length */
    : uintx_decl            { $$ = make_item("UNFLEN", $1); }
    | intx_decl             { $$ = make_item("UNFLEN", $1); }
    ;

units                  /* Units Identifier */
    : str_decl              { $$ = make_item("UNITS", $1); }
    ;

upperdb        /* A variable limit attribute which defines the upper boundary
                  of the deadband of a limit. The value applies to a single
                  limit (LIMITID) for a specified VID. Thus, UPPERDB and
                  LOWERDB as pair define a limit. */
    : uintx_decl            { $$ = make_item("UPPERDB", $1); }
    | intx_decl             { $$ = make_item("UPPERDB", $1); }
    | realx_decl            { $$ = make_item("UPPERDB", $1); }
    | str_decl              { $$ = make_item("UPPERDB", $1); }
    | bool_decl             { $$ = make_item("UPPERDB", $1); }
    ;

val            /* Variable Data */
    : value                 { $$ = make_item("V", $1); }
    ;

vid            /* Variable ID */
    : uintx_decl            { $$ = make_item("VID", $1); }
    | intx_decl             { $$ = make_item("VID", $1); }
    | str_decl              { $$ = make_item("VID", $1); }
    ;

vlaack         /* Variable Limit Attribute Acknowledge Code */
    : ack_decl              { $$ = make_item("VLAACK", $1); }
    ;

xdies          /* X-axis die size */
    : uintx_ex_decl         { $$ = make_item("XDIES", $1); }
    | realx_decl            { $$ = make_item("XDIES", $1); }
    ;

xypos          /* X and Y Coordinate Position */
    : LBRACE UINTEGER UINTEGER RBRACE   { $$ = make_xypos($2, $3); }
    | LBRACE INT1 INT1 RBRACE           { $$ = make_xypos($2, $3); }
    | LBRACE INT2 INT2 RBRACE           { $$ = make_xypos($2, $3); }
    | LBRACE INTEGER INTEGER RBRACE     { $$ = make_xypos($2, $3); }
    | LBRACE LONGLONG LONGLONG RBRACE   { $$ = make_xypos_ll($2, $3); }
    ;

ydies          /* Y-axis die size */
    : uintx_ex_decl         { $$ = make_item("YDIES", $1); }
    | realx_decl            { $$ = make_item("YDIES", $1); }
    ;

/*---------------------------------------------------------------------------*/
ack_decl
    : bin                   { $$ = $1; }
    ;

attr_list
    : LBRACE RBRACE         { $$ = NULL; }
    | LBRACE attr_s RBRACE  { $$ = $2;   }
    ;

attr_s
    : attr                  { $$ = make_atom_list(NULL, $1); }
    | attr_s attr           { $$ = make_atom_list($1, $2); }
    ;

attr
    : attr_list             { $$ = $1; }
    | uint_decl             { $$ = $1; }
    | intx_decl             { $$ = $1; }
    | bin_decl              { $$ = $1; }
    | realx_decl            { $$ = $1; }
    | str_decl              { $$ = $1; }
    | jstr_decl             { $$ = $1; }
    | bool_decl             { $$ = $1; }
    ;


intx_decl
    : int_decl              { $$ = $1; }
    | int1_decl             { $$ = $1; }
    | int2_decl             { $$ = $1; }
    | int8_decl             { $$ = $1; }
    ;

intx_ex_decl
    : int_ex_decl           { $$ = $1; }
    | int1_decl             { $$ = $1; }
    | int2_decl             { $$ = $1; }
    | int8_decl             { $$ = $1; }
    ;

uintx_decl
    : uint_decl             { $$ = $1; }
    | uint1_decl            { $$ = $1; }
    | uint2_decl            { $$ = $1; }
    | uint8_decl            { $$ = $1; }
    ;

uintx_ex_decl
    : uint_ex_decl          { $$ = $1; }
    | uint1_decl            { $$ = $1; }
    | uint2_decl            { $$ = $1; }
    | uint8_decl            { $$ = $1; }
    ;

realx_decl
    : real_decl             { $$ = $1; }
    | float_decl            { $$ = $1; }
    ;

value_list
    : LBRACE RBRACE         { $$ = make_atom_list(NULL, NULL); }
    | LBRACE values RBRACE  { $$ = $2; }
    ;

values
    : value                 { $$ = make_atom_list(NULL, $1); }
    | values value          { $$ = make_atom_list($1, $2); }
    ;

value
    : bin_decl              { $$ = $1; }
    | bool_decl             { $$ = $1; }
    | intx_decl             { $$ = $1; }
    | uintx_decl            { $$ = $1; }
    | realx_decl            { $$ = $1; }
    | str_decl              { $$ = $1; }
    | jstr_decl             { $$ = $1; }
    | value_list            { $$ = $1; }
    ;

binary
    : bin_decl              { $$ = $1; }
    | LBRACE RBRACE         { $$ = NULL; }
    | LBRACE bins RBRACE    { $$ = $2; }
    ;

binary_ex
    : bin                   { $$ = $1; }
    | LBRACE RBRACE         { $$ = NULL; }
    | LBRACE bins RBRACE    { $$ = $2; }
    ;

bins
    : bin_decl              { $$ = $1; }
    | bins bin_decl         { $$ = make_add_binary($1, $2); }
    ;

bin_decl
    : HEX                   { $$ = make_atom_binary($1); }
    ;

bin
    : HEX
        {
            if ($1 < 256)
                $$ = make_atom_binary($1);
            else
                YYABORT;
        }
    | UINTEGER
        {
            if ($1 < 256)
                $$ = make_atom_binary($1);
            else
                YYABORT;
        }
    ;

bool_decl
    : BOOLEAN               { $$ = make_atom_boolean($1); }
    ;

int_array_decl
    : LBRACE int_array RBRACE   { $$ = $2; }
    ;

int_array
    : int_ex                { $$ = make_int_array(NULL, $1); }
    | int_array int_ex      { $$ = make_int_array($1, $2); }
    ;

int_ex
    : UINTEGER
        {
            if ($1 < 0x80000000)
                $$ = $1;
            else
                YYABORT;
        }
    | INTEGER               { $$ = $1; }
    ;

int_decl
    : INTEGER               { $$ = make_atom_integer($1); }
    ;

int_ex_decl
    : UINTEGER
        {
            if ($1 < 0x80000000)
                $$ = make_atom_integer($1);
            else
                YYABORT;
        }
    | INTEGER               { $$ = make_atom_integer($1); }
    ;

int1_decl
    : INT1                  { $$ = make_atom_int1($1); }
    ;

int1_ex_decl
    : INT1                  { $$ = make_atom_int1($1); }
    | INTEGER
        {
            if (-128 <= $1 && $1 < 128)
                $$ = make_atom_int1($1);
            else
                YYABORT;
        }
    ;

int2_decl
    : INT2                  { $$ = make_atom_int2($1); }
    ;

int2_ex_decl
    : INT2                  { $$ = make_atom_int2($1); }
    | INTEGER
        {
            if (-32768 <= $1 && $1 < 32768)
                $$ = make_atom_int2($1);
            else
                YYABORT;
        }
    ;

int8_decl
    : LONGLONG              { $$ = make_atom_int8($1); }
    ;

uint_array_decl
    : LBRACE uint_array RBRACE  { $$ = $2; }
    ;

uint_array
    : UINTEGER              { $$ = make_uint_array(NULL, $1); }
    | uint_array UINTEGER   { $$ = make_uint_array($1, $2); }
    ;

uint_decl
    : UINTEGER              { $$ = make_atom_uint4($1); }
    ;

uint_ex_decl
    : UINTEGER              { $$ = make_atom_uint4($1); }
    | INTEGER
        {
            if (0 <= $1)
                $$ = make_atom_uint4($1);
            else
                YYABORT;
        }
    ;

uint1_decl
    : UINT1                 { $$ = make_atom_uint1($1); }
    ;

uint1_ex_decl
    : UINT1                 { $$ = make_atom_uint1($1); }
    | HEX                   { $$ = make_atom_uint1($1); }
    | UINTEGER
        {
            if (0 <= $1 && $1 < 256)
                $$ = make_atom_uint1($1);
            else
                YYABORT;
        }
    ;

uint2_decl
    : UINT2                 { $$ = make_atom_uint2($1); }
    ;

uint2_ex_decl
    : UINT2                 { $$ = make_atom_uint2($1); }
    | UINTEGER
        {
            if (0 <= $1 && $1 < 65536)
                $$ = make_atom_uint2($1);
            else
                YYABORT;
        }
    ;

uint8_decl
    : ULONGLONG             { $$ = make_atom_uint8($1); }
    ;

real_decl
    : REAL                  { $$ = make_atom_real($1); }
    ;

float_decl
    : FLOAT                 { $$ = make_atom_float($1); }
    ;

str_decl
    : STRING                { $$ = make_atom_string($1); }
    ;

str_ex_decl
    : STRING                { $$ = make_atom_string($1); }
    | JSTRING               { $$ = make_atom_sjis_string($1); }
    ;

jstr_decl
    : JSTRING
        {
            $$ = make_atom_sjis_string($1);
        }
    ;


%%

/*--------------------------------------------------------------------------*/
/*                                                                          */
/*--------------------------------------------------------------------------*/
int  LineNum = 1;
int  convert_done;
void * secs_message = NULL;
static Tcl_Mutex parserMutex;   /* To protect the above statics */

extern void un_lex();

/*--------------------------------------------------------------------------*/
/* Tcl script format to string                                              */
/*--------------------------------------------------------------------------*/
char * parse_script(Tcl_Interp * interp, char * script, int size,
                    int * newsize)
{
    char * nextp;
    char * varp;
    char * complete_script;
    char * curp;
    char before_ch;
    int  varlen, curlen;
    int  found = 0;
    int  max_size = 4096;
    complete_script = (char *)malloc(max_size);
    if (complete_script == NULL)
        return NULL;
    curp = script;
    before_ch = '\0';
    curlen = 0;
    while (*curp)
    {
        if (*curp == '$' && before_ch != '\\')
        {
            varp = Tcl_ParseVar(interp, curp, &nextp);
            if (varp == NULL)
            {
                printf("parse error: %s\n", curp);
                free(complete_script);
                return NULL;
            }
            varlen = strlen(varp);
            if (max_size < (curlen + varlen + 1))
            {
                max_size += (varlen + 4096);
                complete_script = (char *)realloc(complete_script, max_size);
                if (complete_script == NULL)
                {
                    return NULL;
                }
            }
            strcpy(complete_script + curlen, varp);
            curlen += varlen;
            before_ch = varp[varlen - 1];
            curp = nextp;
            found = 1;
        }
        else
        {
            before_ch = *curp;
            *(complete_script + curlen) = *curp++;
            curlen++;
        }
        if (max_size < curlen + 3)
        {
            max_size += 4096;
            complete_script = (char *)realloc(complete_script, max_size);
            if (complete_script == NULL)
            {
                return NULL;
            }
        }
    }
    *(complete_script + curlen) = ';';      /* append end of line character */
    *(complete_script + curlen + 1) = ' ';
    *(complete_script + curlen + 2) = '\0';
    *newsize = curlen + 3;
    return complete_script;
}

/*----------------------------------------------------------------------------*/
/* parse secs message in tcl                                                  */
/*----------------------------------------------------------------------------*/
int TclParseSecs(Tcl_Interp * interp, char * script, int size, void ** retmsg)
{
    int result;
    char * newscript;
    int newsize;

    Tcl_MutexLock(&parserMutex);

    newscript = NULL;
    newsize = 0;
    secs_message = NULL;
    if ((newscript = parse_script(interp, script, size, &newsize)) != NULL)
    {
        myinputptr = newscript;
        myinputlim = newscript + strlen(newscript);
        myinterp = interp;

        /* normal interaction on yyin and yyout from now on */
        result = yyparse();
        if (secs_message != NULL)
        {
            *retmsg = secs_message;
            result = 0;
        }
        else
            result = -1;
    }
    else
    {
        myinputptr = script;
        myinputlim = script + size;
        myinterp = interp;

        /* normal interaction on yyin and yyout from now on */
        /*
         * result = yyparse();
         */
        result = 1;
    }

    un_lex();
    if (newscript != NULL)
        free(newscript);

    Tcl_MutexUnlock(&parserMutex);
    return result;
}


/* -- print error messeage -- */
void yyerror(char * s)
{
    fprintf(stderr, "%d: %s at %s\n", LineNum, s, yytext);
    return ;
}

/*
 *
 */
int
yywrap()
{
        return 1;
}

/* --  -- */
void
warning(char * s, char * t)             /* print warning message */
{
    fprintf(stderr, "warning: ");
    if (t)
        fprintf(stderr, " %s", t);
    fprintf(stderr, " line %d\n", LineNum);
    return ;
}

