// $Id: PLCDevice.cpp,v 1.2 2003/03/19 16:49:24 fukasawa Exp $

//=============================================================================
/**
 *  @file    PLCDevice.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "PLCDeviceManager.h"
#include "PLCDevice.h"
#include "ace/Log_Msg.h"

//------------------------------------------------------------------------------
// Convert string to device address
//------------------------------------------------------------------------------
long PLCDevice::convAddress(const ACE_TCHAR * addr) const
{
    u_int pos = ACE_OS::strcspn(addr, ACE_TEXT("0123456789"));
    if (pos >= strlen(addr))
    {
        return ACTION_END;
    }

    long retAddr;
    if ((*(addr + pos) == '0') &&
        (*(addr + pos + 1) == 'x' || *(addr + pos + 1) == 'X'))
    {
        retAddr = strtol(addr + pos, NULL, 16);
    }
    else
    {
        retAddr = strtol(addr + pos, NULL, 10);
    }
    if ((u_long)retAddr >= m_areaSize)
    {
        return ACTION_END;
    }
    return retAddr;
}

//------------------------------------------------------------------------------
// Open data from virtual memory
//------------------------------------------------------------------------------
int PLCDevice::open(long , long , long , long )
{
    throw runtime_error(ACE_TEXT("PLCDevice::open : not suport method"));
    return 0;
}

//------------------------------------------------------------------------------
// Close data map memory
//------------------------------------------------------------------------------
int PLCDevice::close()
{
    return -1;
}

//------------------------------------------------------------------------------
// Set data to virtual memory
//------------------------------------------------------------------------------
int PLCDevice::setvm(long , size_t , u_short * )
{
    throw runtime_error(ACE_TEXT("PLCDevice::setvm : not suport method"));
    return -1;
}

//------------------------------------------------------------------------------
// Read data from plc memory
//------------------------------------------------------------------------------
int PLCDevice::read(long , size_t , u_short * ) const
{
    throw runtime_error(ACE_TEXT("PLCDevice::read : not suport method"));
    return -1;
}

//------------------------------------------------------------------------------
// Write data to plc memory
//------------------------------------------------------------------------------
int PLCDevice::write(long , size_t , u_short * )
{
    throw runtime_error(ACE_TEXT("PLCDevice::write : not suport method"));
    return -1;
}

//------------------------------------------------------------------------------
// Get a datum from plc memory
//------------------------------------------------------------------------------
u_short PLCDevice::get(long ) const
{
    throw runtime_error(ACE_TEXT("PLCDevice::get : not suport method"));
    return 0xFFFF;
}

//------------------------------------------------------------------------------
// Put a datum to plc memory
//------------------------------------------------------------------------------
int PLCDevice::put(long , u_short )
{
    throw runtime_error(ACE_TEXT("PLCDevice::put : not suport method"));
    return -1;
}

//------------------------------------------------------------------------------
// Get a datum from virtual memory
//------------------------------------------------------------------------------
u_short PLCDevice::vmget(long ) const
{
    throw runtime_error(ACE_TEXT("PLCDevice::vmget : not suport method"));
    return 0xFFFF;
}

//------------------------------------------------------------------------------
// Read data from virtual memory
//------------------------------------------------------------------------------
int PLCDevice::vmread(long , size_t , u_short * ) const
{
    throw runtime_error(ACE_TEXT("PLCDevice::vmread : not suport method"));
    return -1;
}


//------------------------------------------------------------------------------
// Dump logical memory
//------------------------------------------------------------------------------
void PLCDevice::dump(long , size_t ) const
{
    throw runtime_error(ACE_TEXT("PLCDevice::dump : not suport method"));
}


