// $Id: tclmelsvr.cpp,v 1.3 2002/09/08 12:32:07 fukasawa Exp $

// ============================================================================
//
// = LIBRARY
//     tclmelsvr
//
// = FILENAME
//     tclmelsvr.cpp
//
// = AUTHOR(S)
//     Fukasawa Mitsuo
//
// = COPYRIGHT
//     Copyright (c) 2001-2002 by BEE Co.,Ltd.  All rights reserved.
//
//     This file is part of the tclgxml that can be used free.
//     The tclgxml and this file are covered by the GNU Lesser General Public
//     License, which should be included with libxml++ as the file COPYING.
//
// ============================================================================

#include "ace/ACE.h"
#include "ace/Log_Msg.h"

#ifdef _MSC_VER
#pragma warning(disable: 4786)  // too long identifier
#include <windows.h>
#endif

#include "tcl.h"

#define EQUALSTR(s, c)      ((*s == *c) && (strcmp(s, c) == 0))
#define TCLMELSVR_VERSION   "1.0"
/*
 * Function prototype
 */
extern "C" {
DLLEXPORT int Melsvr_Init (Tcl_Interp *interp);
DLLEXPORT int Melsvr_SafeInit (Tcl_Interp *interp);
}

extern int Melsvr_initCmd(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Melsvr_openCmd(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Melsvr_closeCmd(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Melsvr_eventCmd(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);

// ACE Objects
ACE_Object_Manager ace_object_manager;

static void
Melsvr_InterpDeleteProc (ClientData clientData, Tcl_Interp *interp)
{
    ;
}

/*
 *  This procedure performs application-specific initialization.
 *  Most applications, especially those that incorporate additional
 *  packages, will have their own version of this procedure.
 *
 * Results:
 *  Returns a standard Tcl completion code, and leaves an error
 *  message in interp->result if an error occurs.
 *
 * Side effects:
 *  Depends on the startup script.
 */
DLLEXPORT int
Melsvr_Init (Tcl_Interp *interp)
{
#ifdef USE_TCL_STUBS
    if (Tcl_InitStubs(interp, "8.0", 0) == NULL) {
        return TCL_ERROR;
    }
#endif

    ACE_LOG_MSG->open("Melsvr", ACE_Log_Msg::LOGGER, ACE_DEFAULT_LOGGER_KEY);

    Tcl_CallWhenDeleted(interp, Melsvr_InterpDeleteProc, 0);

    // Create additional commands.
    Tcl_CreateObjCommand(interp, "melsvr::init", Melsvr_initCmd,
        (ClientData)0, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp, "melsvr::open", Melsvr_openCmd,
        (ClientData)0, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp,  "melsvr::close", Melsvr_closeCmd,
        (ClientData)0, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp,  "melsvr::event", Melsvr_eventCmd,
        (ClientData)0, (Tcl_CmdDeleteProc *)0);

    return Tcl_PkgProvide(interp, "melsvr", TCLMELSVR_VERSION);
}

/*
 *  This procedure initializes commands for a safe interpreter.
 *  You would leave out of this procedure any commands you deemed unsafe.
 *
 * Results:
 *  A standard Tcl result.
 *
 * Side effects:
 *  None.
 */
DLLEXPORT int
Melsvr_SafeInit (Tcl_Interp *interp)
{
#ifdef USE_TCL_STUBS
    if (Tcl_InitStubs(interp, "8.0", 0) == NULL) {
        return TCL_ERROR;
    }
#endif

    return Tcl_PkgProvide(interp, "melsvr", TCLMELSVR_VERSION);
}
