// $Id: DBVariableElm.h,v 1.7 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBVariableElm.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef DBVARIABLEELM_H
#define DBVARIABLEELM_H

#include "dbio.h"
#include "JGVariable.h"

class JGEquipment;

 // Define an object to hold our row data -- used by all single table examples
class BEE_Export DBVariableElm : public JGVariable
{
public:
    DBVariableElm() : JGVariable() {}
    DBVariableElm(const JGVariable& rhs) : JGVariable(rhs) {}
    DBVariableElm& operator=(const JGVariable& rhs) {
            if (this == &rhs) return *this;
            *((JGVariable *)this) = rhs;
            return *this;
        }

    int strToAttrs() {
        int result;
        result = m_initval.set(m_initvalStr, m_valtype);
        if (result < 0)
            return BEE_ERROR;
        result = m_maxval.set(m_maxvalStr, m_valtype);
        if (result < 0)
            return BEE_ERROR;
        result = m_minval.set(m_minvalStr, m_valtype);
        if (result < 0)
            return BEE_ERROR;
        return BEE_SUCCESS;
    }

    friend class dtl::DefaultBCA<DBVariableElm>;
    friend class dtl::DefaultInsValidate<DBVariableElm>;
    friend class dtl::DefaultSelValidate<DBVariableElm>;
    friend class UPDVariableElm;

    friend bool operator<(const DBVariableElm &val1, const DBVariableElm &val2)
    {
        return (val1.m_vidStr < val2.m_vidStr);
    }

    static void load(JGEquipment * equip);
    static void save(JGEquipment * equip);
    static int  update(JGEquipment * equip, JGid& vid);
    int  formdb();

protected:
    string m_vidStr;
    string m_ecsvidStr;
    string m_enabledStr;
    string m_initvalStr;
    string m_minvalStr;
    string m_maxvalStr;
    string m_iodevStr;
    string m_subsystem;
    string m_limitStr;
    string m_saveStr;
    string m_objtypeStr;
    string m_attrStr;

};

// Updata element
class UPDVariableElm
{
public:
    void operator()(BoundIOs &boundIOs, DBVariableElm &rowbuf)
    {
        boundIOs[_TX("INIT_VAL")] == rowbuf.m_initvalStr;
    }
};

// Create an association between table columns and fields in our object
// Here, BoundIOs is a class that is passed in to store column names &
// mappings

BEGIN_DTL_NAMESPACE

template<> class DefaultBCA<DBVariableElm>
{
public:
    void operator()(BoundIOs &cols, DBVariableElm &row)
    {
        cols[_TX("VID")] == row.m_vidStr;
        cols[_TX("ECSV_ID")] == row.m_ecsvidStr;
        cols[_TX("NAME")] == row.m_name;
        cols[_TX("CLASS")] == row.m_class;
        cols[_TX("VALTYPE")] == row.m_valtype;
        cols[_TX("SIZE")] == row.m_size;
        cols[_TX("VALUE")] == row.m_value;
        cols[_TX("INIT_VAL")] == row.m_initvalStr;
        cols[_TX("MIN_VAL")] == row.m_minvalStr;
        cols[_TX("MAX_VAL")] == row.m_maxvalStr;
        cols[_TX("UNIT")] == row.m_unit;
        cols[_TX("ITEM_NAME")] == row.m_itemname;
        cols[_TX("OBJTYPE")] == row.m_objtypeStr;
        cols[_TX("ATTRIBUTE")] == row.m_attrStr;
        cols[_TX("SUBSTANTIATOR")] == row.m_func;
        cols[_TX("LIMIT_ENABLED")] == row.m_limitStr;
        cols[_TX("TRIGGER")] == row.m_trgid;
        cols[_TX("IODEV_ID")] == row.m_iodevStr;
        cols[_TX("IODEV_OFFSET")] == row.m_offset;
        cols[_TX("ENABLED")] == row.m_enabledStr;
        cols[_TX("SAVED")] == row.m_saveStr;
    }
};

// Specialization of DefaultInsValidate for DBVariableElm
// This defines a business rule we wish to enforce for all
// DBVariableElm objects before they are allowed to be inserted into
// the database
template<> class DefaultInsValidate<DBVariableElm>
{
public:
    bool operator()(BoundIOs &boundIOs, DBVariableElm &rowbuf) {
        // data is valid if rowbuf.m_vid is nonempty and
        // rowbuf.n_name is nonempty and rowbuf.n_valtype is
        // between 0 and 3 (v, sv, ec, dvval)
        //return (rowbuf.m_vidStr.length() > 0 && rowbuf.m_name.length() > 0 &&
        //        rowbuf.m_valtype >= 0 && rowbuf.m_valtype  <= 3);
        return true;
    }
};

template<> class DefaultSelValidate<DBVariableElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBVariableElm &rowbuf) {
        return true;
    }
};

// Parameter for update
template<> class DefaultParamObj<DBVariableElm>
{
public:
    string m_vidStr;
};

template<> class DefaultBPA<DefaultParamObj<DBVariableElm> >
{
public:
    void operator()(BoundIOs &boundIOs, DefaultParamObj<DBVariableElm> &paramObj)
    {
      boundIOs[0] == paramObj.m_vidStr;
    }
};

END_DTL_NAMESPACE

#endif  /* DBVARIABLEELM_H */
