// $Id: DBSubSystemElm.h,v 1.3 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBSubSystemElm.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef DBSUBSYSTEMELM_H
#define DBSUBSYSTEMELM_H

#include "dbio.h"
#include "JGSubSystem.h"

// Define an object to hold configure data
class DBSubSystemElm : public JGSubSystem
{
public:
    DBSubSystemElm() : JGSubSystem(), m_sysname(""), m_objspec(""),
                       m_subtypeStr(""), m_matetype(0) {}

    friend class dtl::DefaultBCA<DBSubSystemElm>;
    friend class dtl::DefaultInsValidate<DBSubSystemElm>;
    friend class dtl::DefaultSelValidate<DBSubSystemElm>;

    friend bool operator<(const DBSubSystemElm &val1, const DBSubSystemElm &val2)
    {
        return (val1.m_subidStr < val2.m_subidStr);
    }

    static void load(JGEquipment * equip);

protected:
    string m_subidStr;
    string m_locidStr;
    string m_sysname;
    string m_objspec;
    string m_subtypeStr;
    int    m_matetype;
};

// Create an association between table columns and fields in our object
// Here, BoundIOs is a class that is passed in to store column names &
// mappings

BEGIN_DTL_NAMESPACE

template<> class DefaultBCA<DBSubSystemElm>
{
public:
    void operator()(BoundIOs &cols, DBSubSystemElm &row)
    {
        cols["SUBSYS_ID"] == row.m_subidStr;
        cols["LOC_ID"] == row.m_locidStr;
        cols["SUBSYS_TYPE"] == row.m_subtypeStr;
        cols["SUBSYS_NAME"] == row.m_sysname;
        cols["OBJSPEC"] == row.m_objspec;
        cols["RELOC_NUM"] == row.m_relocNum;
        cols["MATERIAL_TYPE"] == row.m_matetype;
    }
};

// Specialization of DefaultInsValidate for DBSubSystemElm
// This defines a business rule we wish to enforce for all
// DBSubSystemElm objects before they are allowed to be inserted into the database
template<> class DefaultInsValidate<DBSubSystemElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBSubSystemElm &rowbuf) {
        // data is valid if rowbuf.m_name is nonempty and
        // rowbuf.m_category is nonempty
        return (rowbuf.m_subidStr.length() > 0);
    }
};

template<> class DefaultSelValidate<DBSubSystemElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBSubSystemElm &rowbuf) {
        return true;
    }
};


END_DTL_NAMESPACE

#endif  /* DBSUBSYSTEMELM_H */
