// $Id: DBReportElm.cpp,v 1.4 2003/02/28 14:44:50 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBReportElm.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGEquipment.h"
#include "JGInfoManager.h"
#include "JGEventManager.h"
#include "dbio/DBReportElm.h"

//-----------------------------------------------------------------------------
// Load from data.
//-----------------------------------------------------------------------------
void DBReportElm::load(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBReportElm::load");

    JGEventManager * eventManager =
                        (JGEventManager *)equip->findManager(CATEGORY_EVENT);
    JGReportTable * report_tbl = eventManager->reportTable();
    DBView<DBReportElm> view(_TX("G_REPORT"));

    DBView<DBReportElm>::select_iterator read_it = view.begin();
    for ( ; read_it != view.end(); ++read_it)
    {
        DBReportElm * report = (DBReportElm *)(&(*read_it));
        JGid id(report->m_rptidStr);
        report->rptid(id);
        report_tbl->insert(JGReportPair(id, *read_it));
    }

    return ;
}

//-----------------------------------------------------------------------------
// Save data.
//-----------------------------------------------------------------------------
void DBReportElm::save(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBReportElm::save");

    DBStmt(_TX("TRUNCATE TABLE G_REPORT")).Execute();

    JGEventManager * eventManager =
                        (JGEventManager *)equip->findManager(CATEGORY_EVENT);
    JGReportTable * report_tbl = eventManager->reportTable();
    DBView<DBReportElm> view(_TX("G_REPORT"));
    DBView<DBReportElm>::insert_iterator write_it = view;

    JGReportTable::iterator rpt_it = report_tbl->begin();
    for ( ; rpt_it != report_tbl->end(); rpt_it++)
    {
        JGReport * report = (JGReport *)(&(*rpt_it).second);
        DBReportElm rptElm = *report;
        rptElm.formdb();       // Format data of database
        *write_it = rptElm;
        write_it++;
    }

    return ;
}

//-----------------------------------------------------------------------------
// Format data.
//-----------------------------------------------------------------------------
int DBReportElm::formdb()
{
    TRACE_FUNCTION(TRL_LOW, "DBReportElm::formdb");

    m_id.get(m_rptidStr);
    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Load from data.
//-----------------------------------------------------------------------------
void DBRptDataElm::load(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBRptDataElm::load");

    JGInfoManager * infoManager =
                        (JGInfoManager *)equip->findManager(CATEGORY_INFO);
    JGEventManager * eventManager =
                        (JGEventManager *)equip->findManager(CATEGORY_EVENT);
    JGReportTable * report_tbl = eventManager->reportTable();
    JGVarNameTable * var_tbl = infoManager->nameTable();

    DBView<DBRptDataElm> view(_TX("G_RPT_DATA"));

    // Convert ASCII data.
    DBView<DBRptDataElm>::select_iterator read_it = view.begin();
    for ( ; read_it != view.end(); ++read_it)
    {
        DBRptDataElm * rptdata = (DBRptDataElm *)(&(*read_it));
        JGid rptid(rptdata->m_rptidStr);
        rptdata->rptid(rptid);
        string vname = rptdata->m_vidStr;
        JGid vid(vname);
        rptdata->vid(vid);
        JGReportTable::iterator rpt_it = report_tbl->find(rptid);
        JGVarNameTable::iterator var_it = var_tbl->find(vname);
        if (rpt_it != report_tbl->end() && var_it != var_tbl->end())
        {
            // append variable
            JGReport * rpt = &((*rpt_it).second);
            JGVariable * var = (*var_it).second;
            rpt->insert(var);
        }
        else
        {
            TRACE_ERROR((_TX("Unliked variable %s %s\n"),
                         rptdata->rptid().toString().c_str(),
                         rptdata->vid().toString().c_str()));
        }
    }
    return ;
}

//-----------------------------------------------------------------------------
// Save data.
//-----------------------------------------------------------------------------
void DBRptDataElm::save(JGEquipment * equip)
{
    TRACE_FUNCTION(TRL_LOW, "DBRptDataElm::save");

    DBStmt(_TX("TRUNCATE TABLE G_RPT_DATA")).Execute();

    JGEventManager * eventManager =
                        (JGEventManager *)equip->findManager(CATEGORY_EVENT);
    JGReportTable * report_tbl = eventManager->reportTable();
    DBView<DBRptDataElm> view(_TX("G_RPT_DATA"));
    DBView<DBRptDataElm>::insert_iterator write_it = view;;

    JGReportTable::iterator rpt_it = report_tbl->begin();
    for ( ; rpt_it != report_tbl->end(); rpt_it++)
    {
        JGReport * report = (JGReport *)(&(*rpt_it).second);
        string rptid;
        report->rptid().get(rptid);
        JGVariables vids = report->vids();
        for (size_t i = 0; i < vids.size(); i++)
        {
            JGid vid(vids[i]->vid());
            DBRptDataElm rptdataElm;
            rptdataElm.m_rptidStr = rptid;
            vid.get(rptdataElm.m_vidStr);
            rptdataElm.m_seqnum = i + 1;
            *write_it = rptdataElm;
            write_it++;
        }
    }

    return ;
}

