// $Id: JGRecipeManager.h,v 1.10 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGRecipeManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGRECIPEMANAGER_H
#define JGRECIPEMANAGER_H

#include "JGServiceManager.h"
#include "JGRecipe.h"

class JGRecipeClass;
class JGSpecification;
class BS2Message;
class BS2Item;


/*
 * Recipe Manager Class
 */
class JGRecipeManager: public JGServiceManager
{
    friend class RecipeNotify;

public:
    enum { DELETE_ = 0, DESELECT = 1 };

public:
    JGRecipeManager();
    ~JGRecipeManager();

    virtual int init(void * = 0);
    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);
    virtual int notify(const string& category, JGVariable * var,
                       void * arg = NULL);
    virtual int notify(JGTrigger * command);

    JGRecipe * find(const string& rcpName) {
            JGid rcpid(rcpName);
            return this->find(rcpid);
        }
    JGRecipe * find(JGid& rcpid);
    int erase(JGid& rcpid);

    static JGRecipeManager * instance();

protected:
    BS2Message * remove(BS2Message * msg);
    BS2Message * unload(BS2Message * msg);
    BS2Message * download(BS2Message * msg);
    BS2Message * verify(BS2Message * msg);

    int entry(JGRecipe * recipe);

private:
    JGVariable *  m_changed;         // RcpChangeName
    JGVariable *  m_chgStatus;       // RcpChangeStatus
    JGVariable *  m_exec;            // RcpExecName

    JGRecipeClass * m_rcptype;       // Recipe creator
    JGRecipeTable   m_recipes;
    JGSpecification * m_env;
};


#endif
