// $Id: JGLimitManager.h,v 1.3 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGLimitManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGLIMITMANAGER_H
#define JGLIMITMANAGER_H

#include "JGManager.h"
#include "JGLimit.h"
#include "JGDefineTrigger.h"

/*
 * Limit Manager Class
 */
class JGLimitManager: public JGManager
{
public:
    JGLimitManager();
    ~JGLimitManager();

    virtual int init(void * = 0);
    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);
    virtual int device_svc(JGDeviceTrigger * trigger);
    virtual int notify(const string& category, JGVariable * var,
                       void * arg = NULL);

    JGLimitTable * limitTable() { return &m_limits; }
    JGLimitTable * validTable() { return &m_validLimits; }

    JGLimit * entry(JGid& vid);   // set limit into active table
    int       remove(JGid& vid);  // remove limit from active table
    BS2Message * defineLimit(BS2Message * s2f45);
    BS2Message * requestLimit(BS2Message * s2f47);

    int monitor();   // Monitor limit variables
    static JGLimitManager * instance();

private:
    int linkBorder(int = 0);
    JGLimit * find(JGid& vid);
    JGLimit * getValidLimit(JGid& vid);
    static int parseS2F45(void * clientData, BS2Item * item);
    int checkLimitAttributes(BS2ListItem * baselist, JGLimitArray& liminfo);
    int updateLimitAttributes(JGLimitArray& liminfo);
//
private:
    JGLimitTable m_validLimits;         // Limit data from DB
    JGLimitTable m_limits;              // active
    ACE_Thread_Mutex m_lock;

};


#endif
