// $Id: JGLimitBorder.cpp,v 1.4 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGLimitBorder.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGLimit.h"
#include "JGLimitManager.h"
#include "JGVariable.h"
#include "BS2ListItem.h"
#include "BS2DeclAtoms.h"

//-----------------------------------------------------------------------------
// Copy
//-----------------------------------------------------------------------------
JGLimitBorder& JGLimitBorder::operator=(const JGLimitBorder& rhs)
{
    TRACE_FUNCTION(TRL_LOW, "JGLimitBorder::operator=");
    if (this == &rhs)
        return *this;
    m_vid = rhs.m_vid;
    m_limid = rhs.m_limid;
    m_enabled = rhs.m_enabled;
    m_upval = rhs.m_upval;
    m_lowval = rhs.m_lowval;
    return *this;
    m_lastTransition = rhs.m_lastTransition;
}

//-----------------------------------------------------------------------------
// Check limit zone transition.
//-----------------------------------------------------------------------------
BS2Item * JGLimitBorder::attributeItem()
{
    TRACE_FUNCTION(TRL_LOW, "JGLimitBorder::attributeItem");
    BS2Item * item;

    BS2ListItem * listitem = new BS2ListItem();
    item = BS2Item::factory(_TX("LIMITID"), new BS2Binary((BYTE)m_limid));
    listitem->add(item);

    item = BS2Item::factory(_TX("UPPERDB"), m_upval);
    listitem->add(item);

    item = BS2Item::factory(_TX("LOWERDB"), m_lowval);
    listitem->add(item);

    return listitem;
}

//-----------------------------------------------------------------------------
// Check limit zone transition.
//-----------------------------------------------------------------------------
enum { ZONE_NONE, ZONE_UPPER, ZONE_DEADBAND, ZONE_LOWER };

int JGLimitBorder::transition(JGvalue& last, JGvalue& current)
{
    TRACE_FUNCTION(TRL_LOW, "JGLimitBorder::transition");
    int result = JGLimit::TRANSITION_NONE;
    int current_position, last_position;

    if (! (last.format() == ATOM_UINT4 || last.format() == ATOM_INT4 ||
           last.format() == ATOM_UINT2 || last.format() == ATOM_INT2 ||
           last.format() == ATOM_UINT1 || last.format() == ATOM_INT1 ||
           last.format() == ATOM_UINT8 || last.format() == ATOM_INT8 ||
           last.format() == ATOM_FLOAT8 || last.format() == ATOM_FLOAT4 ||
           last.format() == ATOM_BOOLEAN))
    {
        TRACE_DEBUG((_TX("illegal data format (0x%x).\n"), last.format()));
    }

    if (last.format() != m_upval.format())
    {
        TRACE_DEBUG((_TX("differet data format (0x%x/0x%x).\n"),
                     last.format(), m_upval.format()));
    }

    //          ZONE_UPPER
    //         (upper zone)
    //
    // ----------+             <-- UPPERDB
    //           |                (m_upval)
    //           | 
    //     ZONE_DEADBAND 
    //      (DeadBand) 
    //           |
    //           |
    //           +----------   <-- LOWERDB
    //                            (m_lowval)
    //      ZONE_LOWER
    //     (lower zone)

    // Detect last position
    if (m_lastTransition == JGLimit::TRANSITION_UPPER && m_lowval < last)
    {
        last_position = ZONE_UPPER;
    }
    else if (m_lastTransition == JGLimit::TRANSITION_LOWER && last < m_upval)
    {
        last_position = ZONE_LOWER;
    }
    else
    {
        last_position = ZONE_NONE;
    }

    // Detect current position
    if (m_upval < current || m_upval == current)
    {   // upper zone
        current_position = ZONE_UPPER;
    }
    else if (current < m_lowval || current == m_lowval)
    {    // lower zone
        current_position = ZONE_LOWER;
    }
    else
    {    // border
        current_position = ZONE_DEADBAND;
    }

    // Check transition
    if (last_position == ZONE_LOWER && current_position == ZONE_UPPER)
    {
        result = m_lastTransition = JGLimit::TRANSITION_UPPER;
    }
    else if (last_position == ZONE_UPPER && current_position == ZONE_LOWER)
    {
        result = m_lastTransition = JGLimit::TRANSITION_LOWER;
    }
    else if (last_position == ZONE_NONE && current_position == ZONE_UPPER)
    {
        if (last < m_lowval || last == m_lowval)
        {
            result = m_lastTransition = JGLimit::TRANSITION_UPPER;
        }
    }
    else if (last_position == ZONE_NONE && current_position == ZONE_LOWER)
    {
        if (m_upval < last || last == m_upval)
        {
            result = m_lastTransition = JGLimit::TRANSITION_LOWER;
        }
    }
    return result;
}

