// $Id: JGEquipment.h,v 1.4 2003/02/16 17:04:53 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGEquipment.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================


#ifndef JGEQUIPMENT_H
#define JGEQUIPMENT_H

#include "JGManager.h"
#include "ace/DLL.h"

// Forward declaration
class PLCDeviceManager;
class Arams;
class JGInfoManager;
class JGAlarmManager;
class JGCommManager;
class JGControlManager;
class JGEventManager;
class JGIODevManager;
class JGLimitManager;
class JGProcessManager;
class JGSpoolManager;
class JGTerminalManager;
class JGTraceManager;
class JGAccessManager;
class JGTimeModule;
class JGObjectManager;
class JGResourceManager;
class JGRecipeManager;
class JGProcProgManager;

#ifdef GEM300
class JGMaterialManager;
class JGMateIOManager;
#else
class JGMateMoveManager;
#endif

class JGVariable;

//-----------------------------------------------------------------------------
//
// Equipment Object
//
//-----------------------------------------------------------------------------
class BEE_Export JGEquipment: public JGManager
{
    enum { INITIALIZE, ACTIVE, STOPPING };   // m_status code

public:
    JGEquipment();
    ~JGEquipment();

    virtual bool isCommunicating() const;
    virtual bool isOnline() const;
    virtual bool isSpooling() const;
    virtual int  spool(BS2Message * msg);
    virtual int  communicating();
    virtual int  notCommunicating();
    virtual JGManager * findManager(const string& mngrName);
    virtual int getClock(struct tm& rettm);
    virtual int setClock(struct tm& newtm);

    virtual int svc(void);
    virtual int init(void * = 0);

    int  load(void * = 0);
    int  save(void * = 0);
    int  start_comm(u_long = 0);
    int  stop(u_long = 0);

    void setDSNName(const string& name) { m_dsn = name; }
    void setPLCName(const string& name) { m_plcName = name; }
    PLCDeviceManager * getPLCManager()    { return m_plc_mngr; }
    JGEventManager *   getEventManager()  { return m_event_mngr; }
    JGAlarmManager *   getAlarmManager()  { return m_alarm_mngr; }
    JGObjectManager *  getObjectManager() { return m_obj_mngr; }
    JGInfoManager *    getInfoManager()   { return m_info_mngr; }
    JGProcessManager * getProcessManager(int modNum = 0);

    const string& rootDirectory() const { return m_rootPath; }

    int  getIdType();
    const string& getConf(const string& pname);
    const string& getConf(const BCHAR * pname) {
            string nameStr = pname;
            return this->getConf(nameStr);
        }
    JGVariable * variable(const string& vname);
    JGVariable * variable(const BCHAR * vname) {
            string nameStr = vname;
            return this->variable(nameStr);
        }
    JGVariable * variable(const JGid& vid);
    JGvalue&  value(const string& vname);
    JGvalue&  value(const BCHAR * vname) {
            string nameStr = vname;
            return this->value(nameStr);
        }
    JGvalue&  value(const JGid& vid);
    int sendEvent(JGManager * mngr, const string& evt, JGVariable * arg = NULL);

    void dump() const;
//
    static JGEquipment * instance();
    static JGEquipment * instance(JGEquipment * app);
//
protected:
    int  init_log(u_long parm = 0);
    int  act_managers(JGCommDevice * devptr);
    int  stop_managers(u_long parm = 0);
    JGCommDevice * initDevice();

protected:
    string    m_dsn;
    string    m_plcName;
    string    m_rootPath;
    MUTEX_Int m_status;
    vector<JGManager *> m_managers;
    ACE_DLL   m_dll;

    PLCDeviceManager *  m_plc_mngr;

    JGInfoManager *     m_info_mngr;
    Arams *             m_arams;
    JGAlarmManager *    m_alarm_mngr;
    JGCommManager *     m_comm_mngr;
    JGControlManager *  m_control_mngr;
    JGEventManager *    m_event_mngr;
    JGSpoolManager *    m_spool_mngr;
    JGLimitManager *    m_limit_mngr;
    JGProcessManager *  m_process_mngr;
    JGTerminalManager * m_terminal_mngr;
    JGTraceManager *    m_trace_mngr;
    JGAccessManager *   m_rcmd_mngr;
    JGIODevManager *    m_iodev_mngr;
    JGObjectManager *   m_obj_mngr;
    JGResourceManager * m_resource_mngr;
    JGRecipeManager *   m_recipe_mngr;
    JGProcProgManager * m_pp_mngr;
#ifdef GEM300
    JGMaterialManager * m_material_mngr;
    JGMateIOManager *   m_mateio_mngr;
#else
    JGMateMoveManager * m_matemove_mngr;
#endif

    JGTimeModule *      m_systime;

    JGVariable *        m_pcReady;
};

#endif
