// $Id: JGEnumSub.cpp,v 1.5 2003/02/15 04:18:10 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGEnumSub.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGEnumSub.h"
#include "JGVariable.h"
#include "JGManager.h"

extern int parseEnumNames(const string& enames, vector<string>& retvec);

//-----------------------------------------------------------------------------
//
// Enumerate Base
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// Copy
//-----------------------------------------------------------------------------
JGEnumSubBase& JGEnumSubBase::operator=(const JGEnumSubBase& rhs)
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGEnumSubBase::operator=");
    if (this == &rhs)
        return *this;
    (JGTriggerSubject&)(*this) = rhs;
    m_enumNames = rhs.m_enumNames;
    return *this;
}

//-----------------------------------------------------------------------------
// Parse enumerate token
//-----------------------------------------------------------------------------
int JGEnumSubBase::parse()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGEnumSubBase::parse");
    int result = ::parseEnumNames(m_trgName, m_enumNames);
    if (result < 0)
    {
        TRACE_ERROR((_TX("Illegal enumurate tokens(%s).\n"),
                     m_trgName.c_str()));
    }
    return result;
}

//-----------------------------------------------------------------------------
// Factory
//-----------------------------------------------------------------------------
JGTriggerInfo * JGEnumSubBase::factory()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGEnumSubBase::factory");
    JGEnumSub * result = new JGEnumSub(this);
    return result;
}

//-----------------------------------------------------------------------------
//
// Enumerate
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// Initial
//-----------------------------------------------------------------------------
int JGEnumSub::init()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGEnumSub::init");
    int result = this->JGTriggerInfo::init();
    return result;
}

//-----------------------------------------------------------------------------
// As changed, issue trigger.
//-----------------------------------------------------------------------------
int JGEnumSub::changed()
{
    TRACE_FUNCTION(TRL_LOW, "JGEnumSub::changed");

    int pos = m_var->curval().getInt();
    if (pos >= m_subject->range())
    {
        TRACE_ERROR((_TX("Illegal enumurate token(%s).\n"),
                     m_var->curval().toString().c_str()));
        return BEE_ERROR;
    }
    if (m_subject->enumerate(pos) == _TX("UNKNOWN"))
    {   // As ignore code, does not issue trigger
        return BEE_SUCCESS;
    }
    m_subject->manager()->notify(m_subject->enumerate(pos),
                                 m_var, NULL);

    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
//
// Enumerate Base
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// Copy
//-----------------------------------------------------------------------------
JGEnumParmSubBase& JGEnumParmSubBase::operator=(const JGEnumParmSubBase& rhs)
{
    TRACE_FUNCTION(TRL_LOW, "JGEnumParmSub::operator=");
    if (this == &rhs)
        return *this;
    (JGEnumSubBase&)(*this) = rhs;
    m_relation = rhs.m_relation;
    return *this;
}

//-----------------------------------------------------------------------------
// Factory
//-----------------------------------------------------------------------------
JGTriggerInfo * JGEnumParmSubBase::factory()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGEnumParmSubBase::factory");
    JGEnumParmSub * result = new JGEnumParmSub(this);
    return result;
}

//-----------------------------------------------------------------------------
//
// Enumerate with parameter
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// Initial
//-----------------------------------------------------------------------------
int JGEnumParmSub::init()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGEnumParmSub::init");
    return this->JGTriggerInfo::init();
}

//-----------------------------------------------------------------------------
// As changed, issue trigger.
//-----------------------------------------------------------------------------
int JGEnumParmSub::changed()
{
    TRACE_FUNCTION(TRL_LOW, "JGEnumParmSub::changed");

    int pos = m_var->curval().getInt();
    BS2Assert(pos < m_subject->range());
    if (m_subject->enumerate(pos) == _TX("UNKNOWN"))
    {   // As ignore code, does not issue trigger
        return BEE_SUCCESS;
    }
    m_subject->manager()->notify(m_subject->enumerate(pos),
                                 m_subject->relation(), NULL);

    return BEE_SUCCESS;
}


