// $Id: JGCommManager.h,v 1.5 2003/02/28 14:44:50 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGCommManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGCOMMMANAGER_H
#define JGCOMMMANAGER_H

#include "JGManager.h"
#include "BS2TimeValue.h"

#define TRIGGER_OPE_DISABLE          _TX("DISABLE")
#define TRIGGER_OPE_ENABLE           _TX("ENABLE")
#define TRIGGER_TRANSACTION_FAIL     _TX("TRANSACTION_FAILURE")
#define TRIGGER_NOT_CONFIRM_MESSAAGE _TX("NOT_CONFIRM_MESSAGE")
#define TRIGGER_S1F13                _TX("S1F13")
#define TRIGGER_S1F14                _TX("S1F14")
#define TRIGGER_COMMUNICATING        _TX("COMMUNICATING")
#define TRIGGER_NOT_COMMUNICATING    _TX("NOT_COMMUNICATING")
#define TRIGGER_COMMUNICATION_FAIL   _TX("COMMUNICATION_FAIL")

class JGVariable;
class BS2Message;
class BS2ListItem;

/*
 * Communication Manager Class
 */
class BEE_Export JGCommManager : public JGManager
{
public:
    enum { DISABLE = 0, ENABLE = 1 };
    enum { NOT_COMMUNICATING = 0, COMMUNICATING = 1 };

    friend class JGCommState;

public:
    JGCommManager();
    virtual ~JGCommManager() {}

    virtual int init(void * param = 0);
    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);
    virtual int device_svc(JGDeviceTrigger * trigger);  // trigger from I/O devices

    bool isReadyDriver() const;
    bool isCommunicating();
    int  enable()  { return this->changeCommunicating(true); }
    int  disable() { return this->changeCommunicating(false); }
    int  finish();

    static JGCommManager * instance();

private:
    int sendS1F13();            // Establish Communication Request
                                // Establish Communication Request Acknowledge
    int sendS1F14(const BS2Message * primsg, int ack = 0);
    int changeCommunicating(bool flag);
    BS2ListItem * makeEquipModel();  // MDLN & SOFTREV
    bool checkMdlnAndSoftrev(BS2Message * msg);

private:
    JGVariable * m_sysdefault;    // Communications State System Default
    JGVariable * m_commsel;       // Communications State Selector
    JGVariable * m_commstate ;    // Communications State
    JGVariable * m_estime;        // Establish Communications Timeout
    BS2TimeValue m_commdelay;     // Communication Delay Timer (sec)

    JGCommState * m_commState;    // State Model
};


#endif
