// $Id: JGAttribute.h,v 1.7 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGAttribute.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGATTRIBUTE_H
#define JGATTRIBUTE_H

#include "ecm.h"

class JGClass;
class JGObject;
class JGStruct;
class JGAttrData;

//
// Attribute of Class
//
class BEE_Export JGAttribute : public b_attribute
{
public:
    JGAttribute(const BCHAR * name, int type, size_t size = 1,
                int mode = READONLY) : b_attribute(name, type, size, mode) {}
    JGAttribute(JGClass& clazz, const BCHAR * name, int type, size_t size);
    virtual ~JGAttribute() {}
    virtual void dump() const;

    // Create Instance
    virtual b_attrdata * instance(const b_object * obj) const;

// Member variables
protected:
    JGAttribute() : b_attribute() {}
};

//
// Vector
//
class BEE_Export JGVector : public JGAttribute
{
public:
    JGVector(const BCHAR * name, JGAttribute * attr, size_t q = 0,
             int mode = READONLY);
    JGVector(JGClass& cls, const BCHAR * name, JGAttribute * attr,
             size_t q = 0, int mode = READONLY);
    JGVector(JGStruct& stt, const BCHAR * name, JGAttribute * attr,
             size_t q = 0, int mode = READONLY);
    virtual ~JGVector() {}
    virtual void dump() const;

    // Create Instance
    virtual b_attrdata * instance(const b_object * obj) const;

    // Get value
    virtual const JGvalue& getInitVal() const { return m_init; }

    JGAttribute * member() const { return reinterpret_cast<JGAttribute *>(m_attrs[0]); }

//
protected:
};

//
// Struct
//
class BEE_Export JGStruct : public JGAttribute
{
    friend class JGObject;
    friend class JGClass;

public:
    JGStruct(const BCHAR * name) : JGAttribute(name, ATOM_STRUCT, 0, READONLY) {}
    JGStruct(const BCHAR * name, int mode) : JGAttribute(name, ATOM_STRUCT, 0, mode) {}
    JGStruct(JGClass& cls, const BCHAR * name, int mode = READONLY);
    JGStruct(JGStruct& stt, const BCHAR * name, int mode = READONLY);
    virtual ~JGStruct() {}
    virtual void dump() const;

    // Create Instance
    virtual b_attrdata * instance(const b_object * obj) const;

    // Get value
    virtual const JGvalue& getInitVal() const { return m_init; }

    // Add new attribute
    void add(JGAttribute * attr);
    void add(JGAttribute * attrs[]);

    // Get member info
    int length() const { return m_attrs.size(); }
    JGAttribute * at(int idx) const {
            if ((int)m_attrs.size() <= idx)
                return NULL;
            return reinterpret_cast<JGAttribute *>(m_attrs[idx]);
        }

protected:
    JGStruct() : JGAttribute(_TX(""), ATOM_STRUCT, 0) {}

//
protected:

};


#endif  /* JGATTRIBUTE_H */
