// $Id: JGObserver.h,v 1.3 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGObserver.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGOBSERVER_H
#define JGOBSERVER_H

#include "JGTask.h"

//
// Object
//
class BEE_Export JGObserver : public JGTask
{
    class TriggerRequest : public ACE_Method_Request
    {
    public:
        TriggerRequest(JGTrigger * trigger, JGObserver * observer = NULL)
                : m_observer(observer), m_trigger(trigger) {}
        virtual ~TriggerRequest() {}

        virtual int call();

        void set(JGObserver * observer) { m_observer = observer; }

    protected:
        JGObserver * m_observer;
        JGTrigger *  m_trigger;
    };

public:
    virtual ~JGObserver() {}

    virtual int svc(void);

    virtual int notify(JGTrigger * trigger);

    // virtual int open(void * args = 0);
    // virtual int close(u_long flags = 0);
    // virtual int end(void);

protected:
    friend class TriggerRequest;

    JGObserver(const string& name) : JGTask(name) {}

    virtual int update(JGTrigger * trigger) = 0;

// member variables
protected:

};

#endif  /* JGOBSERVER_H */
