// $Id: JGBitVector.cpp,v 1.5 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGBitVector.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGBitVector.h"

UINT JGBitVector::MaskTable[32] =
{
    0x00000001, 0x00000002, 0x00000004, 0x00000008,
    0x00000010, 0x00000020, 0x00000040, 0x00000080,
    0x00000100, 0x00000200, 0x00000400, 0x00000800,
    0x00001000, 0x00002000, 0x00004000, 0x00008000,
    0x00010000, 0x00020000, 0x00040000, 0x00080000,
    0x00100000, 0x00200000, 0x00400000, 0x00800000,
    0x01000000, 0x02000000, 0x04000000, 0x08000000,
    0x10000000, 0x20000000, 0x40000000, 0x80000000,
};

//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
JGBitVector::JGBitVector(size_t size)
{
    m_size = size;
    m_table = new UINT[(size + 31) / 32];
    this->clear();
}

//-----------------------------------------------------------------------------
JGBitVector::JGBitVector(size_t size, UINT * bitbuf, bool del)
{
    m_delete = del;
    m_size = size;
    m_table = bitbuf;
}


//-----------------------------------------------------------------------------
JGBitVector::~JGBitVector()
{
    if (m_delete && m_table != NULL)
    {
        delete[] m_table;
    }
}

//-----------------------------------------------------------------------------
// Copy
//-----------------------------------------------------------------------------
void JGBitVector::copy(const JGBitVector& rhs)
{
    m_size = rhs.m_size;
    m_table = new UINT[(m_size + 31) / 32];
    memmove(m_table, rhs.m_table, ((m_size + 31) / 32) * sizeof(UINT));
}

//-----------------------------------------------------------------------------
// Clear
//-----------------------------------------------------------------------------
void JGBitVector::clear()
{
    memset(m_table, 0, ((m_size + 31) / 32) * sizeof(UINT));
}

//-----------------------------------------------------------------------------
// Get bit status by index.
//-----------------------------------------------------------------------------
bool JGBitVector::get(int idx)
{
    if (m_size <= (UINT)idx)
    {
        return false;
    }
    UINT * bitPtr = m_table + (idx / 32);
    UINT maskPattern = JGBitVector::MaskTable[idx % 32];

    return ((*bitPtr & maskPattern) != 0);
}

//-----------------------------------------------------------------------------
// Set bit status by index.
//-----------------------------------------------------------------------------
bool JGBitVector::put(int idx, bool cond)
{
    if (m_size <= (UINT)idx)
    {
        return false;
    }
    UINT * bitPtr = m_table + (idx / 32);
    UINT maskPattern = JGBitVector::MaskTable[idx % 32];

    bool theLast = ((*bitPtr & maskPattern) != 0);
    if (cond)
    {
        *bitPtr |= maskPattern;
    }
    else
    {
        *bitPtr &= ~maskPattern;
    }

    return theLast;
}

//-----------------------------------------------------------------------------
// Search first off bit index.
//-----------------------------------------------------------------------------
int JGBitVector::firstOff()
{
    UINT * bitPtr = m_table;
    int    maxbp = (m_size + 31) / 32;
    int    firstbp = 0;
    for ( ; firstbp < maxbp; firstbp++, bitPtr++)
    {
        if (*(bitPtr + firstbp) != 0xFFFFFFFF)
        {
            break;
        }
    }
    if (firstbp == maxbp)
    {
        return -1;
    }
    int bitnum = 0;
    for ( ; bitnum < 32; bitnum++)
    {
        if (! (*(bitPtr + firstbp) & JGBitVector::MaskTable[bitnum]))
        {
            break;
        }
    }
    //if (bitnum == 32)   // Debug
    //{
    //    ACE_ERROR((LM_ERROR, _TX("JGBitVector::firstOff(): %d %d.\n"),
    //                         firstbp, bitnum));
    //}
    size_t idx = (firstbp * 32) + bitnum;
    if (idx >= m_size)
    {
        return -1;
    }
    return idx;
}

