package org.junitdoc.core.util;

import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;

public class SourcePosition {

	private String name;

	private int startPosition;

	private int length;

	SourcePosition(String name, int startPosition, int length) {
		this.name = name;
		this.startPosition = startPosition;
		this.length = length;
	}

	public static SourcePosition newInstance(AnnotationTypeDeclaration anno) {
		SourcePosition sp = new SourcePosition(anno.getName()
				.getFullyQualifiedName(), anno.getName().getStartPosition(),
				anno.getName().getLength());
		return sp;
	}

	public static SourcePosition newInstance(MethodDeclaration md) {
		SourcePosition sp = new SourcePosition(md.getName()
				.getFullyQualifiedName(), md.getName().getStartPosition(), md
				.getName().getLength());
		return sp;
	}

	public String getName() {
		return name;
	}

	public int getStartPosition() {
		return startPosition;
	}

	public int getLength() {
		return length;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof SourcePosition) {
			SourcePosition target = (SourcePosition) obj;
			return target.getName().equals(getName())
					&& target.getStartPosition() == getStartPosition()
					&& target.getLength() == getLength();
		}
		return super.equals(obj);
	}
}
