/* adin_mic_sp.c --- adin microphone library for spAudio
 * by Hideki Banno */

#include <sp/spAudioLib.h>

#include <sent/stddefs.h>
#include <sent/adin.h>

static spAudio audio = NULL;
static long buffer_length = 256;

static float rate;

/* check audio port resource and initialize */
/* will be called once at startup time */
boolean
adin_mic_standby(int sfreq, void *dummy)
{
  rate = sfreq;
  if (adin_mic_start() == FALSE) return FALSE;
  if (adin_mic_stop() == FALSE) return FALSE;
  return TRUE;
}

/* start recording */
boolean
adin_mic_start()
{
  if (audio == NULL) {
    audio = spInitAudio();
  }
  spSetAudioSampleRate(audio, rate);
  spSetAudioChannel(audio, 1);
  spSetAudioSampleBit(audio, 16);
#ifdef SP_AUDIO_NONBLOCKING
  spSetAudioBlockingMode(audio, SP_AUDIO_NONBLOCKING);
#endif
  
  if (!spOpenAudioDevice(audio, "ro")) {
    j_printerr("Error: adin_mic_sp: spOpenAudioDevice\n");
    return FALSE;
  }
    
  return TRUE;
}

/* stop recording */
boolean
adin_mic_stop()
{
  spCloseAudioDevice(audio);
  return TRUE;
}

/* read samples from audio device */
/* try to read `sampnum' samples and returns actual sample num recorded */
int
adin_mic_read(SP16 *buf, int sampnum)
{
  long nread;

#ifdef SP_AUDIO_NONBLOCKING
  nread = sampnum;
#else
  if (sampnum <= buffer_length) {
      nread = sampnum;
  } else {
      nread = buffer_length;
  }
#endif
  nread = spReadAudio(audio, (short *)buf, nread);
  
  return nread;
}
