#!/usr/bin/perl
#
# extract menu item by "<!-- menuitem STR -->"
#
# usage: makemenu.pl htmlfile...
#
# $Id: makemenu.pl,v 1.6 2002/09/11 21:00:39 ri Exp $

## before menus tag
$pre1 = <<EOM;
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML//EN">
<html> <head>
<meta http-equiv="Content-Type" content="text/html; charset="ISO-2022-JP">
<link rel="stylesheet" type="text/css" href="menu.css">
<title>˥塼</title>
</head>
<body>
<table bgcolor="#cceecc" cellpadding="4"><tr><td>
<a href="top.html" target="content"><font color="black">
Ϣ³ǧ󥸥 Julius/Julian
</font></a>
</td></tr></table>
EOM
## after menu tag
$post = <<EOM;
<hr>
<address>julius\@kuis.kyoto-u.ac.jp</address>
</body>
</html>
EOM

## menu delimiters
# not modified
#$first_delim = "<table border=1><tr bgcolor=\"#ddeedd\"><td>";		# left edge
$first_delim = "<ul>";
$inter_delim_begin = "<li>";
$inter_delim_end = "";
$last_delim = "</ul>";             # right edge

@fnames = ();
@menus = ();
@levels = ();

# get menu index from html source
while (@ARGV) {
    $fname = shift(@ARGV);
    if ($fname eq "HRHRHR") {
	push(@fnames, $fname);
	next;
    }
    print STDERR "$fname";
    $menu = "";
    open(IN, $fname) || die "cannot open \"$fname\"\n";
    while (<IN>) {
	if (/<\!--\s*menuitem\s+(.*)\s*-->/) {
	    $menu = $1;
	    print STDERR " - [$menu]\n";
	    last;
	}
    }
    if ($menu eq "") {		# not found
	print STDERR " !NOT FOUND!\n";
	next;
    }
    if ($menu =~ /\>/) {
	$menu =~ s/\>//g;
	push(@levels, 2);
    } else {
	push(@levels, 1);
    }
    push(@fnames, $fname);
    push(@menus, $menu);
    close(IN);
}

print "$pre1";
$nowlevel = 0;
while (@fnames) {
    $fname = shift(@fnames);
    if ($fname eq "HRHRHR") {
	while ($nowlevel > 0) {
	    print "$last_delim\n";
	    $nowlevel--;
	}
	next;
    }
    $menu = shift(@menus);
    $level = shift(@levels);
    if ($nowlevel < $level) {
	print "$first_delim\n";
    } elsif ($nowlevel > $level) {
	print "$last_delim\n";
    }
    print "$inter_delim_begin";
    if ($fname eq "top.html") {
	print "<a href=\"${fname}#what\" target=\"content\">$menu</a>\n";
    } else {
	print "<a href=\"$fname\" target=\"content\">$menu</a>\n";
    }
    print "$inter_delim_end";
    $nowlevel = $level;
}
while ($nowlevel > 0) {
    print "$last_delim\n";
    $nowlevel--;
}
print "$post\n";
