/*
 * Copyright (c) 1991-2003 Kyoto University
 * Copyright (c) 2000-2003 NAIST
 * All rights reserved
 */

/* voca_lookup.c --- vocabulary lookup function */

/* $Id: voca_lookup.c,v 1.4 2003/09/29 06:01:23 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/vocabulary.h>

/* search for word (for debug) */
/* keyword: "wname" or "wname[woutput]" or "#num" */
/* returns WORD_INVALID if not found */
WORD_ID
voca_lookup_wid(char *keyword, WORD_INFO *winfo)
{
  WORD_ID i, found;
  int plen,totallen;
  boolean numflag = TRUE;
  int wid;
  char *c;

  if (keyword == NULL) return WORD_INVALID;
  
  if (keyword[0] == '#') {
    
    for(i=1;i<strlen(keyword);i++) {
      if (keyword[i] < '0' || keyword[i] > '9') {
	numflag = FALSE;
	break;
      }
    }
    if (numflag) {
      wid = atoi(&(keyword[1]));
      if (wid < 0 || wid >= winfo->num) {
	return(WORD_INVALID);
      } else {
	return(wid);
      }
    } else {
      return(WORD_INVALID);
    }
  }
      
  found = WORD_INVALID;
  totallen = strlen(keyword);
  if ((c = strchr(keyword, '[')) != NULL) {
    plen = c - keyword;
    for (i=0;i<winfo->num;i++) {
      if (strnmatch(keyword,winfo->wname[i], plen)
	  && strnmatch(c+1, winfo->woutput[i], totallen-plen-2)) {
	if (found == WORD_INVALID) {
	  found = i;
	} else {
	  j_printerr("Warning: several \"%s\" found in dictionary, use the first one..\n");
	  break;
	}
      }
    }
  } else {
    for (i=0;i<winfo->num;i++) {
      if (strmatch(keyword,winfo->wname[i])) {
	if (found == WORD_INVALID) {
	  found = i;
	} else {
	  j_printerr("Warning: several \"%s\" found in dictionary, use the first one..\n");
	  break;
	}
      }
    }
  }
  return found;
}

/* convert space-separated words string -> array of wid */
/* return malloced array */
#define WSSTEP 10

WORD_ID *
new_str2wordseq(WORD_INFO *winfo, char *s, int *len_return)
{
  char *p;
  int num;
  int maxnum;
  WORD_ID *wseq;

  maxnum = WSSTEP;
  wseq = (WORD_ID *)mymalloc(sizeof(WORD_ID)*maxnum);
  num = 0;
  for (p = strtok(s, " "); p != NULL; p = strtok(NULL, " ")) {
    if (num >= maxnum) {
      maxnum += WSSTEP;
      wseq = (WORD_ID *)myrealloc(wseq, sizeof(WORD_ID) * maxnum);
    }
    if ((wseq[num] = voca_lookup_wid(p, winfo)) == WORD_INVALID) {
      /* not found */
      j_printerr("word \"%s\" not found in dict\n", p);
      free(wseq);
      return NULL;
    }
    num++;
  }

  *len_return = num;
  return(wseq);
}
