/*
 * Copyright (c) 1991-2003 Kyoto University
 * Copyright (c) 2000-2003 NAIST
 * All rights reserved
 */

/* dfa_lookup.c --- lookup DFA terminal symbol from word info */

/* $Id: dfa_lookup.c,v 1.5 2004/01/14 11:23:55 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/dfa.h>

#include <ctype.h>

WORD_ID
dfa_symbol_lookup(DFA_INFO *dinfo, char *terminalname)
{
  WORD_ID id;
  int c;
  char *p;

  /* check if terminal name is digit */
  for(p=terminalname;*p!='\0';p++) {
    c = *p;
    if (! isdigit(c)) {
      j_printerr("Error: wrong format: terminal number is not digit in dict! [%s]\n", terminalname);
      return(WORD_INVALID);
    }
  }

  /* Currently, terminal ID is already assigned by mkdfa in wname,
     so this function only returns the ID */
  id = atoi(terminalname);
  if (id >= dinfo->term_num) return(WORD_INVALID); /* error */
  else return(id);
}
