.de Sp
.if t .sp .5v
.if n .sp
..
.de Ip
.br
.ie \\n.$>=3 .ne \\$3
.el .ne 3
.IP "\\$1" \\$2
..
.TH ADINTOOL 1 LOCAL
.UC 6
.SH NAME
adintool - multi-purpose tool to record/split/send/receive speech data
.SH SYNOPSIS
.B adintool -in inputdev -out outputdev [options...]
.SH DESCRIPTION
.I adintool
analyzes speech input, finds speech segments skipping silence, and
records the detected segments in various ways.  It performs speech
detection based on zerocross number and power (level), and records the
detected parts to files or other output devices sucessively.
.PP
.I adintool
is a highly-functioned version of
.I adinrec.
The supported input device are: microphone input, a speech file,
standard tty input, and network socket (called adin-net server mode).
The speech segments are saved to output devices: speech files,
standard tty output, and network socket (called adin-net client mode).
For example, you can record the incoming speech segments to files with
successively-numbered suffixes, or send them to speech recognition
engine
.I julius
to recognize them.
.PP
The output is not buffered: the receiver can get speech data with only
a slight delay after a speech starts.  The speech detection algorithm
is as same as that of
.I adinrec.
.PP
Output format is WAV, 16bit (signed short), monoral.
If the file already exist, it will be overridden. 
.SH INPUT
The input device should be specified by one of the following options:
.Ip "\-in mic"
Microphone input (default)
.Ip "\-in file"
Speech data file.  Supported format is RAW (16bit big endian) and WAV
(no compression) etc (depending on the compilation time setting).
.br
The input file name should be given later: prompt will appear after startup.
.Ip "\-in adinnet"
Make
.I adintool
"adinnet server", waiting for connection from adinnet client and
receiving speech data from there via tcp/ip socket.
.br
Default port number is 5530, which can be altered by option "-port".
.Ip "\-in netaudio"
If supported, get input data from NetAudio/Datlink server.  Host and
unit name should be given with "-NA host:unit" option.
.Ip "\-in stdin"
Read speech data from standard tty input.  Only RAW and WAV format is
supported. 
.SH OUTPUT
Specify one of these below to select an output device which the detected
speech segments are going to written to.
.Ip "\-out file"
Output to files.  The base filename should be given by option like
"-filename foobar".  Actually, the detected segments are recorded in
separate files such as "foobar.0000", "foobar.0001" and so on.  The
four-digit ID begin with 0.  This initial value can be set explicitly
by option "-startid".  The output format is WAV, 16bit signed.  This
can be changed by "-raw" option.
.Ip "\-out adinnet"
Make
.I adintool
"adinnet client", making connection to an adinnet server on a host,
and send speech data to the server.  The hostname should be specified
by option "-server".  The default port number is 5530, which can be
altered by option "-port".
The available adinnet server so far is 
.I adintool
and
.I Julius.
.Ip "\-out stdout"
Output to standard tty output in RAW, 16bit signed (big endian).
.SH OPTIONS
.Ip "\-nosegment"
Re-direct whole input speech data to output device, without speech
detection and segmentation.  With this option, the output filename
does not have its four-digit ID appended.
.Ip "\-oneshot"
Record only the first speech segment.
.Ip "\-freq threshold"
Sampling frequency (Hz, default=16000)
.Ip "\-lv threslevel"
Level threshold (0-32767, default=2000)
.Ip "\-zc zerocrossnum"
Zero cross number threshold in a second (default=60)
.Ip "\-headmargin msec"
Header margin of each speech segment (unit: milliseconds)
(default: 400)
.Ip "\-tailmargin msec"
Tail margin of each speech segment (unit: milliseconds)
(default: 400)
.Ip "\-nostrip"
Disable skipping of invalid zero samples (default: enabled)
.Ip "\-zmean"
Enable zero mean subtraction to remove DC offset.
.Ip "\-raw"
Output in RAW (no header) 16bit, big engian format (default: WAV)
.SH "EXAMPLE"
Record microphone input only for the speech-detected part in
"data.0000.wav", "data.0001.wav", ...:
.PP
    % adintool -in mic -out file -filename data
.PP
Split a large speech data "foobar.raw" to "foobar.1500.wav", "foobar.1501.wav", etc:
.PP
    % adintool -in file -out file -filename foobar
      -startid 1500
      (enter the input filename after startup)
      enter filename->foobar.raw
      ....
.PP
Send whole speech file to other host via tcp/ip socket:
.PP
  [sender]
    % adintool -in adinnet -out file -nosegment
.BR
  [receiver]
    % adintool -in file -out adinnet -server hostname
      -nosegment
.PP
Send microphone input to 
.I Julius
running on other host:
.PP
(1) Transmit whole input, and let Julius execute
    speech detection and recognition:
.PP
  [Julius]
    % julius -C xxx.jconf ... -input adinnet
.BR
  [adintool]
    % adintool -in mic -out adinnet -server hostname
      -nosegment
.PP
(2) Detect speech segment at input client side
    (adintool), and transmit only the detected parts
    to Julius, and recognize them:
.PP
  [Julius]
    % julius -C xxx.jconf ... -input adinnet
.BR
  [adintool]
    % adintool -in mic -out adinnet -server hostname

.SH "SEE ALSO"
julius(1), adinrec(1)
.SH COPYRIGHT
Copyright (c) 2001-2003 Nara Institute of Science and Technology, Japan
.SH AUTHORS
LEE Akinobu (NAIST, Japan)
.br
contact: julius@kuis.kyoto-u.ac.jp
.SH LICENSE
Same as 
.I Julius.
