/*
 * Copyright (c) 1991-2003 Kyoto University
 * Copyright (c) 2000-2003 NAIST
 * All rights reserved
 */

/* calc_mix.c --- calculate outprob of mixture */
/*                       mixture tying is not considered */

/* $Id: calc_mix.c,v 1.4 2003/09/29 06:01:23 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/htk_hmm.h>
#include <sent/htk_param.h>
#include <sent/hmm.h>
#include <sent/gprune.h>
#include "globalvars.h"

LOGPROB
calc_mix()
{
  int i;
  LOGPROB logprob = LOG_ZERO;

  /* compute Gaussian set */
  compute_gaussset(OP_state->b, OP_state->mix_num, NULL);
  /* computed Gaussians will be set in:
     score ... OP_calced_score[0..OP_calced_num]
     id    ... OP_calced_id[0..OP_calced_num] */
  
  /* sum */
  for(i=0;i<OP_calced_num;i++) {
    OP_calced_score[i] += OP_state->bweight[OP_calced_id[i]];
  }
  logprob = addlog_array(OP_calced_score, OP_calced_num);
  if (logprob <= LOG_ZERO) return LOG_ZERO;
  return (logprob / LOG_TEN);
}
