#!/bin/sh
# Copyright (c) 1991-2003 Kyoto University
# Copyright (c) 2000-2003 NAIST
# All rights reserved
#
# stamp version to version.c
#
#
# $Id: stamp_version.sh,v 1.5 2003/10/01 01:22:04 ri Exp $
#

cat << EOM > version.c
/* this file is auto-generated by stamp_version.sh */

#include <julius.h>

/* output application header */
void
put_header(FILE *strm){
  fprintf(strm,"%s rev.%s (%s)\n\n", PRODUCTNAME, VERSION, SETUP);
}

/* output version info */
void
put_version(FILE *strm){
  fprintf(strm,"\n%s rev.%s (%s)  built for %s\n\n",
	  PRODUCTNAME, VERSION, SETUP, HOSTINFO);
  fprintf(strm,"Copyright (c) 1991-2003  Kyoto University\n");
#ifdef USE_NGRAM
  fprintf(strm,"Copyright (c) 1997-2000  IPA, Japan\n");
#endif
  fprintf(strm,"Copyright (c) 2000-2003  Nara Institute of Science and Technology\n\n");
}

/* output embedded compile-time settings */
void
put_compile_defs(FILE *strm){
  fprintf(strm,"Engine configuration:\n");
  fprintf(strm," - Base setup : %s\n", SETUP);
  fprintf(strm," - Tunings    :");
#ifdef USE_DFA
  fprintf(strm, " DFA");
#else  /* USE_NGRAM */
  fprintf(strm, " N-gram");
#ifndef UNIGRAM_FACTORING
  fprintf(strm, ", 2gramFactoring");
#endif
#endif

#ifdef USE_NGRAM
# ifndef CLASS_NGRAM
  fprintf(strm, ", NoClassNGram");
# endif
#endif
#ifdef WORDS_INT
  fprintf(strm, ", WordsInt");
#endif

#ifdef USE_NGRAM
# ifdef LOWMEM
  fprintf(strm, ", SingleTree");
# else
#  ifdef LOWMEM2
  /* fprintf(strm, ", HiFreqLinearTree");*/
#  else
  fprintf(strm, ", ShortWordTree");
#  endif
# endif
#endif /* USE_NGRAM */

#ifdef USE_DFA
# ifndef CATEGORY_TREE
  fprintf(strm, ", NoCategoryTree");
# endif
#endif

#ifdef MONOTREE
  fprintf(strm, ", MonoTree1");
#endif
#ifndef SCAN_BEAM
  fprintf(strm, ", NoScoreEnvelope");
#endif
#ifndef PASS1_IWCD
  fprintf(strm, ", NoIWCD1");
#endif
#ifdef PASS2_STRICT_IWCD
  fprintf(strm, ", StrictIWCD2");
#endif

#ifdef WPAIR
# ifdef WPAIR_KEEP_NLIMIT
  fprintf(strm, ", WordPairNApprox");
# else
  fprintf(strm, ", WordPairApprox");
# endif
#endif

#ifdef WORD_GRAPH
  fprintf(strm, ", WordGraph");
#endif

#ifdef SP_BREAK_CURRENT_FRAME
  fprintf(strm, ", ShortPauseSegment");
#endif

#ifndef CONFIDENCE_MEASURE
  fprintf(strm, ", NoCM");
#else
# ifdef CM_NBEST
  fprintf(strm, ", N-bestCM");
# endif
# ifdef CM_MULTIPLE_ALPHA
  fprintf(strm, ", MultiCMOutput");
# endif
#endif /* CONFIDENCE_MEASURE */

#ifndef USE_MIC
  fprintf(strm, ", NoMic");
#endif
#ifdef USE_NETAUDIO
  fprintf(strm, ", NetAudio");
#endif
#ifndef HAVE_PTHREAD
  fprintf(strm, ", NoThreaded");
#endif
#ifdef HAVE_LIBSNDFILE
  fprintf(strm, ", LibSndFile");
#endif

  fprintf(strm, "\n");
  fprintf(strm," - Compiled by: $1 $2\n");
}
EOM
