/*
 * Copyright (c) 1991-2003 Kyoto University
 * Copyright (c) 2000-2003 NAIST
 * All rights reserved
 */

/* multi-gram.h --- handling multiple grammar file */
/* $Id: multi-gram.h,v 1.3 2003/09/29 06:01:22 ri Exp $ */

#ifndef __MULTI_GRAM__
#define __MULTI_GRAM__

#include <julius.h>

#ifdef USE_DFA

typedef struct __multi_gram__ {
  char *name;			/* unique name */
  unsigned short id;		/* unique ID */
  DFA_INFO *dfa;		/* dfa info */
  WORD_INFO *winfo;		/* dict info */
  int hook;			/* command hook for this grammar
				   command is queued, and will be executed
				   at next call of multigram_exec() */
  boolean newbie;		/* TRUE if not set up for the first time */
  boolean active;		/* TRUE if active (used in recognition) */
  /* below vars holds the location of this grammar within the global grammar */
  int state_begin;		/* first ID of DFA state */
  int cate_begin;		/* first ID of word category */
  int word_begin;		/* first ID of word in dict */
  struct __multi_gram__ *next;	/* link to next MULTIGRAM */
} MULTIGRAM;

/* for command hook */
#define MULTIGRAM_DEFAULT    0
#define MULTIGRAM_DELETE     1
#define MULTIGRAM_ACTIVATE   2
#define MULTIGRAM_DEACTIVATE 3

void multigram_add(DFA_INFO *dfa, WORD_INFO *winfo);
boolean multigram_delete(int gid);
void multigram_delete_all();
boolean multigram_exec();
void multigram_activate(int gid);
void multigram_deactivate(int gid);

#endif /* USE_DFA */

#endif /*  __MULTI_GRAM__ */
