/*
 * Copyright (c) 1991-2003 Kyoto University
 * Copyright (c) 2000-2003 NAIST
 * All rights reserved
 */

/* m_usage.c --- print help */

/* $Id: m_usage.c,v 1.22 2003/10/02 03:05:02 ri Exp $ */

#include <julius.h>


/* error no argument specified */
/* terminate on option error */
void
opt_terminate()
{
  j_error("Try `-help' for more information.\n");
}

void
usage()
{
  put_version(stderr);
  j_printerr("Try '-setting' for built-in engine configuration.\n");
  j_printerr("Try '-help' for run time options.\n");
  j_exit();
}

/* output detailed info */
void
detailed_help()
{
  put_header(stdout);
  put_compile_defs(stdout);
  j_printf("\nOptions:\n");

  j_printf("\n Speech Input:\n");
  j_printf("    [-input devname]    speech input from:                    (mfcfile)\n");
  j_printf("            mfcfile       HTK parameter file\n");
  j_printf("            (raw inputs below allowed for MFCC_{0|E}_D[_N]_Z AM only)\n");
  j_printf("            rawfile       wave file (16bit,mono,linear)\n");
  j_printf("                          supported file types:\n");
  j_printf("                            %s\n", SUPPORTED_WAVEFILE_FORMAT);
#ifdef USE_MIC
  j_printf("            mic           microphone device\n");
#endif
#ifdef USE_NETAUDIO
  j_printf("            netaudio      DatLink/NetAudio server\n");
#endif
  j_printf("            adinnet     adinnet client (TCP/IP)\n");
  j_printf("            stdin       standard input\n");
  j_printf("    [-filelist file]    input file list\n");
#ifdef USE_NETAUDIO
  j_printf("    [-NA host:unit]     netaudio server address\n");
#endif
  j_printf("    [-adport portnum]   adinnet portnum to listen             (%d)\n", adinnet_port);
  j_printf("    [-record dir]       save recognized speech data to dir\n");
  
  j_printf("\n Speech Detection: (default: on=mic/net off=files)\n");
  /*j_printf("    [-pausesegment]     turn on (force) pause detection\n");*/
  /*j_printf("    [-nopausesegment]   turn off (force) pause detection\n");*/
  j_printf("    [-cutsilence]       turn on (force) long silence cutting\n");
  j_printf("    [-nocutsilence]     turn off (force) long silence cutting\n");
  j_printf("    [-lv unsignedshort] level threshold (0-32767)             (%d)\n", level_thres);
  j_printf("    [-zc zerocrossnum]  zerocross num threshold (per sec.)    (%d)\n", zero_cross_num);
  j_printf("    [-headmargin msec]  header margin length in msec.         (%d)\n", head_margin_msec);
  j_printf("    [-tailmargin msec]  tail margin length in msec.           (%d)\n", tail_margin_msec);
  j_printf("    [-nostrip]          not strip off zero samples\n");

  j_printf("\n Acoustic analysis:\n");
  j_printf("    [-smpFreq freq]     sample period (Hz)                    (%d)\n", smpFreq);
  j_printf("    [-smpPeriod period] sample period (ns)                    (%d)\n", smpPeriod);
  j_printf("    [-fsize sample]     window size (sample)                  (%d)\n", fsize);
  j_printf("    [-fshift sample]    frame shift (sample)                  (%d)\n", fshift);
  j_printf("    [-delwin frame]     delta windows length (frame)          (%d)\n", delwin);
  j_printf("    [-hifreq freq]      freq. of upper band limit, off if <0  (%d)\n", hipass);
  j_printf("    [-lofreq freq]      freq. of lower band limit, off if <0  (%d)\n", lopass);
  j_printf("    [-sscalc]           do spectral subtraction (file input only)\n");
  j_printf("    [-sscalclen msec]   length of head silence for SS (msec)  (%d)\n", sscalc_len);
  j_printf("    [-ssload filename]  load constant noise spectrum from file for SS\n");
  j_printf("    [-ssalpha value]    alpha coef. for SS                    (%f)\n", ssalpha);
  j_printf("    [-ssfloor value]    spectral floor for SS                 (%f)\n", ssfloor);

#ifdef USE_NGRAM
  j_printf("\n N-gram Language model (\"-d\" or \"-nlr -nrl\" needed):\n");
  j_printf("    -d file.bingram     n-gram file name in Julius binary format\n");
  j_printf("    -nlr file.arpa      2-gram file name in ARPA format\n");
  j_printf("    -nrl file.arpa      reverse 3-gram file name in ARPA format\n");
  j_printf("    [-lmp float float]  weight and penalty (tri: %.1f %.1f mono: %.1f %1.f)\n", DEFAULT_LM_WEIGHT_TRI_PASS1, DEFAULT_LM_PENALTY_TRI_PASS1, DEFAULT_LM_WEIGHT_MONO_PASS1, DEFAULT_LM_PENALTY_MONO_PASS1);
  j_printf("    [-lmp2 float float]       for 2nd pass (tri: %.1f %.1f mono: %.1f %1.f)\n", DEFAULT_LM_WEIGHT_TRI_PASS2, DEFAULT_LM_PENALTY_TRI_PASS2, DEFAULT_LM_WEIGHT_MONO_PASS2, DEFAULT_LM_PENALTY_MONO_PASS2);
  j_printf("    [-transp float]     penalty for transparent word (%+2.1f)\n", lm_penalty_trans);
#else  /* USE_DFA */
  j_printf("\n Grammar:\n");
  j_printf("    -dfa file.dfa       DFA grammar file\n");
  j_printf("    [-penalty1 float]   word insertion penalty (1st pass)     (%.1f)\n", penalty1);
  j_printf("    [-penalty2 float]   word insertion penalty (2nd pass)     (%.1f)\n", penalty1);
#endif

  j_printf("\n Word Dictionary:\n");
  j_printf("    -v dictfile         dictionary file name\n");
#ifdef USE_NGRAM
  j_printf("    [-silhead wordname] specify beginning-of-sentence word    (%s)\n", head_silname);
  j_printf("    [-siltail wordname] specify end-of-sentence word          (%s)\n", tail_silname);
#endif
  j_printf("    [-forcedict]        not terminate on error words, just ignore\n");
#ifdef USE_NGRAM
  j_printf("    [-iwspword]         add an sp-word to the vocabulary for inter-word CD sp\n");
  j_printf("    [-iwspentry dictentry] specify content of the iwspword    (%s)\n", iwspentry);
#endif
  
  j_printf("\n Acoustic Model:\n");
  j_printf("    -h hmmdefsfile      HMM definition file name\n");
  j_printf("    [-hlist HMMlistfile] HMMlist filename (must for triphone model)\n");
  j_printf("    [-iwcd1 methodname] switch IWCD triphone handling on 1st pass\n");
#ifdef USE_NGRAM
  j_printf("             max        use maximum score (default)\n");
  j_printf("             avg        use average score\n");
#else
  j_printf("             max        use maximum score\n");
  j_printf("             avg        use average score (default)\n");
#endif
  j_printf("    [-force_ccd]        force to handle IWCD\n");
  j_printf("    [-no_ccd]           don't handle IWCD\n");
  j_printf("    [-notypecheck]      don't check input parameter type\n");
  j_printf("    [-spmodel HMMname]  name of short pause model             (\"%s\")\n",spmodel_name);

  j_printf("\n Acoustic Computation Method:\n");
  j_printf("    [-gprune methodname] select Gaussian pruning method:\n");
#ifdef GPRUNE_DEFAULT_SAFE
  j_printf("             safe          safe pruning (default for TM/PTM)\n");
#else
  j_printf("             safe          safe pruning\n");
#endif
#if GPRUNE_DEFAULT_HEURISTIC
  j_printf("             heuristic     heuristic pruning (default for TM/PTM)\n");
#else
  j_printf("             heuristic     heuristic pruning\n");
#endif
#if GPRUNE_DEFAULT_BEAM
  j_printf("             beam          beam pruning (default for TM/PTM)\n");
#else
  j_printf("             beam          beam pruning\n");
#endif
  j_printf("             none          no pruning (default for non tmix models)\n");
  j_printf("    [-tmix gaussnum]    Gaussian num threshold per mixture for pruning (%d)\n", mixnum_thres);
  j_printf("    [-gshmm hmmdefs]    monophone hmmdefs for GS\n");
  j_printf("    [-gsnum N]          N-best state will be selected        (%d)\n", gs_statenum);

#ifdef SP_BREAK_CURRENT_FRAME
  j_printf("\n Short-pause Segmentation:\n");
  j_printf("    [-spdur]            length threshold of sp frames         (%d)\n", sp_frame_duration);
#endif

  j_printf("\n Search Parameters (First Pass):\n");
  j_printf("    [-b beamwidth]      beam width (by state num)             (guessed)\n");
#ifdef WPAIR
# ifdef WPAIR_KEEP_NLIMIT
  j_printf("    [-nlimit N]         keeps only N tokens on each state     (%d)\n", wpair_keep_nlimit);
# endif
#endif
#ifdef USE_NGRAM
#ifdef SEPARATE_BY_UNIGRAM
  j_printf("    [-sepnum wordnum]   # of hi-freq word isolated from tree  (%d)\n", separate_wnum);
#endif
#ifdef HASH_CACHE_IW
  j_printf("    [-iwcache percent]  amount of inter-word LM cache         (%3d)\n", iw_cache_rate);
#endif
#endif /* USE_NGRAM */
  j_printf("    [-1pass]            do 1st pass only, omit 2nd pass\n");

  j_printf("\n Search Parameters (Second Pass):\n");
  j_printf("    [-b2 hyponum]       word envelope beam width (by hypo num) (%d)\n",enveloped_bestfirst_width);
  j_printf("    [-n N]              # of sentence to find                 (%d)\n", nbest);
  j_printf("    [-output N]         # of sentence to output               (%d)\n",output_hypo_maxnum);
#ifdef SCAN_BEAM
  j_printf("    [-sb score]         score beam threshold (by score)       (%.1f)\n", scan_beam_thres);
#endif
  j_printf("    [-s hyponum]        global stack size of hypotheses       (%d)\n", stack_size);
  j_printf("    [-m hyponum]        hypotheses overflow threshold num     (%d)\n", hypo_overflow);

  j_printf("    [-lookuprange N]    frame lookup range in word expansion  (%d)\n", lookup_range);
#ifdef USE_DFA
  j_printf("    [-looktrellis]      expand only backtrellis words\n");
#endif
#ifdef CATEGORY_TREE
  j_printf("    [-oldtree]          use old build_wchmm()\n");
#ifdef PASS1_IWCD
  j_printf("    [-oldiwcd]          use full lcdset\n");
#endif
#endif
  j_printf("    [-iwsp]             turn on inter-word short pause handling (off)\n");
  j_printf("    [-iwsppenalty]      trans. penalty for inter-word sp      (%.1f)\n", iwsp_penalty);

  j_printf("\n On-the-fly Decoding: (default: on=mic/net off=files)\n");
  j_printf("    [-realtime]         turn on, input streamed with last CMN\n");
  j_printf("    [-norealtime]       turn off, input buffered with sentence CMN\n");
  j_printf("    [-cmnload file]     load initial CMN param from file on startup\n");
  j_printf("    [-cmnsave file]     save CMN param to file (update per input)\n");
  j_printf("\n Forced Alignment:\n");
  j_printf("    [-walign]           optionally output word alignments\n");
  j_printf("    [-palign]           optionally output phoneme alignments\n");
  j_printf("    [-salign]           optionally output state alignments\n");
#ifdef CONFIDENCE_MEASURE
#ifdef CM_MULTIPLE_ALPHA
  j_printf("\n Confidence Score:\n");
  j_printf("    [-cmalpha f t s]    CM smoothing factor        (from, to, step)\n");
#else
  j_printf("\n Confidence Score:\n");
  j_printf("    [-cmalpha value]    CM smoothing factor                    (%f)\n", cm_alpha);
#endif
#endif /* CONFIDENCE_MEASURE */
  j_printf("\n Output:\n");
  j_printf("    [-result devname]   output recognition result to:         (tty)\n");
  j_printf("             tty        terminal (standard out)\n");
  j_printf("             msock      module socket\n");
  j_printf("\n Server Module Mode:\n");
  j_printf("    [-module [port]]    enable server module mode             (%d)\n", module_port);
  j_printf("                        (implies \"-result msock\")\n");
  j_printf("    [-outcode WLPSwlps] select info to output to the module\n");
  j_printf("                        (Word,Lang,Phone,Score, lower == 1st pass)\n");
  j_printf("\n Message Output:\n");
#ifdef USE_NGRAM
  j_printf("    [-separatescore]    output LM and AM score independently\n");
#endif
  j_printf("    [-quiet]            reduce output to only word string\n");
  j_printf("    [-progout]          progressive output in 1st pass\n");
  j_printf("    [-proginterval]     interval of progout in msec           (%d)\n", progout_interval);
  j_printf("    [-demo]             equal to \"-quiet -progout\"\n");
  j_printf("\n Others:\n");
  j_printf("    [-C jconffile]      load options from jconf file\n");
  j_printf("    [-debug]            (for debug) dump numerous log\n");
  j_printf("    [-check (wchmm|trellis)] (for debug) check internal structure\n");
  j_printf("    [-check triphone]   triphone mapping check\n");
  j_printf("    [-setting]          print engine configuration and exit\n");
  j_printf("    [-help]             print this message and exit\n");
  j_exit();
}
