/**
 * @file   wrsamp.c
 *
 * <JA>
 * @brief  ȷ big endian ΥХȥǽ񤭹
 * </JA>
 * <EN>
 * @brief  Write waveform data in big endian
 * </EN>
 *
 * @author Akinobu LEE
 * @date   Tue Feb 15 00:58:47 2005
 *
 * $Revision: 1.3 $
 * 
 */
/*
 * Copyright (c) 1991-2011 Kawahara Lab., Kyoto University
 * Copyright (c) 2000-2005 Shikano Lab., Nara Institute of Science and Technology
 * Copyright (c) 2005-2011 Julius project team, Nagoya Institute of Technology
 * All rights reserved
 */

#include <sent/stddefs.h>
#include <sent/speech.h>

/** 
 * Write waveform data in big endian to a file descriptor
 * 
 * @param fd [in] file descriptor
 * @param buf [in] array of speech data
 * @param len [in] length of above
 * 
 * @return number of bytes written, -1 on error.
 */
int
wrsamp(int fd, SP16 *buf, int len)
{
  int ret;
#ifndef WORDS_BIGENDIAN
  /* swap byte order to BIG ENDIAN */
  swap_sample_bytes(buf, len);
#endif
  ret = write(fd, buf, len * sizeof(SP16));
#ifndef WORDS_BIGENDIAN
  /* undo byte swap */
  swap_sample_bytes(buf, len);
#endif
  return(ret);
}
