/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* stddefs.h --- nifty standard definitions */

/* $Id: stddefs.h,v 1.6 2003/02/25 01:44:57 ri Exp $ */

#ifndef __SENT_STANDARD_DEFS__
#define __SENT_STANDARD_DEFS__

/* assertion */
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>
#include <math.h>
#include <assert.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>

#include <sent/config.h>
#include <sent/machines.h>

#if !defined(PI)
#define PI 3.14159265358979
#endif
#if !defined(TPI)
#define TPI 6.28318530717959
#define LOGTPI 1.83787706640935
#endif
#if !defined(LOG_TEN)
#define LOG_TEN 2.30258509
#endif

/* define boolean */
typedef unsigned char boolean;
#define TRUE 1
#define FALSE 0

/* some macros */
#define	max(A,B)	((A)>=(B)?(A):(B))
#define	min(A,B)	((A)<(B)?(A):(B))
#define	abs(X)		((X)>0?(X):-(X))
#define strmatch	!strcmp
#define strnmatch	!strncmp
#define DELM " \t\n"

/* from ~speech/src/sent/sentence.h */
#define	LOG_ZERO	-1000000 /* approx. log(0) (remember to modify LOG_ADDMIN below if you change this value! */
#define LOG_ADDMIN	-13.815510558	/* -log(-LOG_ZERO) (see lib/phmm/outprob.c for explanation) */

/* typedef and enum */
enum LogOutputLevel {
  LOG_NORMAL,
  LOG_VERBOSE,
  LOG_DEBUG
};
enum{DIR_LR, DIR_RL};		/* tree direction */

/* you can't use double for typedefs below */
/* also look at lib/util/mybmalloc.c */
typedef float PROB;		/* probability */
typedef float LOGPROB;		/* log probability */
typedef int FREQ;		/* N-gram frequency */
typedef short SP16;		/* 16bit speech data */
typedef float VECT;		/* vector element */

/* maximum word num */
#ifdef WORDS_INT
  /* 2G = 2^31 mode */
  typedef int WORD_ID; /* typedef for word ID */
  #define MAX_WORD_NUM 2147483647 /* maximum size of vocabulary */
  #define WORD_INVALID 2147483647 /* ID for invalid word */
#else  /* 64K */
  typedef unsigned short WORD_ID; /* tyoedef for word ID */
  #define MAX_WORD_NUM 65535	/* maximum size of vocabulary */
  #define WORD_INVALID 65535	/* ID for invalid word */
#endif

#define MAXLINELEN 1024		/* assumed maximum byte per input line */

#include <sent/util.h>

#endif /* __SENT_STANDARD_DEFS__ */
