.de Sp
.if t .sp .5v
.if n .sp
..
.de Ip
.br
.ie \\n.$>=3 .ne \\$3
.el .ne 3
.IP "\\$1" \\$2
..
.TH JCONTROL 1 LOCAL
.UC 6
.SH NAME
jcontrol - simple program to control Julius / Julian module via API
.SH SYNOPSIS
.B jcontrol hostname [portnum]
.SH DESCRIPTION
.I jcontrol
is a simple console program to control
.I julius
running on other host via network API.  It can send command to Julius,
and receive messages from Julius.
.PP
When invoked, jcontrol tries to connect to Julius or Julian running in
"module mode" on specified hostname.  After connection established,
jcontrol waits for user commands from standard input.
.PP
When user types
a command to jcontrol, it will be interpreted and corresponding API
command will be sent to Julius.  When a message is received from
Julius, its content will be output to standard output.
.PP
For details about the API, see the related documents.
.SH "OPTIONS"
.Ip hostname
Host name where Julius is runnning in module mode.
.Ip portnum
(optional) port number. (default=10500)
.SH "COMMANDS (COMMON)"
After startup, the command string below can be input from stdin.
.Ip "pause"
Stop recognition, cutting speech input at that point if any.
.Ip "terminate"
Stop recognition, discarding the current speech input if any.
.Ip "resume"
(re)start recognition.
.Ip "inputparam arg"
Tell Julius how to deal with speech input in case grammar is changed
just when recognition is running.  Specify one: "TERMINATE", "PAUSE", "WAIT"
.Ip "version"
Return version number.
.Ip "status"
Return trigger status (active/sleep).
.SH "GRAMMAR COMMANDS (Julian)"
Below are Grammar-related command strings for Julian:
.Ip "changegram prefix"
Change recognition grammar to "prefix.dfa" and "prefix.dict".
All the current grammars used in Julian are deleted and replaced to
the specifed grammar.
.Ip "addgram prefix"
tell Julian to use additional grammar "prefix.dfa" and "prefix.dict"
for recognition.
The specified grammars are added to the list of recognition grammars, 
and then activated.
.Ip "deletegram ID"
tell Julian to delete grammar of the specified "ID". 
The deleted grammar will be erased from Julian.
The grammar "ID" is sent from Julian at each time grammar information
has changed.
.Ip "deactivategram ID"
tell Julian to de-activate a grammar.  The specified grammar will become
temporary OFF, and skipped from recognition process.  These de-activated
grammars are kept in Julian, and can be activated by
"activategram" command.
.Ip "activategram ID"
tell Julian to activate previously de-activated grammar.
.SH "EXAMPLE"
The dump messages from Julius / Julian are output to tty with prefix
"> " appended to each line.
.PP
See related documents for more details.
.PP
(1) start Julius / Julian in module mode at host 'host'.
    % julian -C xxx.jconf ... -input mic -module
.PP
(2) (on other tty) start jcontrol, and start communication.
    % jcontrol host
    connecting to host:10500...done
    > <GRAMINFO>
    >  # 0: [active] 99words, 42categories, 135nodes (new)
    > </GRAMINFO>
    > <GRAMINFO>
    >  # 0: [active] 99words, 42categories, 135 nodes
    >   Grobal:      99words, 42categories, 135nodes
    > </GRAMINFO>
    > <INPUT STATUS="LISTEN" TIME="1031583083"/>
 -> pause
 -> resume
    > <INPUT STATUS="LISTEN" TIME="1031583386"/>
 -> addgram test
    ....

.SH "SEE ALSO"
julius(1), julian(1)
.SH AUTHORS
LEE Akinobu (NAIST, Japan)
.br
contact: julius@kuis.kyoto-u.ac.jp
.SH LICENSE
Same as 
.I Julius.
