#!/bin/sh
#
# Automatic update of binary package from Julius source archive.
# Supports 3.5 and later.
#
# !! Should be executed at "../"
#
# you should specify the target source archive .tar.gz file.
#
#

# expand archive
mv julius-simple aaa
rm -rf julius*
tar xzvf $1
ln -s julius-* julius
rm -rf include/sent include/julius
mv aaa julius-simple

# update binaries
cd julius
sh ./support/build-all.sh
mv build/bin/* ../bin
mv build/lib/* ../lib
mv build/include/* ../include
mv julius-simple/julius-simple.c ../julius-simple
cd ..

# copy the documents
cp -p julius/00readme.txt 00readme-julius.txt
cp -p julius/00readme-ja.txt 00readme-julius-ja.txt
cp -p julius/LICENSE.txt .
cp -p julius/Release* .
cp -p julius/Sample*jconf* .
cp -p julius/gramtools/00readme.txt doc/gramtools.txt
cp -p julius/gramtools/00readme-ja.txt doc/gramtools-ja.txt

# copy manuals
find julius/ -name "*.man" -exec ./support/cpman.sh {} \;
find julius/ -name "*.man.ja" -exec ./support/cpmanja.sh {} \;
mv doc/man/*.1 doc/man/man1
mv doc/man/man1/jconf.1 doc/man/man5/jconf.5
mv doc/man.ja/*.1 doc/man.ja/man1
mv doc/man.ja/man1/jconf.1 doc/man.ja/man5/jconf.5
qkc -m doc/txt/*
qkc -s -m doc/txt.ja/*

# finished
rm -f julius
echo '#### FINISHED, you should remove julius-ver directory manually ###'
