#!/bin/sh
#
# usage: ./support/00update.sh /some/where/julius-*.*-linuxbin.tar.gz
#
# update win32bin package from linuxbin of the same version
#
# should be invoked at the parent directory.
#
# you should put windows binaries in bin/ manually!
#

# expand linux binary package
rm -rf linuxbin julius-*-linuxbin
tar xzvf $1
ln -s julius-*-linuxbin linuxbin

# update doc
rm -rf doc
cp -p linuxbin/00readme-julius.txt .
cp -p linuxbin/00readme-julius-ja.txt .
cp -p linuxbin/LICENSE.txt .
cp -p linuxbin/Release* .
cp -p linuxbin/Sample* .
rsync -avz linuxbin/doc .

# update sample code
rsync -avz linuxbin/julius-simple .

# convert code
qkc -s -m 00readme-julius-ja.txt 00readme-julius.txt LICENSE.txt Release* Sample*
find doc -name '*.txt' -exec qkc -s -m {} \;
find include -name '*.txt' -exec qkc -s -m {} \;
find include -name '*.h' -exec qkc -s -m {} \;
find lib -name '*.txt' -exec qkc -s -m {} \;
qkc -s -m julius-simple/*

# end
rm -rf linuxbin julius-*-linuxbin
echo 'You should update these manually:'
echo '    00readme.txt 00readme-ja.txt'
echo '    bin, include, lib'
