/**
 * @file   htk_param.h
 * @author Akinobu LEE
 * @date   Fri Feb 11 02:52:52 2005
 *
 * <EN>
 * @brief Structures for storing input speech parameters
 *
 * This file defines a structure for holding a vector sequence of
 * input speech parameters.  The speech parameter sequence will be
 * stored in HTK_Param.  The HTK_Param also holds information about
 * the extraction condition, i.e., frame shift length, window size and
 * so on.
 *
 * The speech input vector can be read from HTK parameter file, or
 * Julius extracts the parameters directly from input speech.  Julius
 * supports extraction of only MFCC format of fixed dimension.
 * More precisely, only parameter type of MFCC_{0|E}_D[_Z][_N] with {25|26}
 * dimensions is supported.
 *
 * When recognition, the parameter types of both acoustic model and
 * input parameter should be the same.  Please note that only the
 * parameter type is checked, and other parameters such as source sampling
 * rate, frame shift length and window sizes will not be checked.
 * </EN>
 * <JA>
 * @brief HTKħѥ᡼ݻ빽¤Τ˴Ϣ
 *
 * Υեˤϡħ̤Υ٥ȥݻ빽¤Τ
 * Ƥޤϲ׻줿MFCCβħ̤ϡ
 * 빽¤ HTK_Param ¸ޤHTK_Paramˤ
 * ޤħлΥե졼ॷե䥦ɥĹʤɤξ
 * ݻޤ
 *
 * ħ̤ϳ HTK ʤɤˤäФ줿HTKħ̥ե
 * ɤ߹ळȤǤޤޤMFCC Ǥ Julius 
 * ľܲȷФ뤳ȤǤޤºݤJuliusФ
 * 뤳ȤǤħ̤ {25|26}  MFCC_{0|E}_D[_Z][_N] ΤߤǤ
 *
 * Ѥ벻ǥ(%HMM)ؽѤħ̤ǧоݤȤϤ
 * ħ̤ηϰפɬפޤǧ¹Իˤϡǥ
 * եħ̷å졤Ŭ礷ʤϥ顼Ȥʤޤ
 * ϲΥץ󥰼ȿե졼ॷեɥĹ
 * HTKβǥˤݻƤʤᡤåǤޤ
 * դƲ
 * </JA>
 *
 * @sa htk_defs.h
 *
 * $Revision: 1.2 $
 * 
 */
/*
 * Copyright (c) 1991-2006 Kawahara Lab., Kyoto University
 * Copyright (c) 2000-2005 Shikano Lab., Nara Institute of Science and Technology
 * Copyright (c) 2005-2006 Julius project team, Nagoya Institute of Technology, Nagoya Institute of Technology
 * All rights reserved
 */

#ifndef __SENT_HTK_PARAM_H__
#define __SENT_HTK_PARAM_H__

#include <sent/stddefs.h>
#include <sent/htk_defs.h>

/// Parameter types and extraction conditions
typedef struct {
  unsigned int samplenum;	///< Number of samples (or frames)
  unsigned int wshift;		///< Window shift (unit: 100ns) 
  unsigned short sampsize;	///< Bytes per sample 
  short samptype;		///< Parameter type, see also htk_defs.h
} HTK_Param_Header;

/// Input speech parameter
typedef struct {
  HTK_Param_Header header;	///< Parameter header information
  unsigned int samplenum;	///< Number of sample (same in header.samplenum) 
  short veclen;			///< Vector length of a sample
  VECT **parvec;		///< Actual parameter vectors [0..samplenum-1][0..veclen-1]
} HTK_Param;


boolean rdparam(char *, HTK_Param *);
HTK_Param *new_param();
void free_param(HTK_Param *);
short param_qualstr2code(char *);
short param_str2code(char *);
char *param_qualcode2str(char *, short, boolean);
char *param_code2str(char *, short, boolean);
HTK_Param *new_select_param_kind(HTK_Param *src, short select_qualifier);
boolean select_param_vmark(HTK_Param *src, short dst_type);
int exec_exclude_one_vector(VECT *vec, int len);
int guess_basenum(HTK_Param *p, short qualtype);
boolean param_strip_zero(HTK_Param *param);


/* hmminfo/put_htkdata_info.c */
void put_param_head(HTK_Param_Header *h);
void put_vec(VECT **p, int num, short veclen);
void put_param(HTK_Param *pinfo);
void put_param_info(HTK_Param *pinfo);

#endif /* __SENT_HTK_PARAM_H__ */
