/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* ngram_malloc.c -- malloc and free n-gram info */

/* $Id: ngram_malloc.c,v 1.2 2002/09/11 22:01:50 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/ngram2.h>

/* allocate new ngram info */
NGRAM_INFO *
ngram_info_new()
{
  NGRAM_INFO *new;

  new = (NGRAM_INFO *)mymalloc(sizeof(NGRAM_INFO));

  return(new);
}

/* free ngram info */
void
ngram_info_free(NGRAM_INFO *ndata)
{
  /* bin test only */
  /* free word names */
  if (ndata->from_bin) {
    free(ndata->wname[0]);
    free(ndata->wname);
  } else {
    WORD_ID w;
    for(w=0;w<ndata->max_word_num;w++) {
      free(ndata->wname[w]);
    }
    free(ndata->wname);
  }
  /* free 1-gram */
  free(ndata->p);
  free(ndata->bo_wt_lr);
  free(ndata->bo_wt_rl);
  free(ndata->n2_bgn);
  free(ndata->n2_num);
  /* free 2-gram */
  free(ndata->n2tonid);
  free(ndata->p_lr);
  free(ndata->p_rl);
  free(ndata->bo_wt_rrl);
  free(ndata->n3_bgn);
  free(ndata->n3_num);
  /* free 3-gram */
  free(ndata->n3tonid);
  free(ndata->p_rrl);
  /* free index tree */
  free_ptree(ndata->root);
  /* free whole */
  free(ndata);
}

