/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* rdhmmdef_regtree.c --- read in hmmdefs (regression tree --- ignore) */

/* $Id: rdhmmdef_regtree.c,v 1.2 2002/09/11 22:01:50 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/htk_hmm.h>

extern char *rdhmmdef_token;

/* read in var data to skip till next macro */
static void
regtree_read(FILE *fp)
{
  int num;

  read_token(fp);
  NoTokErr("missing REGTREE terminal node num");
  num = atoi(rdhmmdef_token);
  read_token(fp);
  for(;;) {
    if (currentis("NODE")) {	/* skip 3 arguments */
      read_token(fp);
      read_token(fp);
      read_token(fp);
      read_token(fp);
    } else if (currentis("TNODE")) { /* skip 2 argument */
      read_token(fp);
      read_token(fp);
      read_token(fp);
    } else {
      break;
    }
  }
}


/* define regtree data */
void
def_regtree_macro(char *name, FILE *fp, HTK_HMM_INFO *hmm)
{
  if (currentis("~r")) {	/* macro reference */
    /* ignore silently */
  } else if (currentis("REGTREE")) { /* definition */
    /* do not define actually, just read forward till next macro */
    regtree_read(fp);
  } else {
    rderr("no regtree data\n");
  }
  return;
}
