/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* gprune.h --- Gaussian pruning */

/* $Id: gprune.h,v 1.2 2002/09/11 22:01:50 ri Exp $ */

#ifndef __SENT_GAUSSIAN_PRUNE__
#define __SENT_GAUSSIAN_PRUNE__

enum{GPRUNE_SEL_UNDEF, GPRUNE_SEL_NONE, GPRUNE_SEL_SAFE, GPRUNE_SEL_HEURISTIC, GPRUNE_SEL_BEAM};

/* Gaussian prob. cache */
typedef struct __mixcache__ {
  LOGPROB score;		/* cached prob. */
  unsigned short id;		/* Gaussian ID in the codebook */
} MIXCACHE;

#define TMBEAMWIDTH 5.0		/* score offset for Gprune=beam */

/* gprune_common.c */
int find_insert_point(LOGPROB score, int len);
int cache_push(int id, LOGPROB score, int len);
/* gprune_none.c */
LOGPROB compute_g_base(HTK_HMM_Dens *binfo);
boolean gprune_none_init();
void gprune_none(HTK_HMM_Dens **g, int num, int *last_id);
/* gprune_safe.c */
LOGPROB compute_g_safe(HTK_HMM_Dens *binfo, LOGPROB thres);
boolean gprune_safe_init();
void gprune_safe(HTK_HMM_Dens **g, int gnum, int *last_id);
/* gprune_heu.c */
boolean gprune_heu_init();
void gprune_heu(HTK_HMM_Dens **g, int gnum, int *last_id);
/* gprune_beam.c */
boolean gprune_beam_init();
void gprune_beam(HTK_HMM_Dens **g, int gnum, int *last_id);


#endif /*__SENT_GAUSSIAN_PRUNE__*/
