#!/bin/sh
#
# stamp version to version.c
#
# Copyright (c) 1991-2000 Kyoto University
# Copyright (c) 2000-2001 NAIST
# All rights reserved
#
# $Id: stamp_version.sh,v 1.1.1.1 2001/07/29 07:01:59 sumiyosi Exp $
#


HOST=`uname -n`
DATE=`/bin/sh -c 'LANG=C date'`
cat << EOM > version.c
/* this file is auto-generated by stamp_version.sh */

#include <julius.h>
void
put_header(FILE *strm){
  fprintf(strm,"%s rev.%s (%s)\n", PRODUCTNAME, VERSION, SETUP);
  fprintf(strm,"built on %s at %s\n", "$HOST", "$DATE");
  /* to detect object link error with main.o */
#ifdef WORD_GRAPH
  verify_WORD_GRAPH_define();
#else
  verify_WORD_GRAPH_undefine();
#endif
#ifdef WPAIR
  verify_WPAIR_define();
#else
  verify_WPAIR_undefine();
#endif
}
void
put_compile_defs(FILE *strm){
  fprintf(strm," - compiler: $1 $2\n");
  fprintf(strm," - options:$3\n");
}
EOM
