/**
 * @file   rdhmmdef.c
 * @author Akinobu LEE
 * @date   Wed Feb 16 00:17:18 2005
 * 
 * <JA>
 * @brief  HTK %HMM եɤ߹ߡᥤ
 *
 * ˤ HTK  %HMM եɤ߹िδؿƤӽФ
 * ᥤؿƤޤ
 *
 * ΥեϤޤɤ߹ߴؿǶ̤Ѥȡñ̤
 * եɤ߹ߴؿ󶡤ޤ
 * %HMM ե read_token() ˤäƥȡñ̤ǽ缡ɤ߹ޤ졤
 * Хѿ rdhmmdef_token ˳ǼޤƴؿϤ
 * rdhmmdef_token 򻲾ȤƸߤΥȡޤ
 * </JA>
 * 
 * <EN>
 * @brief  Read HTK %HMM definition file: the main
 *
 * This file includes the main routine to read the %HMM definition file in
 * HTK format.
 *
 * This file also contains functions and global variables for per-token
 * reading tailored for reading HTK %HMM definition file.  The read_token()
 * will read the file per token, and the read token is stored in a global
 * variable rdhmmdef_token.  The other reading function will refer to this
 * variable to read the current token.
 * </EN>
 * 
 * $Revision:$
 * 
 */
/*
 * Copyright (c) 1991-2005 Kawahara Lab., Kyoto University
 * Copyright (c) 2000-2005 Shikano Lab., Nara Institute of Science and Technology
 * Copyright (c) 2005      Julius project team, Nagoya Institute of Technology
 * All rights reserved
 */

#include <sent/stddefs.h>
#include <sent/htk_param.h>
#include <sent/htk_hmm.h>

#define MAXBUFLEN  4096		///< Maximum length of a line in the input

char *rdhmmdef_token;		///< Current token string (GLOBAL)
static char *buf = NULL;	///< Local work area for token reading
static int line;		///< Input Line count

/* global functions for rdhmmdef_*.c */

/** 
 * Output error message, with current reading status.
 * 
 * @param str [in] error string
 */
void
rderr(char *str)
{
  if (rdhmmdef_token == NULL) {	/* end of file */
    j_error("\nError: %s on end of file\n", str);
  } else {
    j_error("\nError at line %d: %s\n", line, (str) ? str : "parse error");
  }
}

/** 
 * Read next token and ste it to rdhmmdef_token.
 * 
 * @param fp [in] file pointer
 * 
 * @return the pointer to the read token, or NULL on end of file or error.
 */
char *
read_token(FILE *fp)
{
  if (buf != NULL) {
    /* already have buffer */
    if ((rdhmmdef_token = mystrtok_quote(NULL, HMMDEF_DELM)) != NULL) {
      /* return next token */
      return rdhmmdef_token;
    }
  } else {
    /* init: allocate buffer for the first time */
    buf = (char *)mymalloc(MAXBUFLEN);
    line = 1;
  }
  /* read new 1 line */
  if (getl(buf, MAXBUFLEN, fp) == NULL) {
    rdhmmdef_token = NULL;
  } else {
    rdhmmdef_token = mystrtok_quote(buf, HMMDEF_DELM);
    line++;
  }
  return rdhmmdef_token;
}

/** 
 * Convert all the transition probabilities to log10 scale.
 * 
 * @param hmm [i/o] %HMM definition data to modify.
 */
static void
conv_log_arc(HTK_HMM_INFO *hmm)
{
  HTK_HMM_Trans *tr;
  int i,j;
  LOGPROB l;

  for (tr = hmm->trstart; tr; tr = tr->next) {
    for(i=0;i<tr->statenum;i++) {
      for(j=0;j<tr->statenum;j++) {
	l = tr->a[i][j];
	tr->a[i][j] = (l != 0.0) ? (float)log10(l) : LOG_ZERO;
      }
    }
  }
}


/** 
 * Initialize the %HMM definition data by setting default values.
 * 
 * @param hmm [i/o] %HMM definition data to initialize.
 */
void
init_hmm(HTK_HMM_INFO *hmm)
{
  /* set default options */
  hmm->opt.stream_info.num = 1;
  hmm->opt.cov_type = C_DIAG_C;
  hmm->opt.dur_type = D_NULL;

  hmm->trstart = NULL;
  hmm->vrstart = NULL;
  hmm->ststart = NULL;
  hmm->dnstart = NULL;
  hmm->start   = NULL;
  hmm->lgstart = NULL;
  hmm->physical_root = NULL;
  hmm->logical_root = NULL;
  hmm->tr_root = NULL;
  hmm->vr_root = NULL;
  hmm->dn_root = NULL;
  hmm->st_root = NULL;
  hmm->codebooknum = 0;
  hmm->codebook_root = NULL;
  hmm->maxcodebooksize = 0;
  hmm->totalmixnum = 0;
  hmm->totalstatenum = 0;
  hmm->totalhmmnum = 0;
  hmm->totallogicalnum = 0;
  hmm->is_triphone = FALSE;
  hmm->is_tied_mixture = FALSE;
  hmm->cdset_method = IWCD_NBEST;
  hmm->cdmax_num = 3;
  hmm->totalpseudonum = 0;
}

/** 
 * @brief  Main top routine to read in HTK %HMM definition file.
 *
 * A HTK %HMM definition file will be read from @a fp.  After reading,
 * the parameter type is checked and calculate some statistics.
 * 
 * @param fp [in] file pointer
 * @param hmm [out] pointer to a %HMM definition structure to store data.
 * 
 * @return TRUE on success, FALSE on failure.
 */
boolean
rdhmmdef(FILE *fp, HTK_HMM_INFO *hmm)
{
  char macrosw;
  char *name;

  /* initialize hmm data */
  init_hmm(hmm);
  
  /* read the first token */
  read_token(fp);
  
  /* the toplevel loop */
  while (rdhmmdef_token != NULL) {/* break on EOF */
    if (rdhmmdef_token[0] != '~') { /* toplevel commands are always macro */
      return FALSE;
    }
    macrosw = rdhmmdef_token[1];
    read_token(fp);		/* read next token after the "~.."  */
    switch(macrosw) {
    case 'o':			/* global option */
      set_global_opt(fp,hmm);
      break;
    case 't':			/* transition macro */
      name = mybstrdup(rdhmmdef_token);
      if (strlen(name) >= MAX_HMMNAME_LEN) rderr("Macro name too long");
      read_token(fp);
      def_trans_macro(name, fp, hmm);
      break;
    case 's':			/* state macro */
      name = mybstrdup(rdhmmdef_token);
      if (strlen(name) >= MAX_HMMNAME_LEN) rderr("Macro name too long");
      read_token(fp);
      def_state_macro(name, fp, hmm);
      break;
    case 'm':			/* density (mixture) macro */
      name = mybstrdup(rdhmmdef_token);
      if (strlen(name) >= MAX_HMMNAME_LEN) rderr("Macro name too long");
      read_token(fp);
      def_dens_macro(name, fp, hmm);
      break;
    case 'h':			/* HMM define */
      name = mybstrdup(rdhmmdef_token);
      if (strlen(name) >= MAX_HMMNAME_LEN) rderr("Macro name too long");
      read_token(fp);
      def_HMM(name, fp, hmm);
      break;
    case 'v':			/* Variance macro */
      name = mybstrdup(rdhmmdef_token);
      if (strlen(name) >= MAX_HMMNAME_LEN) rderr("Macro name too long");
      read_token(fp);
      def_var_macro(name, fp, hmm);
      break;
    case 'r':			/* Regression class macro (ignore) */
      name = mybstrdup(rdhmmdef_token);
      if (strlen(name) >= MAX_HMMNAME_LEN) rderr("Macro name too long");
      read_token(fp);
      def_regtree_macro(name, fp, hmm);
      break;
    }
  }

  j_printerr("(ascii)...");
  
  /* check limitation */
  if (check_all_hmm_limit(hmm)) {
    j_printerr("limit check passed\n");
  } else {
    j_error("Error: cannot use this HMM for system limitation.\n");
  }
  /* convert transition prob to log scale */
  conv_log_arc(hmm);
  
  /* check HMM parameter option type */
  if (!check_hmm_options(hmm)) {
    j_error("hmm options check failed\n");
  }

  /* add ID number for all HTK_HMM_State */
  /* also calculate the maximum number of mixture */
  {
    HTK_HMM_State *stmp;
    int n, max;
    n = 0;
    max = 0;
    for (stmp = hmm->ststart; stmp; stmp = stmp->next) {
      if (max < stmp->mix_num) max = stmp->mix_num;
      stmp->id = n++;
      if (n >= MAX_STATE_NUM) {
	j_error("Error: too much states > %d\n", MAX_STATE_NUM);
      }
    }
    hmm->totalstatenum = n;
    hmm->maxmixturenum = max;
  }
  /* compute total number of HMM models and maximum length */
  {
    HTK_HMM_Data *dtmp;
    int n, maxlen;
    n = 0;
    maxlen = 0;
    for (dtmp = hmm->start; dtmp; dtmp = dtmp->next) {
      if (maxlen < dtmp->state_num) maxlen = dtmp->state_num;
      n++;
    }
    hmm->maxstatenum = maxlen;
    hmm->totalhmmnum = n;
  }
  /* compute total number of mixtures */
  {
    HTK_HMM_Dens *dtmp;
    int n = 0;
    for (dtmp = hmm->dnstart; dtmp; dtmp = dtmp->next) {
      n++;
    }
    hmm->totalmixnum = n;
  }
  /* check of HMM name length exceed the maximum */
  {
    HTK_HMM_Dens *dtmp;
    int n = 0;
    for (dtmp = hmm->dnstart; dtmp; dtmp = dtmp->next) {
      n++;
    }
    hmm->totalmixnum = n;
  }

  return(TRUE);			/* success */
}
