/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* globalvars.h --- define global variables for outprob*.c */

/* $Id: globalvars.h,v 1.4 2004/03/22 04:14:31 ri Exp $ */

/* these are used to minimize function call overhead */
/* If GLOBAL_VARIABLE_DEFINE is defined, global variables are actually made */
/* Else, these are external definition */
#ifdef GLOBAL_VARIABLE_DEFINE
#define GLOBAL /*  */
#define GLOBAL_VAL(v) = (v)
#else
#define GLOBAL extern
#define GLOBAL_VAL(v) /*  */
#endif

/* functions selected */
GLOBAL LOGPROB (*calc_outprob)();
GLOBAL LOGPROB (*calc_outprob_state)();
GLOBAL void (*compute_gaussset)(HTK_HMM_Dens **g, int num, int *last_id);
GLOBAL boolean (*compute_gaussset_init)();

/* for instant access */
GLOBAL HTK_HMM_INFO *OP_hmminfo;
GLOBAL HTK_HMM_INFO *OP_gshmm;
GLOBAL int OP_gprune_num;

GLOBAL HTK_Param *OP_param;	/* current parameter */
GLOBAL HTK_HMM_State *OP_state;	/* current state */
GLOBAL int OP_state_id;		/* current state ID */
GLOBAL int OP_time;		/* current time */
GLOBAL int OP_last_time;	/* last time */
GLOBAL VECT *OP_vec;		/* current input vector */
GLOBAL short OP_veclen;		/* vector length */

/* work buffer for compute_gsset */
GLOBAL LOGPROB *OP_calced_score;
GLOBAL int *OP_calced_id;
GLOBAL int OP_calced_num;
GLOBAL int OP_calced_maxnum;
