/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* rdhmmdef_var.c --- read in hmmdefs (variance) */

/* $Id: rdhmmdef_var.c,v 1.6 2004/03/22 04:14:31 ri Exp $ */

/* currenty cannot treat other sub macros (~u,~i,~x) */

#include <sent/stddefs.h>
#include <sent/htk_hmm.h>

extern char *rdhmmdef_token;

/* malloc new */
static HTK_HMM_Var *
var_new()
{
  HTK_HMM_Var *new;

  new = (HTK_HMM_Var *)mymalloc(sizeof(HTK_HMM_Var));

  new->name = NULL;
  new->vec = NULL;
  new->len = 0;
  new->next = NULL;

  return(new);
}

/* register */
void
var_add(HTK_HMM_INFO *hmm, HTK_HMM_Var *new)
{
  HTK_HMM_Var *match;

  /* link data structure */
  new->next = hmm->vrstart;
  hmm->vrstart = new;
  
  if (new->name != NULL) {
    /* add index to search index tree */
    if (hmm->vr_root == NULL) {
      hmm->vr_root = aptree_make_root_node(new);
    } else {
      match = aptree_search_data(new->name, hmm->vr_root);
      if (strmatch(match->name, new->name)) {
	j_printerr("Error: ~v \"%s\" is already defined\n", new->name);
	rderr(NULL);
      } else {
	aptree_add_entry(new->name, new, match->name, &(hmm->vr_root));
      }
    }
  }
  
}

/* lookup by name */
static HTK_HMM_Var *
var_lookup(HTK_HMM_INFO *hmm, char *keyname)
{
  HTK_HMM_Var *v;

  v = aptree_search_data(keyname, hmm->vr_root);
  if (strmatch(v->name, keyname)) {
    return v;
  } else {
    return NULL;
  }
}


/* read in var data and return new (malloced) HTK_HMM_Var */
static HTK_HMM_Var *
var_read(FILE *fp)
{
  HTK_HMM_Var *new;
  int i;

  new = var_new();

  /* read covariance matrix (diagonal vector) */

  if (!currentis("VARIANCE")) {
    j_printerr("variance matrix type \"%s\" not supported\n", rdhmmdef_token);
    rderr(NULL);
  } else {
    read_token(fp);
    NoTokErr("missing VARIANCE vector length");
    new->len = atoi(rdhmmdef_token);
    read_token(fp);
    new->vec = (VECT *)mybmalloc(sizeof(VECT) * new->len);
    /* needs comversion if integerized */
    for (i=0;i<new->len;i++) {
      NoTokErr("missing some VARIANCE element");
      new->vec[i] = atof(rdhmmdef_token);
      read_token(fp);
    }
  }

  return (new);
}

/* read in variance data at the current point, and
   return pointer to the data */
HTK_HMM_Var *
get_var_data(FILE *fp, HTK_HMM_INFO *hmm)
{
  HTK_HMM_Var *tmp;

  if (currentis("~v")) {
    /* macro reference: lookup and return the pointer */
    read_token(fp);
    NoTokErr("missing VARIANCE macro name");
    tmp = var_lookup(hmm, rdhmmdef_token);
    if (tmp == NULL) {
      j_printerr("~v \"%s\" not defined\n", rdhmmdef_token);
      rderr(NULL);
    }
    read_token(fp);
    return tmp;
  } else if (currentis("VARIANCE")){
    /* definition: define variance data, and return the pointer */
    tmp = var_read(fp);
    tmp->name = NULL; /* no name */
    var_add(hmm, tmp);
    return tmp;
  } else {
    rderr("no variance data");
    return NULL;
  }
}


/* define density data */
void
def_var_macro(char *name, FILE *fp, HTK_HMM_INFO *hmm)
{
  HTK_HMM_Var *new;

  
  /* read in data and return newly malloced data */
  new = var_read(fp);

  /* register it to the grobal HMM structure */
  new->name = name;
  var_add(hmm, new);
}
