/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* m_adin.c --- initialize input device */

/* $Id: m_adin.c,v 1.9 2004/03/22 04:14:31 ri Exp $ */

#include <julius.h>

/* initialize adin devices */
void
adin_initialize()
{
  char *arg;
  boolean igsp = TRUE;

  if (speech_input == SP_MFCFILE) return; /* no need to initialize */
  
  VERMES("###### initialize input device\n");

  /* select input device: file, mic, netaudio, etc... */
  if (adin_select(speech_input) == FALSE) {
    j_error("Error: invalid input device\n");
  }

  /* set sampling frequency and device-dependent configuration
     (argument is device-dependent) */
  switch(speech_input) {
  case SP_ADINNET:		/* arg: port number */
    arg = mybmalloc(100);
    sprintf(arg, "%d", adinnet_port);
    break;
  case SP_RAWFILE:		/* arg: filename of file list (if any) */
    if (inputlist_filename != NULL) {
      arg = mybmalloc(strlen(inputlist_filename)+1);
      strcpy(arg, inputlist_filename);
    } else {
      arg = NULL;
    }
    break;
  case SP_STDIN:
    arg = NULL;
    break;
#ifdef USE_NETAUDIO
  case SP_NETAUDIO:		/* netaudio server/port name */
    arg = mybmalloc(strlen(netaudio_devname)+1);
    strcpy(arg, netaudio_devname);
    break;
#endif
  }

  if (speech_input == SP_MIC) {
#ifdef SP_BREAK_CURRENT_FRAME
    igsp = FALSE;		/* does not drop speech while decoding */
#endif
  }
  
  if (adin_standby(smpFreq, arg) == FALSE) { /* fail */
    j_error("Error: failed to ready input device\n");
  }

  /* set parameter for recording/silence detection */
  adin_setup_param(silence_cut,/* silence cutting: 0=off,1=on,2=use device default */
		   strip_zero_sample, /* strip zero sample if TRUE */
		   level_thres,	/* trigger level threshold (0-32767) */
		   zero_cross_num, /* zero-cross num for silence detection */
		   head_margin_msec, /* margin at beginning of input segment */
		   tail_margin_msec, /* margin at end of input segment */
		   smpFreq,	/* sampling frequency */
		   igsp,	/* TRUE if ignore speech while decoding */
		   use_zmean);	/* TRUE if need zmeansource */
  
}
