/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* beam.h --- token structure for 1st pass beam search */

/* $Id: beam.h,v 1.6 2004/03/22 04:14:31 ri Exp $ */

#ifndef __J_BEAM_H__
#define __J_BEAM_H__

typedef int TOKENID;
#define TOKENID_UNDEFINED -1	/* ID number for undefined token ID */

typedef struct __sent_token2__ {
  TRELLIS_ATOM *last_tre;	/* previous word hypothesis on word trellis */
#ifdef USE_NGRAM
  WORD_ID last_cword;		/* last context-aware (not transparent) word ID */
  LOGPROB last_lscore;		/* currently assigned word-internal LM score (for factoring) */
#endif
  LOGPROB score;		/* current accumulated score (AM+LM) */
  int node;			/* lexicon node ID to which this token is assigned */
#ifdef WPAIR			/* wpair generates more than one token for a node */
  TOKENID next;			/* ID pointer to next token at same node */
#endif
} TOKEN2;

#define FILLWIDTH 70		/* word-wrap character length for progout*/

#endif /* __J_BEAM_H__ */
