/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* j_printf.c --- generic message output and error exit for libsent function */

/* $Id: j_printf.c,v 1.6 2004/03/23 03:00:16 ri Exp $ */

/* user can register callback for j_error() and j_exit() by
   j_error_reggister_exitfunc() and j_exit_register_func() */

#include <sent/stddefs.h>
#include <stdarg.h>

/* output message (to stdout) */
int
j_printf(char *fmt, ...)
{
  va_list ap;
  int ret;
  va_start(ap,fmt);
  ret = vprintf(fmt, ap);
  va_end(ap);
  return(ret);
}

/* output error message (to stderr) */
int
j_printerr(char *fmt, ...)
{
  va_list ap;
  int ret;
  va_start(ap,fmt);
  ret = vfprintf(stderr, fmt, ap);
  va_end(ap);
  return(ret);
}

/* flush output */
int
j_flushprint()
{
  return(fflush(stdout));
}


/* exit program with error */
static void (*error_func)() = NULL;
/* register callback function for j_error() */
void
j_error_register_exitfunc(void (*f)())
{
  error_func = f;
}
/* output error and exit */
void
j_error(char *fmt, ...)
{
  va_list ap;
  int ret;
  va_start(ap,fmt);
  ret = vfprintf(stderr, fmt, ap);
  va_end(ap);
  if (error_func != NULL) (*error_func)(); /* call external error function */
  else exit(1);
}

/* normal exit end  */
static void (*exit_func)() = NULL;
/* register callback function for j_exit() */
void
j_exit_register_exitfunc(void (*f)())
{
  exit_func = f;
}
/* output message and exit */
void
j_exit()
{
  if (exit_func != NULL) (*exit_func)(); /* call external error function */
  else exit(0);
}
