/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* ngram_util.c --- ngram utility functions */

/* $Id: ngram_util.c,v 1.4 2004/03/22 04:14:31 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/ngram2.h>


/* return N-gram size */
static int
get_unigram_size(NGRAM_INFO *ndata)
{
  int unitsize;
  unitsize = sizeof(LOGPROB) * 3 + sizeof(NNID) + sizeof(WORD_ID);
  return(unitsize * ndata->ngram_num[0]);
}

static int
get_bigram_size(NGRAM_INFO *ndata)
{
  int unitsize;

  unitsize = sizeof(WORD_ID) * 2 + sizeof(LOGPROB) * 3 + sizeof(NNID);
  return(unitsize * ndata->ngram_num[1]);
}
  
static int
get_trigram_size(NGRAM_INFO *ndata)
{
  int unitsize;

  unitsize = sizeof(WORD_ID) + sizeof(LOGPROB);
  return(unitsize * ndata->ngram_num[2]);
}
  

/* print ngram information */
void
print_ngram_info(NGRAM_INFO *ndata)
{
  j_printf("N-gram info:\n");
  if (ndata->isopen) {
    j_printf("\t        OOV word = %s(id=%d)\n", ndata->wname[ndata->unk_id],ndata->unk_id);
    j_printf("\t        OOV size = %d words in dict\n", ndata->unk_num);
  } else {
    j_printf("\t        OOV word = none\n");
  }
  j_printf("\t   wordset size  = %8d\n", ndata->max_word_num);
  j_printf("\tuni-gram entries = %8d (%8d bytes)\n",
	 ndata->ngram_num[0], get_unigram_size(ndata));
  j_printf("\t  bi-gram tuples = %8d (%8d bytes)\n",
	 ndata->ngram_num[1], get_bigram_size(ndata));
  j_printf("\t tri-gram tuples = %8d (%8d bytes)\n",
	 ndata->ngram_num[2], get_trigram_size(ndata));
}
