/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* guess_cdHMM.c --- guess whether hmminfo is a context-dependent model
   decision by naming rule */

/* $Id: guess_cdHMM.c,v 1.5 2004/03/22 04:14:31 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/htk_hmm.h>

boolean
guess_if_cd_hmm(HTK_HMM_INFO *hmminfo)
{
  HMM_Logical *dt;
  int rnum, lnum, totalnum;

  /* check if there is a logical HMM whose name includes either HMM_RC_DLIM
     or HMM_LC_DLIM */
  rnum = lnum = totalnum = 0;
  for (dt = hmminfo->lgstart; dt; dt = dt->next) {
    if (strstr(dt->name, HMM_RC_DLIM) != NULL) rnum++;
    if (strstr(dt->name, HMM_LC_DLIM) != NULL) lnum++;
    totalnum++;
  }
  if (rnum > 0) {
    if (lnum == 0) {
      j_printerr("Warning: cannot handle right-context dependency correctly\n");
      return(FALSE);
    } else {
      return(TRUE);
    }
  }
  return(FALSE);
}
